/*
 * Decompiled with CFR 0.152.
 */
package com.github.appintro.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.VibratorManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/appintro/internal/VibrationHelper;", "", "()V", "vibrator", "Landroid/os/Vibrator;", "initializeVibrator", "", "context", "Landroid/content/Context;", "vibrate", "vibrateDuration", "", "appintro_release"})
public final class VibrationHelper {
    @NotNull
    public static final VibrationHelper INSTANCE = new VibrationHelper();
    @Nullable
    private static Vibrator vibrator;

    private VibrationHelper() {
    }

    private final void initializeVibrator(Context context) {
        Vibrator vibrator;
        if (Build.VERSION.SDK_INT >= 31) {
            Object object = context.getSystemService("vibrator_manager");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.VibratorManager");
            VibratorManager vibratorManager = (VibratorManager)object;
            vibrator = vibratorManager.getDefaultVibrator();
        } else {
            Object object = context.getSystemService("vibrator");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.Vibrator");
            vibrator = (Vibrator)object;
        }
        VibrationHelper.vibrator = vibrator;
    }

    @SuppressLint(value={"MissingPermission"})
    public final void vibrate(@NotNull Context context, long vibrateDuration) {
        block2: {
            block1: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (vibrator == null) {
                    this.initializeVibrator(context);
                }
                if (Build.VERSION.SDK_INT < 26) break block1;
                Vibrator vibrator = VibrationHelper.vibrator;
                if (vibrator == null) break block2;
                vibrator.vibrate(VibrationEffect.createOneShot((long)vibrateDuration, (int)-1));
                break block2;
            }
            Vibrator vibrator = VibrationHelper.vibrator;
            if (vibrator == null) break block2;
            vibrator.vibrate(vibrateDuration);
        }
    }
}

