/*
 * Decompiled with CFR 0.152.
 */
package com.github.appintro.indicator;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.github.appintro.R;
import com.github.appintro.indicator.IndicatorController;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/github/appintro/indicator/DotIndicatorController;", "Lcom/github/appintro/indicator/IndicatorController;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "currentPosition", "", "value", "selectedIndicatorColor", "getSelectedIndicatorColor", "()I", "setSelectedIndicatorColor", "(I)V", "slideCount", "unselectedIndicatorColor", "getUnselectedIndicatorColor", "setUnselectedIndicatorColor", "initialize", "", "newInstance", "Landroid/view/View;", "selectPosition", "index", "appintro_release"})
public final class DotIndicatorController
extends LinearLayout
implements IndicatorController {
    private int selectedIndicatorColor;
    private int unselectedIndicatorColor;
    private int currentPosition;
    private int slideCount;

    @Override
    public int getSelectedIndicatorColor() {
        return this.selectedIndicatorColor;
    }

    @Override
    public void setSelectedIndicatorColor(int value) {
        this.selectedIndicatorColor = value;
        this.selectPosition(this.currentPosition);
    }

    @Override
    public int getUnselectedIndicatorColor() {
        return this.unselectedIndicatorColor;
    }

    @Override
    public void setUnselectedIndicatorColor(int value) {
        this.unselectedIndicatorColor = value;
        this.selectPosition(this.currentPosition);
    }

    @Override
    @NotNull
    public View newInstance(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LinearLayout.LayoutParams newLayoutParams = new LinearLayout.LayoutParams(-2, -1);
        newLayoutParams.gravity = 16;
        this.setLayoutParams((ViewGroup.LayoutParams)newLayoutParams);
        this.setOrientation(0);
        this.setGravity(17);
        return (View)this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(int slideCount) {
        this.slideCount = slideCount;
        int n = 0;
        int n2 = slideCount;
        while (n < n2) {
            void i;
            ImageView dot = new ImageView(this.getContext());
            dot.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_appintro_indicator));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            if (slideCount == 1) {
                dot.setVisibility(4);
            }
            this.addView((View)dot, (ViewGroup.LayoutParams)params);
            ++i;
        }
        this.selectPosition(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void selectPosition(int index) {
        this.currentPosition = index;
        int n = 0;
        int n2 = this.slideCount;
        while (n < n2) {
            void i;
            int tint = i == index ? this.getSelectedIndicatorColor() : this.getUnselectedIndicatorColor();
            View view = this.getChildAt((int)i);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.ImageView");
            }
            ImageView imageView = (ImageView)view;
            boolean bl = false;
            boolean bl2 = false;
            ImageView it = imageView;
            boolean bl3 = false;
            DrawableCompat.setTint((Drawable)it.getDrawable(), (int)tint);
            ++i;
        }
    }

    public DotIndicatorController(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.selectedIndicatorColor = ContextCompat.getColor((Context)context, (int)R.color.appintro_default_selected_color);
        this.unselectedIndicatorColor = ContextCompat.getColor((Context)context, (int)R.color.appintro_default_unselected_color);
    }
}

