/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.FontRes;
import com.github.paolorotolo.appintro.AppIntroBase;
import com.github.paolorotolo.appintro.R;
import com.github.paolorotolo.appintro.internal.TypefaceContainer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u0010\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\b\u001a\u00020\u00062\b\b\u0001\u0010\t\u001a\u00020\u0004J\u0010\u0010\n\u001a\u00020\u00062\b\b\u0001\u0010\u000b\u001a\u00020\u0004J\u0010\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\u0017\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\u0018\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0019\u001a\u00020\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u0004J\u0010\u0010\u0019\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u000e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c\u00a8\u0006\u001e"}, d2={"Lcom/github/paolorotolo/appintro/AppIntro;", "Lcom/github/paolorotolo/appintro/AppIntroBase;", "()V", "getLayoutId", "", "setBarColor", "", "color", "setColorDoneText", "colorDoneText", "setColorSkipButton", "colorSkipButton", "setDoneText", "text", "", "setDoneTextTypeface", "typeface", "typeURL", "", "setImageNextButton", "imageNextButton", "Landroid/graphics/drawable/Drawable;", "setNextArrowColor", "setSeparatorColor", "setSkipText", "setSkipTextTypeface", "showDoneButton", "showDone", "", "showSeparator", "appintro_release"})
public abstract class AppIntro
extends AppIntroBase {
    @Override
    protected int getLayoutId() {
        return R.layout.appintro_intro_layout;
    }

    public final void setBarColor(@ColorInt int color) {
        View bottomBar = this.findViewById(R.id.bottom);
        bottomBar.setBackgroundColor(color);
    }

    public final void setNextArrowColor(@ColorInt int color) {
        ImageButton nextButton = (ImageButton)this.findViewById(R.id.next);
        nextButton.setColorFilter(color);
    }

    public final void setSeparatorColor(@ColorInt int color) {
        View separator = this.findViewById(R.id.bottom_separator);
        separator.setBackgroundColor(color);
    }

    public final void setSkipText(@Nullable CharSequence text) {
        TextView skipText;
        TextView textView = skipText = (TextView)this.findViewById(R.id.skip);
        Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"skipText");
        textView.setText(text);
    }

    public final void setSkipTextTypeface(@FontRes int typeface) {
        TextView view = (TextView)this.findViewById(R.id.skip);
        new TypefaceContainer(null, typeface).applyTo(view);
    }

    public final void setSkipTextTypeface(@Nullable String typeURL) {
        TextView view = (TextView)this.findViewById(R.id.skip);
        new TypefaceContainer(typeURL, 0).applyTo(view);
    }

    public final void setDoneText(@Nullable CharSequence text) {
        TextView doneText;
        TextView textView = doneText = (TextView)this.findViewById(R.id.done);
        Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"doneText");
        textView.setText(text);
    }

    public final void setDoneTextTypeface(@Nullable String typeURL) {
        TextView view = (TextView)this.findViewById(R.id.done);
        new TypefaceContainer(typeURL, 0).applyTo(view);
    }

    public final void setDoneTextTypeface(@FontRes int typeface) {
        TextView view = (TextView)this.findViewById(R.id.done);
        new TypefaceContainer(null, typeface).applyTo(view);
    }

    public final void setColorDoneText(@ColorInt int colorDoneText) {
        TextView doneText = (TextView)this.findViewById(R.id.done);
        doneText.setTextColor(colorDoneText);
    }

    public final void setColorSkipButton(@ColorInt int colorSkipButton) {
        TextView skip = (TextView)this.findViewById(R.id.skip);
        skip.setTextColor(colorSkipButton);
    }

    public final void setImageNextButton(@NotNull Drawable imageNextButton) {
        Intrinsics.checkParameterIsNotNull((Object)imageNextButton, (String)"imageNextButton");
        ImageView nextButton = (ImageView)this.findViewById(R.id.next);
        nextButton.setImageDrawable(imageNextButton);
    }

    @Deprecated(message="use {@link #setProgressButtonEnabled(boolean)} instead.", replaceWith=@ReplaceWith(imports={}, expression="isProgressButtonEnabled = showDone"))
    public final void showDoneButton(boolean showDone) {
        this.setProgressButtonEnabled(showDone);
    }

    public final void showSeparator(boolean showSeparator) {
        View bottomSeparator = this.findViewById(R.id.bottom_separator);
        if (showSeparator) {
            View view = bottomSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"bottomSeparator");
            view.setVisibility(0);
        } else {
            View view = bottomSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"bottomSeparator");
            view.setVisibility(4);
        }
    }
}

