/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.graphics.drawable.Drawable;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.FontRes;
import androidx.annotation.Nullable;
import com.github.paolorotolo.appintro.AppIntroBase;
import com.github.paolorotolo.appintro.R;
import com.github.paolorotolo.appintro.util.LogHelper;
import com.github.paolorotolo.appintro.util.TypefaceContainer;

public abstract class AppIntro
extends AppIntroBase {
    private static final String TAG = LogHelper.makeLogTag(AppIntro.class);

    @Override
    protected int getLayoutId() {
        return R.layout.appintro_intro_layout;
    }

    public void setBarColor(@ColorInt int color) {
        LinearLayout bottomBar = (LinearLayout)this.findViewById(R.id.bottom);
        bottomBar.setBackgroundColor(color);
    }

    public void setNextArrowColor(@ColorInt int color) {
        ImageButton nextButton = (ImageButton)this.findViewById(R.id.next);
        nextButton.setColorFilter(color);
    }

    public void setSeparatorColor(@ColorInt int color) {
        TextView separator = (TextView)this.findViewById(R.id.bottom_separator);
        separator.setBackgroundColor(color);
    }

    public void setSkipText(@Nullable CharSequence text) {
        TextView skipText = (TextView)this.findViewById(R.id.skip);
        skipText.setText(text);
    }

    public void setSkipTextTypeface(@FontRes int typeface) {
        TextView view = (TextView)this.findViewById(R.id.skip);
        new TypefaceContainer(null, typeface).applyTo(view);
    }

    public void setSkipTextTypeface(@Nullable String typeURL) {
        TextView view = (TextView)this.findViewById(R.id.skip);
        new TypefaceContainer(typeURL, 0).applyTo(view);
    }

    public void setDoneText(@Nullable CharSequence text) {
        TextView doneText = (TextView)this.findViewById(R.id.done);
        doneText.setText(text);
    }

    public void setDoneTextTypeface(@Nullable String typeURL) {
        TextView view = (TextView)this.findViewById(R.id.done);
        new TypefaceContainer(typeURL, 0).applyTo(view);
    }

    public void setDoneTextTypeface(@FontRes int typeface) {
        TextView view = (TextView)this.findViewById(R.id.done);
        new TypefaceContainer(null, typeface).applyTo(view);
    }

    public void setColorDoneText(@ColorInt int colorDoneText) {
        TextView doneText = (TextView)this.findViewById(R.id.done);
        doneText.setTextColor(colorDoneText);
    }

    public void setColorSkipButton(@ColorInt int colorSkipButton) {
        TextView skip = (TextView)this.findViewById(R.id.skip);
        skip.setTextColor(colorSkipButton);
    }

    public void setImageNextButton(Drawable imageNextButton) {
        ImageView nextButton = (ImageView)this.findViewById(R.id.next);
        nextButton.setImageDrawable(imageNextButton);
    }

    @Deprecated
    public void showDoneButton(boolean showDone) {
        this.setProgressButtonEnabled(showDone);
    }

    public void showSeparator(boolean showSeparator) {
        TextView bottomSeparator = (TextView)this.findViewById(R.id.bottom_separator);
        if (showSeparator) {
            bottomSeparator.setVisibility(0);
        } else {
            bottomSeparator.setVisibility(4);
        }
    }
}

