/*
 * Decompiled with CFR 0.152.
 */
package ove.alphazero.util;

import java.util.HashMap;
import java.util.Map;

public final class CmdLineArgs {
    static final String PREFIX_FLAG = "--";
    static final String PREFIX_OPT = "-";
    final Map<String, String> map;
    final Spec spec;

    private CmdLineArgs(Spec spec, Map<String, String> map) {
        assert (map != null) : "map is null";
        this.spec = spec;
        this.map = map;
    }

    public boolean checkFlag(String f) {
        return this.map.containsKey(CmdLineArgs.flagKey(f));
    }

    public String getOption(String k, String defval) {
        String v = this.map.get(CmdLineArgs.optKey(k));
        if (v == null) {
            v = defval;
        }
        return v;
    }

    public String getOptionStrict(String k) {
        return CmdLineArgs.assertNotNull(this.map.get(CmdLineArgs.optKey(k)), "must specify required option " + k);
    }

    public int getIntOption(String k, int defval) {
        int res = defval;
        String optv = this.getOption(k, null);
        if (optv != null) {
            res = CmdLineArgs.decodeInt(optv, "invalid value for numeric option " + k);
        }
        return res;
    }

    public String getparam(int n) {
        return this.map.get(CmdLineArgs.paramKey(n));
    }

    private static String paramKey(int n) {
        return String.format("$%d", n);
    }

    private static String flagKey(String f) {
        return String.format("%s%s", PREFIX_FLAG, f);
    }

    private static String optKey(String o) {
        return String.format("%s%s", PREFIX_OPT, o);
    }

    public static CmdLineArgs parse(Spec spec, String ... args) {
        if (args == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int fn = 0;
        int on = 0;
        int pn = 0;
        for (int i = 0; i < args.length; ++i) {
            String k = null;
            String v = null;
            if (args[i] == null) continue;
            if (args[i].startsWith(PREFIX_FLAG)) {
                v = k = args[i];
                ++fn;
            } else if (args[i].startsWith(PREFIX_OPT)) {
                CmdLineArgs.assert0(args.length - 1 > i, String.format("no value for arg %s at args end", args[i]));
                CmdLineArgs.assert0(!args[i + 1].startsWith(PREFIX_OPT), String.format("no value for arg %s", args[i]));
                CmdLineArgs.assert0(!args[i + 1].startsWith(PREFIX_FLAG), String.format("no value for arg %s", args[i]));
                k = args[i];
                v = args[++i];
                ++on;
            } else {
                k = CmdLineArgs.paramKey(++pn);
                v = args[i];
            }
            map.put(k, v);
        }
        return new CmdLineArgs(spec, map);
    }

    public static void assert0(boolean prop, String errmsg) throws IllegalStateException {
        if (!prop) {
            throw new IllegalStateException(errmsg);
        }
    }

    public static <T> T assertNotNull(T o, String errmsg) throws IllegalStateException {
        if (o == null) {
            throw new IllegalStateException(errmsg);
        }
        return o;
    }

    public static int decodeInt(String spec, String errmsg) throws IllegalArgumentException {
        int v;
        try {
            v = Integer.parseInt(spec);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format(errmsg, spec));
        }
        return v;
    }

    public static interface Spec {
    }
}

