/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

class PruneColumns
extends TypeUtil.SchemaVisitor<Type> {
    private final Set<Integer> selected;

    PruneColumns(Set<Integer> selected) {
        this.selected = selected;
    }

    @Override
    public Type schema(Schema schema, Type structResult) {
        return structResult;
    }

    @Override
    public Type struct(Types.StructType struct, List<Type> fieldResults) {
        List<Types.NestedField> fields = struct.fields();
        ArrayList selectedFields = Lists.newArrayListWithExpectedSize((int)fields.size());
        boolean sameTypes = true;
        for (int i = 0; i < fieldResults.size(); ++i) {
            Types.NestedField field = fields.get(i);
            Type projectedType = fieldResults.get(i);
            if (field.type() == projectedType) {
                selectedFields.add(field);
                continue;
            }
            if (projectedType == null) continue;
            sameTypes = false;
            if (field.isOptional()) {
                selectedFields.add(Types.NestedField.optional(field.fieldId(), field.name(), projectedType, field.doc()));
                continue;
            }
            selectedFields.add(Types.NestedField.required(field.fieldId(), field.name(), projectedType, field.doc()));
        }
        if (!selectedFields.isEmpty()) {
            if (selectedFields.size() == fields.size() && sameTypes) {
                return struct;
            }
            return Types.StructType.of(selectedFields);
        }
        return null;
    }

    @Override
    public Type field(Types.NestedField field, Type fieldResult) {
        if (this.selected.contains(field.fieldId())) {
            return field.type();
        }
        if (fieldResult != null) {
            return fieldResult;
        }
        return null;
    }

    @Override
    public Type list(Types.ListType list, Type elementResult) {
        if (this.selected.contains(list.elementId())) {
            return list;
        }
        if (elementResult != null) {
            if (list.elementType() == elementResult) {
                return list;
            }
            if (list.isElementOptional()) {
                return Types.ListType.ofOptional(list.elementId(), elementResult);
            }
            return Types.ListType.ofRequired(list.elementId(), elementResult);
        }
        return null;
    }

    @Override
    public Type map(Types.MapType map, Type ignored, Type valueResult) {
        if (this.selected.contains(map.valueId())) {
            return map;
        }
        if (valueResult != null) {
            if (map.valueType() == valueResult) {
                return map;
            }
            if (map.isValueOptional()) {
                return Types.MapType.ofOptional(map.keyId(), map.valueId(), map.keyType(), valueResult);
            }
            return Types.MapType.ofRequired(map.keyId(), map.valueId(), map.keyType(), valueResult);
        }
        if (this.selected.contains(map.keyId())) {
            return map;
        }
        return null;
    }

    @Override
    public Type primitive(Type.PrimitiveType primitive) {
        return null;
    }
}

