/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.TransformUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class Identity<T>
implements Transform<T, T> {
    private final Type type;

    public static <I> Identity<I> get(Type type) {
        return new Identity(type);
    }

    private Identity(Type type) {
        this.type = type;
    }

    @Override
    public T apply(T value) {
        return value;
    }

    @Override
    public boolean canTransform(Type maybePrimitive) {
        return maybePrimitive.isPrimitiveType();
    }

    @Override
    public Type getResultType(Type sourceType) {
        return sourceType;
    }

    @Override
    public UnboundPredicate<T> project(String name, BoundPredicate<T> predicate) {
        return this.projectStrict(name, predicate);
    }

    @Override
    public UnboundPredicate<T> projectStrict(String name, BoundPredicate<T> predicate) {
        if (predicate.isUnaryPredicate()) {
            return Expressions.predicate(predicate.op(), name);
        }
        if (predicate.isLiteralPredicate()) {
            return Expressions.predicate(predicate.op(), name, predicate.asLiteralPredicate().literal().value());
        }
        if (predicate.isSetPredicate()) {
            return Expressions.predicate(predicate.op(), name, predicate.asSetPredicate().literalSet());
        }
        return null;
    }

    @Override
    public String toHumanString(T value) {
        if (value == null) {
            return "null";
        }
        switch (this.type.typeId()) {
            case DATE: {
                return TransformUtil.humanDay((Integer)value);
            }
            case TIME: {
                return TransformUtil.humanTime((Long)value);
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)this.type).shouldAdjustToUTC()) {
                    return TransformUtil.humanTimestampWithZone((Long)value);
                }
                return TransformUtil.humanTimestampWithoutZone((Long)value);
            }
            case FIXED: 
            case BINARY: {
                if (value instanceof ByteBuffer) {
                    return TransformUtil.base64encode(((ByteBuffer)value).duplicate());
                }
                if (value instanceof byte[]) {
                    return TransformUtil.base64encode(ByteBuffer.wrap((byte[])value));
                }
                throw new UnsupportedOperationException("Unsupported binary type: " + value.getClass());
            }
        }
        return value.toString();
    }

    public String toString() {
        return "identity";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Identity)) {
            return false;
        }
        Identity that = (Identity)o;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type});
    }
}

