/*
 * Decompiled with CFR 0.152.
 */
package com.anthonynsimon.url;

import com.anthonynsimon.url.PercentEncoder;
import com.anthonynsimon.url.URL;
import com.anthonynsimon.url.URLBuilder;
import com.anthonynsimon.url.URLParser;
import com.anthonynsimon.url.exceptions.MalformedURLException;

final class DefaultURLParser
implements URLParser {
    DefaultURLParser() {
    }

    @Override
    public URL parse(String rawUrl) throws MalformedURLException {
        if (rawUrl == null || rawUrl.isEmpty()) {
            throw new MalformedURLException("raw url string is empty");
        }
        URLBuilder builder = new URLBuilder();
        String remaining = rawUrl;
        int index = remaining.lastIndexOf(35);
        if (index >= 0) {
            String frag = remaining.substring(index + 1, remaining.length());
            builder.setFragment(frag.isEmpty() ? null : frag);
            remaining = remaining.substring(0, index);
        }
        if (remaining.isEmpty()) {
            return builder.build();
        }
        if ("*".equals(remaining)) {
            builder.setPath("*");
            return builder.build();
        }
        index = remaining.indexOf(63);
        if (index > 0) {
            String query = remaining.substring(index + 1, remaining.length());
            if (query.isEmpty()) {
                builder.setQuery("?");
            } else {
                builder.setQuery(query);
            }
            remaining = remaining.substring(0, index);
        }
        PartialParseResult parsedScheme = this.parseScheme(remaining);
        String scheme = parsedScheme.result;
        boolean hasScheme = scheme != null && !scheme.isEmpty();
        builder.setScheme(scheme);
        remaining = parsedScheme.remaining;
        if (hasScheme && !remaining.startsWith("/")) {
            builder.setOpaque(remaining);
            return builder.build();
        }
        if ((hasScheme || !remaining.startsWith("///")) && remaining.startsWith("//")) {
            String authority = remaining = remaining.substring(2, remaining.length());
            int i = remaining.indexOf(47);
            if (i >= 0) {
                authority = remaining.substring(0, i);
                remaining = remaining.substring(i, remaining.length());
            } else {
                remaining = "";
            }
            if (!authority.isEmpty()) {
                UserInfoResult userInfoResult = this.parseUserInfo(authority);
                builder.setUsername(userInfoResult.user);
                builder.setPassword(userInfoResult.password);
                authority = userInfoResult.remaining;
            }
            PartialParseResult hostResult = this.parseHost(authority);
            builder.setHost(hostResult.result);
        }
        if (!remaining.isEmpty()) {
            builder.setPath(PercentEncoder.decode(remaining));
            builder.setRawPath(remaining);
        }
        return builder.build();
    }

    private PartialParseResult parseScheme(String remaining) throws MalformedURLException {
        int indexColon = remaining.indexOf(58);
        if (indexColon == 0) {
            throw new MalformedURLException("missing scheme");
        }
        if (indexColon < 0) {
            return new PartialParseResult("", remaining);
        }
        char first = remaining.charAt(0);
        if ('0' <= first && first <= '9' || first == '+' || first == '-' || first == '.') {
            return new PartialParseResult("", remaining);
        }
        String scheme = remaining.substring(0, indexColon).toLowerCase();
        String rest = remaining.substring(indexColon + 1, remaining.length());
        return new PartialParseResult(scheme, rest);
    }

    private UserInfoResult parseUserInfo(String str) throws MalformedURLException {
        int i = str.lastIndexOf(64);
        String username = null;
        String password = null;
        String rest = str;
        if (i >= 0) {
            String credentials = str.substring(0, i);
            if (credentials.indexOf(58) >= 0) {
                String[] parts = credentials.split(":", 2);
                username = PercentEncoder.decode(parts[0]);
                password = PercentEncoder.decode(parts[1]);
            } else {
                username = PercentEncoder.decode(credentials);
            }
            rest = str.substring(i + 1, str.length());
        }
        return new UserInfoResult(username, password, rest);
    }

    private PartialParseResult parseHost(String str) throws MalformedURLException {
        if (str.length() == 0) {
            return new PartialParseResult("", "");
        }
        if (str.charAt(0) == '[') {
            int i = str.lastIndexOf(93);
            if (i < 0) {
                throw new MalformedURLException("IPv6 detected, but missing closing ']' token");
            }
            String portPart = str.substring(i + 1, str.length());
            if (!this.isPortValid(portPart)) {
                throw new MalformedURLException("invalid port");
            }
        } else if (str.indexOf(58) != -1) {
            String[] parts = str.split(":", -1);
            if (parts.length > 2) {
                throw new MalformedURLException("invalid host in: " + str);
            }
            if (parts.length == 2) {
                try {
                    Integer.valueOf(parts[1]);
                }
                catch (NumberFormatException e) {
                    throw new MalformedURLException("invalid port");
                }
            }
        }
        return new PartialParseResult(PercentEncoder.decode(str.toLowerCase()), "");
    }

    protected boolean isPortValid(String portStr) {
        if (portStr == null || portStr.isEmpty()) {
            return true;
        }
        int i = portStr.indexOf(58);
        if (i != 0) {
            return false;
        }
        String segment = portStr.substring(i + 1, portStr.length());
        try {
            Integer.valueOf(segment);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private class UserInfoResult {
        public final String user;
        public final String password;
        public final String remaining;

        public UserInfoResult(String user, String password, String remaining) {
            this.user = user;
            this.password = password;
            this.remaining = remaining;
        }
    }

    private class PartialParseResult {
        public final String result;
        public final String remaining;

        public PartialParseResult(String result, String remaining) {
            this.result = result;
            this.remaining = remaining;
        }
    }
}

