/*
 * Decompiled with CFR 0.152.
 */
package com.anthonynsimon.url;

import java.util.ArrayList;

final class PathResolver {
    private PathResolver() {
    }

    public static String resolve(String base, String ref) {
        String merged = PathResolver.merge(base, ref);
        if (merged == null || merged.isEmpty()) {
            return "";
        }
        String[] parts = merged.split("/", -1);
        return PathResolver.resolve(parts);
    }

    private static String merge(String base, String ref) {
        String merged;
        if (ref == null || ref.isEmpty()) {
            merged = base;
        } else if (ref.charAt(0) != '/' && base != null && !base.isEmpty()) {
            int i = base.lastIndexOf("/");
            merged = base.substring(0, i + 1) + ref;
        } else {
            merged = ref;
        }
        if (merged == null || merged.isEmpty()) {
            return "";
        }
        return merged;
    }

    private static String resolve(String[] parts) {
        if (parts.length == 0) {
            return "";
        }
        ArrayList<String> result = new ArrayList<String>();
        block16: for (int i = 0; i < parts.length; ++i) {
            switch (parts[i]) {
                case "": 
                case ".": {
                    continue block16;
                }
                case "..": {
                    if (result.size() <= 0) continue block16;
                    result.remove(result.size() - 1);
                    continue block16;
                }
                default: {
                    result.add(parts[i]);
                }
            }
        }
        switch (parts[parts.length - 1]) {
            case ".": 
            case "..": {
                result.add("");
            }
        }
        return "/" + String.join((CharSequence)"/", result);
    }
}

