/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.utils;

import com.github.jaemon.dinger.core.spring.ApplicationHome;
import com.github.jaemon.dinger.utils.DingerUtils;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class PackageUtils {
    private static final Logger log = LoggerFactory.getLogger(PackageUtils.class);
    private static final ApplicationHome applicationHome = new ApplicationHome();
    public static final String SPOT = ".";
    public static final String SLANT = "/";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";

    private PackageUtils() {
    }

    public static void classNames(String packageName, List<Class<?>> classNames, boolean isInterface, Class<? extends Annotation> ... filterAnnotations) {
        String absolutePath;
        if (DingerUtils.isEmpty(packageName)) {
            return;
        }
        File applicationHomeSource = applicationHome.getSource();
        if (applicationHomeSource != null && (absolutePath = applicationHomeSource.getAbsolutePath()).endsWith(JAR_FILE_SUFFIX)) {
            PackageUtils.jarClassNames(absolutePath, packageName, classNames, isInterface, filterAnnotations);
            return;
        }
        PackageUtils.forClassNames(packageName, classNames, isInterface, filterAnnotations);
    }

    public static void forClassNames(String packageName, List<Class<?>> classNames, boolean isInterface, Class<? extends Annotation> ... filterAnnotations) {
        List repeatCheck = classNames.stream().map(e -> e.getName()).collect(Collectors.toList());
        try {
            File[] files;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL url = classLoader.getResource(packageName.replace(SPOT, SLANT));
            if (url == null) {
                if (log.isDebugEnabled()) {
                    log.debug("packageName={} is not exist.", (Object)packageName);
                }
                return;
            }
            URI uri = url.toURI();
            File file = new File(uri);
            block2: for (File f : files = file.listFiles()) {
                String name = f.getName();
                if (f.isFile()) {
                    boolean check;
                    String className = packageName + SPOT + name.substring(0, name.lastIndexOf(SPOT));
                    Class<?> clazz = classLoader.loadClass(className);
                    boolean bl = check = isInterface ? clazz.isInterface() : true;
                    if (check) {
                        if (filterAnnotations.length > 0) {
                            for (Class<? extends Annotation> annotation : filterAnnotations) {
                                if (!clazz.isAnnotationPresent(annotation)) continue;
                                if (repeatCheck.contains(className)) continue block2;
                                classNames.add(clazz);
                                continue block2;
                            }
                            continue;
                        }
                        if (repeatCheck.contains(className)) continue;
                        classNames.add(clazz);
                        continue;
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace("skip class {}.", (Object)clazz.getName());
                    continue;
                }
                PackageUtils.forClassNames(packageName + SPOT + name, classNames, isInterface, filterAnnotations);
            }
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.error("when analysis packageName={} catch exception=", (Object)packageName, (Object)ex);
            }
            log.warn("when analysis packageName={} catch exception={}.", (Object)packageName, (Object)ex.getMessage());
        }
    }

    public static void jarClassNames(String jarPath, String packageName, List<Class<?>> classNames, boolean isInterface, Class<? extends Annotation> ... filterAnnotations) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        List repeatCheck = classNames.stream().map(e -> e.getName()).collect(Collectors.toList());
        packageName = packageName.replace(SPOT, SLANT);
        try {
            JarFile jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> entries = jarFile.entries();
            block2: while (entries.hasMoreElements()) {
                boolean check;
                JarEntry jarEntry = entries.nextElement();
                String namePath = jarEntry.getName();
                if (!namePath.contains(packageName) || !namePath.endsWith(".class")) continue;
                namePath = namePath.substring(namePath.indexOf(packageName));
                String className = namePath.replaceAll(SLANT, SPOT).replace(".class", "");
                Class<?> clazz = classLoader.loadClass(className);
                boolean bl = check = isInterface ? clazz.isInterface() : true;
                if (check) {
                    if (filterAnnotations.length > 0) {
                        for (Class<? extends Annotation> annotation : filterAnnotations) {
                            if (!clazz.isAnnotationPresent(annotation)) continue;
                            if (repeatCheck.contains(className)) continue block2;
                            classNames.add(clazz);
                            continue block2;
                        }
                        continue;
                    }
                    if (repeatCheck.contains(className)) continue;
                    classNames.add(clazz);
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace("skip class {}.", (Object)clazz.getName());
            }
        }
        catch (Exception ex) {
            log.error("when analysis packageName={} catch exception=", (Object)packageName, (Object)ex);
        }
    }

    private static void doScan(String packageName, List<Class<?>> classNames, Class<? extends Annotation> ... filterAnnotations) {
        List repeatCheck = classNames.stream().map(e -> e.getName()).collect(Collectors.toList());
        String packageSearchPath = "classpath*:" + packageName.replace(SPOT, SLANT) + '/' + DEFAULT_RESOURCE_PATTERN;
        try {
            Resource[] resources;
            block2: for (Resource resource : resources = new PathMatchingResourcePatternResolver().getResources(packageSearchPath)) {
                File f = resource.getFile();
                String name = f.getName();
                if (f.isFile()) {
                    String className = packageName + SPOT + name.substring(0, name.lastIndexOf(SPOT));
                    Class<?> clazz = Class.forName(className);
                    if (filterAnnotations.length > 0) {
                        for (Class<? extends Annotation> annotation : filterAnnotations) {
                            if (!clazz.isAnnotationPresent(annotation)) continue;
                            if (repeatCheck.contains(className)) continue block2;
                            classNames.add(clazz);
                            continue block2;
                        }
                        continue;
                    }
                    if (repeatCheck.contains(className)) continue;
                    classNames.add(clazz);
                    continue;
                }
                PackageUtils.doScan(packageName + SPOT + name, classNames, filterAnnotations);
            }
        }
        catch (Exception ex) {
            log.error("when analysis packageName={} catch exception=", (Object)packageName, (Object)ex);
        }
    }

    public static void main(String[] args) {
        ArrayList classNames = new ArrayList();
        PackageUtils.classNames("com.jaemon.dinger", classNames, false, new Class[0]);
        classNames.forEach(e -> System.out.println(e.getName()));
        System.out.println(classNames.size());
    }
}

