/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.multi.algorithm;

import com.github.jaemon.dinger.core.DingerConfig;
import com.github.jaemon.dinger.multi.algorithm.AlgorithmHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinHandler
implements AlgorithmHandler {
    private static final Logger log = LoggerFactory.getLogger(RoundRobinHandler.class);
    private volatile int index = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DingerConfig handler(List<DingerConfig> dingerConfigs, DingerConfig defaultDingerConfig) {
        int size = dingerConfigs.size();
        int idx = this.index++;
        RoundRobinHandler roundRobinHandler = this;
        synchronized (roundRobinHandler) {
            int n = this.index = this.index >= size ? 0 : this.index;
            if (log.isDebugEnabled()) {
                log.debug("#{}# \u5f53\u524d\u4f7f\u7528\u7b2c{}\u4e2a\u673a\u5668\u4eba", (Object)this.algorithmId(), (Object)idx);
            }
        }
        return dingerConfigs.get(idx);
    }
}

