/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core;

import com.github.jaemon.dinger.core.AbstractDingerDefinitionResolver;
import com.github.jaemon.dinger.core.DingerConfig;
import com.github.jaemon.dinger.core.annatations.DingerImageText;
import com.github.jaemon.dinger.core.annatations.DingerLink;
import com.github.jaemon.dinger.core.entity.DingerMethod;
import com.github.jaemon.dinger.core.entity.enums.ExceptionEnum;
import com.github.jaemon.dinger.core.entity.enums.MessageMainType;
import com.github.jaemon.dinger.core.entity.enums.MessageSubType;
import com.github.jaemon.dinger.core.entity.xml.BeanTag;
import com.github.jaemon.dinger.core.entity.xml.MessageTag;
import com.github.jaemon.dinger.exception.DingerException;
import com.github.jaemon.dinger.utils.DingerUtils;
import com.github.jaemon.dinger.utils.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

public class XmlDingerDefinitionResolver
extends AbstractDingerDefinitionResolver<Resource[]> {
    private static final Logger log = LoggerFactory.getLogger(XmlDingerDefinitionResolver.class);

    @Override
    public void resolver(Resource[] resources) {
        boolean debugEnabled = log.isDebugEnabled();
        for (Resource resource : resources) {
            Class<?> dingerClass;
            String xml;
            if (!resource.isReadable()) {
                if (!debugEnabled) continue;
                log.debug("Ignored because not readable: {} ", (Object)resource.getFilename());
                continue;
            }
            try {
                xml = new String(FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream()), "UTF-8");
            }
            catch (IOException e) {
                throw new DingerException(ExceptionEnum.RESOURCE_CONFIG_EXCEPTION, resource.getFilename());
            }
            xml = this.transferXml(xml);
            BeanTag dingerBean = XmlUtils.xmlToJavaBean(xml, BeanTag.class);
            if (dingerBean == null) {
                if (!debugEnabled) continue;
                log.debug("dinger xml file: {} content is empty.", (Object)resource.getFilename());
                continue;
            }
            String namespace = dingerBean.getNamespace();
            try {
                dingerClass = Class.forName(namespace);
            }
            catch (ClassNotFoundException e) {
                throw new DingerException(ExceptionEnum.DINER_XML_NAMESPACE_INVALID, namespace);
            }
            Map<String, DingerMethod> dingerClassMethods = this.dingerClassMethods(dingerClass);
            DingerConfig dingerConfiguration = this.dingerConfiguration(dingerClass);
            List<MessageTag> messages = dingerBean.getMessages();
            for (MessageTag message : messages) {
                String methodName = message.getIdentityId();
                if (!dingerClassMethods.containsKey(methodName)) {
                    if (!debugEnabled) continue;
                    log.debug("namespace={}, messageId={} undefined in dingerClass.", (Object)namespace, (Object)methodName);
                    continue;
                }
                String dingerName = namespace + "." + methodName;
                String messageSubType = message.getDingerType();
                if (!MessageSubType.contains(messageSubType)) {
                    throw new DingerException(ExceptionEnum.DINER_XML_MSGTYPE_INVALID, dingerName, messageSubType);
                }
                String dingerDefinitionKey = (Object)((Object)MessageMainType.XML) + "." + message.getDingerType();
                this.registerDingerDefinition(dingerName, message, dingerDefinitionKey, dingerConfiguration, dingerClassMethods.get(methodName));
            }
        }
    }

    protected Map<String, DingerMethod> dingerClassMethods(Class<?> dingerClass) {
        Method[] methods = dingerClass.getMethods();
        HashMap<String, DingerMethod> dingerMethodParams = new HashMap<String, DingerMethod>();
        for (Method method : methods) {
            String methodName = method.getName();
            String methodAllName = dingerClass.getSimpleName() + "." + methodName;
            int[] paramTypes = null;
            if (method.isAnnotationPresent(DingerImageText.class)) {
                paramTypes = DingerUtils.methodParamsGenericType(method, DingerImageText.clazz);
                if (paramTypes.length != 1) {
                    throw new DingerException(ExceptionEnum.IMAGETEXT_METHOD_PARAM_EXCEPTION, methodAllName);
                }
            } else if (method.isAnnotationPresent(DingerLink.class) && (paramTypes = DingerUtils.methodParamsType(method, DingerLink.clazz)).length != 1) {
                throw new DingerException(ExceptionEnum.LINK_METHOD_PARAM_EXCEPTION, methodAllName);
            }
            String[] methodParams = this.parameterNameDiscoverer.getParameterNames(method);
            dingerMethodParams.put(methodName, new DingerMethod(methodAllName, methodParams, paramTypes));
        }
        return dingerMethodParams;
    }

    String transferXml(String sourceXml) {
        return sourceXml.replaceAll("<!DOCTYPE.*>", "");
    }
}

