/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core;

import com.github.jaemon.dinger.core.DingerDefinitionGenerator;
import com.github.jaemon.dinger.core.entity.enums.ExceptionEnum;
import com.github.jaemon.dinger.exception.DingerException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingerDefinitionGeneratorFactory {
    private static final Logger log = LoggerFactory.getLogger(DingerDefinitionGeneratorFactory.class);
    static final Map<String, DingerDefinitionGenerator> dingTalkDefinitionGeneratorMap = new HashMap<String, DingerDefinitionGenerator>();

    public static DingerDefinitionGenerator get(String key) {
        DingerDefinitionGenerator dingTalkDefinitionGenerator = dingTalkDefinitionGeneratorMap.get(key);
        if (dingTalkDefinitionGenerator == null) {
            if (log.isDebugEnabled()) {
                log.debug("key={}, dingTalkDefinitionGeneratorMap={}.", (Object)key, dingTalkDefinitionGeneratorMap.keySet());
            }
            throw new DingerException(ExceptionEnum.DINGERDEFINITION_ERROR, key);
        }
        return dingTalkDefinitionGenerator;
    }
}

