/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core;

import com.github.jaemon.dinger.core.entity.enums.ExceptionEnum;
import com.github.jaemon.dinger.exception.DingerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;

public final class ClassPathScanForResources {
    private static final Logger log = LoggerFactory.getLogger(ClassPathScanForResources.class);
    private static final String CLASSPATH_ALL_URL_PREFIX = "classpath*:";
    private static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    private static final ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    public static Resource[] doScanPackage(String packageSearchPath) {
        try {
            return resolver.getResources(packageSearchPath);
        }
        catch (IOException ex) {
            log.error(packageSearchPath, (Throwable)ex);
            throw new DingerException(ExceptionEnum.RESOURCE_CONFIG_EXCEPTION, packageSearchPath);
        }
    }

    public static List<Class<?>> scanInterfaces(String basePackage) {
        return ClassPathScanForResources.scanClasses(basePackage, true);
    }

    public static List<Class<?>> scanClasses(String basePackage) {
        return ClassPathScanForResources.scanClasses(basePackage, false);
    }

    private static List<Class<?>> scanClasses(String basePackage, boolean filterInterface) {
        boolean debugEnabled = log.isDebugEnabled();
        String packageSearchPath = CLASSPATH_ALL_URL_PREFIX + ClassPathScanForResources.resolveBasePackage(basePackage) + "/" + DEFAULT_RESOURCE_PATTERN;
        Resource[] resources = ClassPathScanForResources.doScanPackage(packageSearchPath);
        ArrayList classes = new ArrayList();
        if (resources.length == 0) {
            return classes;
        }
        SimpleMetadataReaderFactory factory = new SimpleMetadataReaderFactory();
        for (Resource resource : resources) {
            String resourceFilename = resource.getFilename();
            if (!resource.isReadable()) {
                if (!debugEnabled) continue;
                log.debug("Ignored because not readable: {} ", (Object)resourceFilename);
                continue;
            }
            try {
                MetadataReader metadataReader = factory.getMetadataReader(resource);
                ClassMetadata classMetadata = metadataReader.getClassMetadata();
                Class<?> clazz = Class.forName(classMetadata.getClassName());
                if (filterInterface && !clazz.isInterface()) {
                    if (!debugEnabled) continue;
                    log.debug("source class={} is interface and skip.", (Object)resourceFilename);
                    continue;
                }
                classes.add(clazz);
            }
            catch (IOException | ClassNotFoundException e) {
                log.warn("resource={} read exception and message={}.", (Object)resourceFilename, (Object)e.getMessage());
            }
        }
        return classes;
    }

    private static String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)basePackage);
    }
}

