/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core;

import com.github.jaemon.dinger.DingerSender;
import com.github.jaemon.dinger.core.DingerHelper;
import com.github.jaemon.dinger.core.DingerManagerBuilder;
import com.github.jaemon.dinger.core.entity.DingerCallback;
import com.github.jaemon.dinger.core.entity.DingerProperties;
import com.github.jaemon.dinger.core.entity.enums.MessageSubType;
import com.github.jaemon.dinger.exception.DingerException;
import com.github.jaemon.dinger.support.CustomMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDingerSender
extends DingerHelper
implements DingerSender {
    protected static final Logger log = LoggerFactory.getLogger(AbstractDingerSender.class);
    protected DingerProperties dingerProperties;
    protected DingerManagerBuilder dingTalkManagerBuilder;

    public AbstractDingerSender(DingerProperties dingerProperties, DingerManagerBuilder dingTalkManagerBuilder) {
        this.dingerProperties = dingerProperties;
        this.dingTalkManagerBuilder = dingTalkManagerBuilder;
    }

    protected CustomMessage customMessage(MessageSubType messageSubType) {
        return messageSubType == MessageSubType.TEXT ? this.dingTalkManagerBuilder.textMessage : this.dingTalkManagerBuilder.markDownMessage;
    }

    protected <T> void exceptionCallback(String dingerId, T message, DingerException ex) {
        DingerCallback<T> dkExCallable = new DingerCallback<T>(dingerId, message, ex);
        this.dingTalkManagerBuilder.dingerExceptionCallback.execute(dkExCallable);
    }
}

