/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.config;

import com.github.jaemon.dinger.config.DingerThreadPoolProperties;
import com.github.jaemon.dinger.core.DingerRobot;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@ConditionalOnProperty(prefix="spring.dinger", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={DingerRobot.class})
@ConditionalOnMissingBean(name={"dingerExecutor"})
@EnableConfigurationProperties(value={DingerThreadPoolProperties.class})
public class DingerThreadPoolConfig {
    @Bean(name={"dingerExecutor"})
    public Executor dingTalkExecutor(DingerThreadPoolProperties dingerThreadPoolProperties) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(dingerThreadPoolProperties.getCoreSize());
        executor.setMaxPoolSize(dingerThreadPoolProperties.getMaxSize());
        executor.setKeepAliveSeconds(dingerThreadPoolProperties.getKeepAliveSeconds());
        executor.setQueueCapacity(dingerThreadPoolProperties.getQueueCapacity());
        executor.setThreadNamePrefix(dingerThreadPoolProperties.getThreadNamePrefix());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.initialize();
        return executor;
    }
}

