/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.config;

import com.github.jaemon.dinger.config.DingerConfiguration;
import com.github.jaemon.dinger.core.DingerRobot;
import com.github.jaemon.dinger.core.entity.DingerProperties;
import com.github.jaemon.dinger.core.session.Configuration;
import com.github.jaemon.dinger.core.session.DingerSessionFactory;
import com.github.jaemon.dinger.core.spring.DingerSessionFactoryBean;
import java.io.IOException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@org.springframework.context.annotation.Configuration
@EnableConfigurationProperties(value={DingerProperties.class})
@AutoConfigureAfter(value={DingerConfiguration.class})
public class DingerAutoConfiguration
implements InitializingBean {
    private final DingerProperties properties;
    private final DingerRobot dingerRobot;
    private final ResourcePatternResolver resourceLoader;

    public DingerAutoConfiguration(DingerProperties dingerProperties, DingerRobot dingerRobot) {
        this.properties = dingerProperties;
        this.dingerRobot = dingerRobot;
        this.resourceLoader = new PathMatchingResourcePatternResolver();
    }

    @Bean
    @ConditionalOnMissingBean
    public DingerSessionFactory dingerSessionFactory() throws Exception {
        DingerSessionFactoryBean factory = new DingerSessionFactoryBean();
        factory.setConfiguration(Configuration.of(this.properties, this.dingerRobot));
        return factory.getObject();
    }

    public void afterPropertiesSet() throws Exception {
        this.checkConfigFileExists();
    }

    private void checkConfigFileExists() throws IOException {
        if (StringUtils.hasText((String)this.properties.getDingerLocations())) {
            Resource[] resources = this.resourceLoader.getResources(this.properties.getDingerLocations());
            Assert.state((resources.length > 0 ? 1 : 0) != 0, (String)("Cannot find config location: " + this.properties.getDingerLocations() + " (please add config file or check your Dinger configuration)"));
        }
    }
}

