/*
 * Copyright ©2015-2023 Jaemon. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.jaemon.dinger.core.session;

import com.github.jaemon.dinger.core.DingerRobot;
import com.github.jaemon.dinger.core.entity.DingerProperties;

/**
 * Configuration
 *
 * @author Jaemon
 * @version 1.2
 */
public class Configuration {
    protected DingerProperties dingerProperties;
    protected DingerRobot dingerRobot;

    private Configuration(DingerProperties dingerProperties, DingerRobot dingerRobot) {
        this.dingerProperties = dingerProperties;
        this.dingerRobot = dingerRobot;
    }

    public static Configuration of(DingerProperties dingerProperties, DingerRobot dingerRobot) {
        return new Configuration(dingerProperties, dingerRobot);
    }

    public DingerProperties getDingerProperties() {
        return dingerProperties;
    }

    public DingerRobot getDingerRobot() {
        return dingerRobot;
    }
}