/*
 * Decompiled with CFR 0.152.
 */
package lucifer.org.snackbartest;

import android.graphics.Color;
import android.support.design.R;
import android.support.design.widget.Snackbar;
import android.view.View;
import android.widget.TextView;

public class MySnack {
    private View view;
    private String text;
    private String bgColor;
    private String textColor;
    private String actionBtnColor;
    private float textSize;
    private String actionBtnText;
    private View.OnClickListener listener;
    private int time;

    private MySnack(SnackBuilder builder) {
        this.view = builder.view;
        this.text = builder.text;
        this.bgColor = builder.bgColor;
        this.textColor = builder.textColor;
        this.textSize = builder.textSize;
        this.actionBtnColor = builder.actionBtnColor;
        this.listener = builder.listener;
        this.time = builder.time;
    }

    public static class SnackBuilder {
        private View view;
        private String text;
        private String bgColor;
        private String textColor;
        private String actionBtnColor;
        private float textSize;
        private String actionBtnText;
        private View.OnClickListener listener;
        private int time;

        public SnackBuilder(View v) {
            this.view = v;
        }

        public SnackBuilder setText(String text) {
            this.text = text;
            return this;
        }

        public SnackBuilder setBgColor(String bgColor) {
            this.bgColor = bgColor;
            return this;
        }

        public SnackBuilder setTextColor(String textColor) {
            this.textColor = textColor;
            return this;
        }

        public SnackBuilder setActionBtnColor(String actionBtnColor) {
            this.actionBtnColor = actionBtnColor;
            return this;
        }

        public SnackBuilder setTextSize(float textSize) {
            this.textSize = textSize;
            return this;
        }

        public SnackBuilder setActionListener(String text, View.OnClickListener listener) {
            this.listener = listener;
            this.actionBtnText = text;
            return this;
        }

        public SnackBuilder setDurationInSeconds(int time) {
            this.time = time;
            return this;
        }

        public MySnack build() {
            Snackbar bar = Snackbar.make((View)this.view, (CharSequence)this.text, (int)0);
            if (this.bgColor != null) {
                try {
                    bar.getView().setBackgroundColor(Color.parseColor((String)this.bgColor));
                }
                catch (Exception e) {
                    bar.getView().setBackgroundColor(Color.parseColor((String)"#808080"));
                }
            }
            TextView tv = (TextView)bar.getView().findViewById(R.id.snackbar_text);
            TextView tv2 = (TextView)bar.getView().findViewById(R.id.snackbar_action);
            if (this.textColor != null) {
                try {
                    tv.setTextColor(Color.parseColor((String)this.textColor));
                }
                catch (Exception e) {
                    tv.setTextColor(Color.parseColor((String)"#000000"));
                }
            }
            if (this.actionBtnColor != null) {
                try {
                    tv2.setTextColor(Color.parseColor((String)this.actionBtnColor));
                }
                catch (Exception e) {
                    tv2.setTextColor(Color.parseColor((String)"#000000"));
                }
            }
            if (this.textSize != 0.0f) {
                tv.setTextSize(this.textSize);
                tv2.setTextSize(this.textSize);
            }
            if (this.listener != null) {
                bar.setAction((CharSequence)this.actionBtnText, this.listener);
            }
            if (this.time != 0) {
                bar.setDuration(this.time * 1000);
            }
            bar.show();
            return new MySnack(this);
        }
    }
}

