/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.lands.api.levels.requirement;

import java.util.List;
import java.util.Objects;
import me.angeschossen.lands.api.MemberHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class Requirement
implements me.angeschossen.lands.api.levels.Requirement {
    protected final String name;
    protected final String title;
    protected final List<String> description;
    protected final float required;
    protected final Plugin plugin;

    public Requirement(@NotNull Plugin plugin, @NotNull String name, @NotNull String title, @NotNull List<String> description, float required, @NotNull String requiredDisplay) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(name);
        Objects.requireNonNull(title);
        Objects.requireNonNull(description);
        Objects.requireNonNull(requiredDisplay);
        this.plugin = plugin;
        this.name = name;
        this.required = required;
        this.title = title;
        this.description = description;
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public final float getRequired() {
        return this.required;
    }

    @Override
    @NotNull
    public String getProgressDisplay(@NotNull MemberHolder memberHolder) {
        return this.getValue(memberHolder) + "/" + this.required;
    }

    @Override
    public final float getProgress(@NotNull MemberHolder memberHolder) {
        return this.getValue(memberHolder) / this.required * 100.0f;
    }

    @Override
    public boolean matches(@NotNull MemberHolder memberHolder) {
        return this.getValue(memberHolder) >= this.required;
    }

    @Override
    @NotNull
    public List<String> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }
}

