/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.lands.api.events;

import java.util.Collection;
import java.util.UUID;
import me.angeschossen.lands.api.MemberHolder;
import me.angeschossen.lands.api.player.LandPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LandChatEvent
extends Event
implements Cancellable {
    public static HandlerList handlerList = new HandlerList();
    private final String message;
    private final UUID playerUID;
    private final Collection<LandPlayer> recipients;
    private final MessageSource messageSource;
    private final MemberHolder memberHolder;
    private boolean cancelled;

    public LandChatEvent(MemberHolder memberHolder, UUID playerUID, Collection<LandPlayer> recipients, String message, MessageSource messageSource) {
        this.memberHolder = memberHolder;
        this.playerUID = playerUID;
        this.message = message;
        this.recipients = recipients;
        this.messageSource = messageSource;
    }

    public static HandlerList getHandlerList() {
        return handlerList;
    }

    @NotNull
    public Collection<LandPlayer> getReceivers() {
        return this.recipients;
    }

    @NotNull
    public MemberHolder getMemberHolder() {
        return this.memberHolder;
    }

    public MessageSource getSource() {
        return this.messageSource;
    }

    @NotNull
    public UUID getSenderUID() {
        return this.playerUID;
    }

    @Nullable
    public Player getSender() {
        return Bukkit.getPlayer((UUID)this.playerUID);
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public HandlerList getHandlers() {
        return handlerList;
    }

    public String toString() {
        return "Sender: " + this.getSenderUID() + " MemberHolder: " + this.memberHolder.getName();
    }

    public static enum MessageSource {
        MINECRAFT,
        DISCORD;

    }
}

