/*
 * Decompiled with CFR 0.152.
 */
package com.github.angads25.toggle.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.github.angads25.toggle.R;
import com.github.angads25.toggle.model.ToggleableView;

public class LabeledSwitch
extends ToggleableView {
    private int padding;
    private int colorOn;
    private int colorOff;
    private int colorBorder;
    private int colorDisabled;
    private int textSize;
    private int outerRadii;
    private int thumbRadii;
    private Paint paint;
    private long startTime;
    private String labelOn;
    private String labelOff;
    private RectF thumbBounds;
    private RectF leftBgArc;
    private RectF rightBgArc;
    private RectF leftFgArc;
    private RectF rightFgArc;
    private Typeface typeface;
    private float thumbOnCenterX;
    private float thumbOffCenterX;

    public LabeledSwitch(Context context) {
        super(context);
        this.initView();
    }

    public LabeledSwitch(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
        this.initProperties(attrs);
    }

    public LabeledSwitch(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
        this.initProperties(attrs);
    }

    private void initView() {
        this.isOn = false;
        this.labelOn = "ON";
        this.labelOff = "OFF";
        this.enabled = true;
        this.textSize = (int)(12.0f * this.getResources().getDisplayMetrics().scaledDensity);
        this.colorBorder = Build.VERSION.SDK_INT >= 23 ? (this.colorOn = this.getResources().getColor(R.color.colorAccent, this.getContext().getTheme())) : (this.colorOn = this.getResources().getColor(R.color.colorAccent));
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.leftBgArc = new RectF();
        this.rightBgArc = new RectF();
        this.leftFgArc = new RectF();
        this.rightFgArc = new RectF();
        this.thumbBounds = new RectF();
        this.colorOff = Color.parseColor((String)"#FFFFFF");
        this.colorDisabled = Color.parseColor((String)"#D3D3D3");
    }

    private void initProperties(AttributeSet attrs) {
        TypedArray tarr = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.Toggle, 0, 0);
        int N = tarr.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int accentColor;
            int attr = tarr.getIndex(i);
            if (attr == R.styleable.Toggle_on) {
                this.isOn = tarr.getBoolean(R.styleable.Toggle_on, false);
                continue;
            }
            if (attr == R.styleable.Toggle_colorOff) {
                this.colorOff = tarr.getColor(R.styleable.Toggle_colorOff, Color.parseColor((String)"#FFFFFF"));
                continue;
            }
            if (attr == R.styleable.Toggle_colorBorder) {
                accentColor = Build.VERSION.SDK_INT >= 23 ? this.getResources().getColor(R.color.colorAccent, this.getContext().getTheme()) : this.getResources().getColor(R.color.colorAccent);
                this.colorBorder = tarr.getColor(R.styleable.Toggle_colorBorder, accentColor);
                continue;
            }
            if (attr == R.styleable.Toggle_colorOn) {
                accentColor = Build.VERSION.SDK_INT >= 23 ? this.getResources().getColor(R.color.colorAccent, this.getContext().getTheme()) : this.getResources().getColor(R.color.colorAccent);
                this.colorOn = tarr.getColor(R.styleable.Toggle_colorOn, accentColor);
                continue;
            }
            if (attr == R.styleable.Toggle_colorDisabled) {
                this.colorDisabled = tarr.getColor(R.styleable.Toggle_colorOff, Color.parseColor((String)"#D3D3D3"));
                continue;
            }
            if (attr == R.styleable.Toggle_textOff) {
                this.labelOff = tarr.getString(R.styleable.Toggle_textOff);
                continue;
            }
            if (attr == R.styleable.Toggle_textOn) {
                this.labelOn = tarr.getString(R.styleable.Toggle_textOn);
                continue;
            }
            if (attr == R.styleable.Toggle_android_textSize) {
                int defaultTextSize = (int)(12.0f * this.getResources().getDisplayMetrics().scaledDensity);
                this.textSize = tarr.getDimensionPixelSize(R.styleable.Toggle_android_textSize, defaultTextSize);
                continue;
            }
            if (attr != R.styleable.Toggle_android_enabled) continue;
            this.enabled = tarr.getBoolean(R.styleable.Toggle_android_enabled, false);
        }
    }

    protected void onDraw(Canvas canvas) {
        int offColor;
        int alpha;
        super.onDraw(canvas);
        this.paint.setTextSize((float)this.textSize);
        if (this.isEnabled()) {
            this.paint.setColor(this.colorBorder);
        } else {
            this.paint.setColor(this.colorDisabled);
        }
        canvas.drawArc(this.leftBgArc, 90.0f, 180.0f, false, this.paint);
        canvas.drawArc(this.rightBgArc, 90.0f, -180.0f, false, this.paint);
        canvas.drawRect((float)this.outerRadii, 0.0f, (float)(this.width - this.outerRadii), (float)this.height, this.paint);
        this.paint.setColor(this.colorOff);
        canvas.drawArc(this.leftFgArc, 90.0f, 180.0f, false, this.paint);
        canvas.drawArc(this.rightFgArc, 90.0f, -180.0f, false, this.paint);
        canvas.drawRect((float)this.outerRadii, (float)(this.padding / 10), (float)(this.width - this.outerRadii), (float)(this.height - this.padding / 10), this.paint);
        int alpha2 = (int)((this.thumbBounds.centerX() - this.thumbOffCenterX) / (this.thumbOnCenterX - this.thumbOffCenterX) * 255.0f);
        alpha2 = alpha2 < 0 ? 0 : (alpha2 > 255 ? 255 : alpha2);
        int onColor = this.isEnabled() ? Color.argb((int)alpha2, (int)Color.red((int)this.colorOn), (int)Color.green((int)this.colorOn), (int)Color.blue((int)this.colorOn)) : Color.argb((int)alpha2, (int)Color.red((int)this.colorDisabled), (int)Color.green((int)this.colorDisabled), (int)Color.blue((int)this.colorDisabled));
        this.paint.setColor(onColor);
        canvas.drawArc(this.leftBgArc, 90.0f, 180.0f, false, this.paint);
        canvas.drawArc(this.rightBgArc, 90.0f, -180.0f, false, this.paint);
        canvas.drawRect((float)this.outerRadii, 0.0f, (float)(this.width - this.outerRadii), (float)this.height, this.paint);
        alpha2 = (int)((this.thumbOnCenterX - this.thumbBounds.centerX()) / (this.thumbOnCenterX - this.thumbOffCenterX) * 255.0f);
        alpha2 = alpha2 < 0 ? 0 : (alpha2 > 255 ? 255 : alpha2);
        int offColor2 = Color.argb((int)alpha2, (int)Color.red((int)this.colorOff), (int)Color.green((int)this.colorOff), (int)Color.blue((int)this.colorOff));
        this.paint.setColor(offColor2);
        canvas.drawArc(this.leftFgArc, 90.0f, 180.0f, false, this.paint);
        canvas.drawArc(this.rightFgArc, 90.0f, -180.0f, false, this.paint);
        canvas.drawRect((float)this.outerRadii, (float)(this.padding / 10), (float)(this.width - this.outerRadii), (float)(this.height - this.padding / 10), this.paint);
        String MAX_CHAR = "N";
        float textCenter = this.paint.measureText(MAX_CHAR) / 2.0f;
        if (this.isOn) {
            alpha = (int)(((float)(this.width >>> 1) - this.thumbBounds.centerX()) / ((float)(this.width >>> 1) - this.thumbOffCenterX) * 255.0f);
            alpha = alpha < 0 ? 0 : (alpha > 255 ? 255 : alpha);
            int onColor2 = Color.argb((int)alpha, (int)Color.red((int)this.colorOn), (int)Color.green((int)this.colorOn), (int)Color.blue((int)this.colorOn));
            this.paint.setColor(onColor2);
            float centerX = this.width - this.padding - (this.padding + (this.padding >>> 1) + (this.thumbRadii << 1)) >>> 1;
            canvas.drawText(this.labelOff, (float)(this.padding + (this.padding >>> 1) + (this.thumbRadii << 1)) + centerX - this.paint.measureText(this.labelOff) / 2.0f, (float)(this.height >>> 1) + textCenter, this.paint);
            alpha = (int)((this.thumbBounds.centerX() - (float)(this.width >>> 1)) / (this.thumbOnCenterX - (float)(this.width >>> 1)) * 255.0f);
            alpha = alpha < 0 ? 0 : (alpha > 255 ? 255 : alpha);
            int offColor3 = Color.argb((int)alpha, (int)Color.red((int)this.colorOff), (int)Color.green((int)this.colorOff), (int)Color.blue((int)this.colorOff));
            this.paint.setColor(offColor3);
            int maxSize = this.width - (this.padding << 1) - (this.thumbRadii << 1);
            centerX = (this.padding >>> 1) + maxSize - this.padding >>> 1;
            canvas.drawText(this.labelOn, (float)this.padding + centerX - this.paint.measureText(this.labelOn) / 2.0f, (float)(this.height >>> 1) + textCenter, this.paint);
        } else {
            alpha = (int)((this.thumbBounds.centerX() - (float)(this.width >>> 1)) / (this.thumbOnCenterX - (float)(this.width >>> 1)) * 255.0f);
            alpha = alpha < 0 ? 0 : (alpha > 255 ? 255 : alpha);
            offColor = Color.argb((int)alpha, (int)Color.red((int)this.colorOff), (int)Color.green((int)this.colorOff), (int)Color.blue((int)this.colorOff));
            this.paint.setColor(offColor);
            int maxSize = this.width - (this.padding << 1) - (this.thumbRadii << 1);
            float centerX = (this.padding >>> 1) + maxSize - this.padding >>> 1;
            canvas.drawText(this.labelOn, (float)this.padding + centerX - this.paint.measureText(this.labelOn) / 2.0f, (float)(this.height >>> 1) + textCenter, this.paint);
            alpha = (int)(((float)(this.width >>> 1) - this.thumbBounds.centerX()) / ((float)(this.width >>> 1) - this.thumbOffCenterX) * 255.0f);
            alpha = alpha < 0 ? 0 : (alpha > 255 ? 255 : alpha);
            int onColor3 = this.isEnabled() ? Color.argb((int)alpha, (int)Color.red((int)this.colorOn), (int)Color.green((int)this.colorOn), (int)Color.blue((int)this.colorOn)) : Color.argb((int)alpha, (int)Color.red((int)this.colorDisabled), (int)Color.green((int)this.colorDisabled), (int)Color.blue((int)this.colorDisabled));
            this.paint.setColor(onColor3);
            centerX = this.width - this.padding - (this.padding + (this.padding >>> 1) + (this.thumbRadii << 1)) >>> 1;
            canvas.drawText(this.labelOff, (float)(this.padding + (this.padding >>> 1) + (this.thumbRadii << 1)) + centerX - this.paint.measureText(this.labelOff) / 2.0f, (float)(this.height >>> 1) + textCenter, this.paint);
        }
        alpha = (int)((this.thumbBounds.centerX() - this.thumbOffCenterX) / (this.thumbOnCenterX - this.thumbOffCenterX) * 255.0f);
        alpha = alpha < 0 ? 0 : (alpha > 255 ? 255 : alpha);
        offColor = Color.argb((int)alpha, (int)Color.red((int)this.colorOff), (int)Color.green((int)this.colorOff), (int)Color.blue((int)this.colorOff));
        this.paint.setColor(offColor);
        canvas.drawCircle(this.thumbBounds.centerX(), this.thumbBounds.centerY(), (float)this.thumbRadii, this.paint);
        alpha = (int)((this.thumbOnCenterX - this.thumbBounds.centerX()) / (this.thumbOnCenterX - this.thumbOffCenterX) * 255.0f);
        alpha = alpha < 0 ? 0 : (alpha > 255 ? 255 : alpha);
        int onColor4 = this.isEnabled() ? Color.argb((int)alpha, (int)Color.red((int)this.colorOn), (int)Color.green((int)this.colorOn), (int)Color.blue((int)this.colorOn)) : Color.argb((int)alpha, (int)Color.red((int)this.colorDisabled), (int)Color.green((int)this.colorDisabled), (int)Color.blue((int)this.colorDisabled));
        this.paint.setColor(onColor4);
        canvas.drawCircle(this.thumbBounds.centerX(), this.thumbBounds.centerY(), (float)this.thumbRadii, this.paint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredWidth = this.getResources().getDimensionPixelSize(R.dimen.labeled_default_width);
        int desiredHeight = this.getResources().getDimensionPixelSize(R.dimen.labeled_default_height);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
        this.height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(desiredHeight, heightSize) : desiredHeight);
        this.setMeasuredDimension(this.width, this.height);
        this.outerRadii = Math.min(this.width, this.height) >>> 1;
        this.thumbRadii = (int)((float)Math.min(this.width, this.height) / 2.88f);
        this.padding = this.height - this.thumbRadii >>> 1;
        this.thumbBounds.set((float)(this.width - this.padding - this.thumbRadii), (float)this.padding, (float)(this.width - this.padding), (float)(this.height - this.padding));
        this.thumbOnCenterX = this.thumbBounds.centerX();
        this.thumbBounds.set((float)this.padding, (float)this.padding, (float)(this.padding + this.thumbRadii), (float)(this.height - this.padding));
        this.thumbOffCenterX = this.thumbBounds.centerX();
        if (this.isOn) {
            this.thumbBounds.set((float)(this.width - this.padding - this.thumbRadii), (float)this.padding, (float)(this.width - this.padding), (float)(this.height - this.padding));
        } else {
            this.thumbBounds.set((float)this.padding, (float)this.padding, (float)(this.padding + this.thumbRadii), (float)(this.height - this.padding));
        }
        this.leftBgArc.set(0.0f, 0.0f, (float)(this.outerRadii << 1), (float)this.height);
        this.rightBgArc.set((float)(this.width - (this.outerRadii << 1)), 0.0f, (float)this.width, (float)this.height);
        this.leftFgArc.set((float)(this.padding / 10), (float)(this.padding / 10), (float)((this.outerRadii << 1) - this.padding / 10), (float)(this.height - this.padding / 10));
        this.rightFgArc.set((float)(this.width - (this.outerRadii << 1) + this.padding / 10), (float)(this.padding / 10), (float)(this.width - this.padding / 10), (float)(this.height - this.padding / 10));
    }

    public final boolean performClick() {
        super.performClick();
        if (this.isOn) {
            ValueAnimator switchColor = ValueAnimator.ofFloat((float[])new float[]{this.width - this.padding - this.thumbRadii, this.padding});
            switchColor.addUpdateListener(animation -> {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                this.thumbBounds.set(value, this.thumbBounds.top, value + (float)this.thumbRadii, this.thumbBounds.bottom);
                this.invalidate();
            });
            switchColor.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            switchColor.setDuration(250L);
            switchColor.start();
        } else {
            ValueAnimator switchColor = ValueAnimator.ofFloat((float[])new float[]{this.padding, this.width - this.padding - this.thumbRadii});
            switchColor.addUpdateListener(animation -> {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                this.thumbBounds.set(value, this.thumbBounds.top, value + (float)this.thumbRadii, this.thumbBounds.bottom);
                this.invalidate();
            });
            switchColor.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            switchColor.setDuration(250L);
            switchColor.start();
        }
        boolean bl = this.isOn = !this.isOn;
        if (this.onToggledListener != null) {
            this.onToggledListener.onSwitched(this, this.isOn);
        }
        return true;
    }

    public final boolean onTouchEvent(MotionEvent event) {
        if (this.isEnabled()) {
            float x = event.getX();
            switch (event.getAction()) {
                case 0: {
                    this.startTime = System.currentTimeMillis();
                    return true;
                }
                case 2: {
                    if (x - (float)(this.thumbRadii >>> 1) > (float)this.padding && x + (float)(this.thumbRadii >>> 1) < (float)(this.width - this.padding)) {
                        this.thumbBounds.set(x - (float)(this.thumbRadii >>> 1), this.thumbBounds.top, x + (float)(this.thumbRadii >>> 1), this.thumbBounds.bottom);
                        this.invalidate();
                    }
                    return true;
                }
                case 1: 
                case 3: {
                    long endTime = System.currentTimeMillis();
                    long span = endTime - this.startTime;
                    if (span < 200L) {
                        this.performClick();
                    } else {
                        if (x >= (float)(this.width >>> 1)) {
                            ValueAnimator switchColor = ValueAnimator.ofFloat((float[])new float[]{x > (float)(this.width - this.padding - this.thumbRadii) ? (float)(this.width - this.padding - this.thumbRadii) : x, this.width - this.padding - this.thumbRadii});
                            switchColor.addUpdateListener(animation -> {
                                float value = ((Float)animation.getAnimatedValue()).floatValue();
                                this.thumbBounds.set(value, this.thumbBounds.top, value + (float)this.thumbRadii, this.thumbBounds.bottom);
                                this.invalidate();
                            });
                            switchColor.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                            switchColor.setDuration(250L);
                            switchColor.start();
                            this.isOn = true;
                        } else {
                            ValueAnimator switchColor = ValueAnimator.ofFloat((float[])new float[]{x < (float)this.padding ? (float)this.padding : x, this.padding});
                            switchColor.addUpdateListener(animation -> {
                                float value = ((Float)animation.getAnimatedValue()).floatValue();
                                this.thumbBounds.set(value, this.thumbBounds.top, value + (float)this.thumbRadii, this.thumbBounds.bottom);
                                this.invalidate();
                            });
                            switchColor.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                            switchColor.setDuration(250L);
                            switchColor.start();
                            this.isOn = false;
                        }
                        if (this.onToggledListener != null) {
                            this.onToggledListener.onSwitched(this, this.isOn);
                        }
                    }
                    this.invalidate();
                    return true;
                }
            }
            return super.onTouchEvent(event);
        }
        return false;
    }

    public int getColorOn() {
        return this.colorOn;
    }

    public void setColorOn(int colorOn) {
        this.colorOn = colorOn;
        this.invalidate();
    }

    public int getColorOff() {
        return this.colorOff;
    }

    public void setColorOff(int colorOff) {
        this.colorOff = colorOff;
        this.invalidate();
    }

    public String getLabelOn() {
        return this.labelOn;
    }

    public void setLabelOn(String labelOn) {
        this.labelOn = labelOn;
        this.invalidate();
    }

    public String getLabelOff() {
        return this.labelOff;
    }

    public void setLabelOff(String labelOff) {
        this.labelOff = labelOff;
        this.invalidate();
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public void setTypeface(Typeface typeface) {
        this.typeface = typeface;
        this.paint.setTypeface(typeface);
        this.invalidate();
    }

    @Override
    public void setOn(boolean on) {
        super.setOn(on);
        if (this.isOn) {
            this.thumbBounds.set((float)(this.width - this.padding - this.thumbRadii), (float)this.padding, (float)(this.width - this.padding), (float)(this.height - this.padding));
        } else {
            this.thumbBounds.set((float)this.padding, (float)this.padding, (float)(this.padding + this.thumbRadii), (float)(this.height - this.padding));
        }
        this.invalidate();
    }

    public int getColorDisabled() {
        return this.colorDisabled;
    }

    public void setColorDisabled(int colorDisabled) {
        this.colorDisabled = colorDisabled;
        this.invalidate();
    }

    public int getColorBorder() {
        return this.colorBorder;
    }

    public void setColorBorder(int colorBorder) {
        this.colorBorder = colorBorder;
        this.invalidate();
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = (int)((float)textSize * this.getResources().getDisplayMetrics().scaledDensity);
        this.invalidate();
    }
}

