/*
 * Decompiled with CFR 0.152.
 */
package com.github.angads25.toggle.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.github.angads25.toggle.R;
import com.github.angads25.toggle.model.ToggleableView;

public class DayNightSwitch
extends ToggleableView {
    private int padding;
    private int centerX;
    private int centerY;
    private int cloudCenterX;
    private int cloudCenterY;
    private int outerRadii;
    private int thumbRadii;
    private int colorDisabled;
    private Paint paint;
    private long startTime;
    private RectF thumbBounds;
    private RectF leftBgArc;
    private RectF rightBgArc;
    private RectF leftFgArc;
    private RectF rightFgArc;
    private float thumbOnCenterX;
    private float thumbOffCenterX;
    private Path outerCloud;
    private int stars = Color.parseColor((String)"#FCFCFC");
    private int sunInner = Color.parseColor((String)"#F5EB42");
    private int sunOuter = Color.parseColor((String)"#E4C74D");
    private int moonInner = Color.parseColor((String)"#FFFDF2");
    private int moonOuter = Color.parseColor((String)"#DEE1C5");
    private int cloudInner = Color.parseColor((String)"#FFFFFF");
    private int cloudOuter = Color.parseColor((String)"#D4D4D2");
    private int craterInner = Color.parseColor((String)"#EFEEDA");
    private int parentOuter = Color.parseColor((String)"#81C0D5");
    private int parentInner = Color.parseColor((String)"#C0E6F6");
    private int parentDarkOuter = Color.parseColor((String)"#202020");
    private int parentDarkInner = Color.parseColor((String)"#484848");

    public DayNightSwitch(Context context) {
        super(context);
        this.initView();
    }

    public DayNightSwitch(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
        this.initProperties(attrs);
    }

    public DayNightSwitch(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
        this.initProperties(attrs);
    }

    private void initView() {
        this.isOn = false;
        this.enabled = true;
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.outerCloud = new Path();
        this.leftBgArc = new RectF();
        this.rightBgArc = new RectF();
        this.leftFgArc = new RectF();
        this.rightFgArc = new RectF();
        this.thumbBounds = new RectF();
        this.colorDisabled = Color.parseColor((String)"#D3D3D3");
    }

    private void initProperties(AttributeSet attrs) {
        TypedArray tarr = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.Toggle, 0, 0);
        int N = tarr.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr = tarr.getIndex(i);
            if (attr == R.styleable.Toggle_on) {
                this.isOn = tarr.getBoolean(R.styleable.Toggle_on, false);
                continue;
            }
            if (attr != R.styleable.Toggle_android_enabled) continue;
            this.enabled = tarr.getBoolean(R.styleable.Toggle_android_enabled, false);
        }
    }

    protected void onDraw(Canvas canvas) {
        int alpha;
        super.onDraw(canvas);
        if (this.isEnabled()) {
            alpha = (int)((this.thumbBounds.centerX() - this.thumbOffCenterX) / (this.thumbOnCenterX - this.thumbOffCenterX) * 255.0f);
            alpha = alpha < 0 ? 0 : (alpha > 255 ? 255 : alpha);
            int borderColor = Color.argb((int)alpha, (int)Color.red((int)this.parentOuter), (int)Color.green((int)this.parentOuter), (int)Color.blue((int)this.parentOuter));
            this.paint.setColor(borderColor);
            canvas.drawArc(this.leftBgArc, 90.0f, 180.0f, false, this.paint);
            canvas.drawArc(this.rightBgArc, 90.0f, -180.0f, false, this.paint);
            canvas.drawRect((float)this.outerRadii, 0.0f, (float)(this.width - this.outerRadii), (float)this.height, this.paint);
            canvas.drawArc(this.leftFgArc, 90.0f, 180.0f, false, this.paint);
            canvas.drawArc(this.rightFgArc, 90.0f, -180.0f, false, this.paint);
            canvas.drawRect((float)this.outerRadii, (float)(this.padding >>> 2), (float)(this.width - this.outerRadii), (float)(this.height - (this.padding >>> 2)), this.paint);
            alpha = (int)((this.thumbOnCenterX - this.thumbBounds.centerX()) / (this.thumbOnCenterX - this.thumbOffCenterX) * 255.0f);
            alpha = alpha < 0 ? 0 : (alpha > 255 ? 255 : alpha);
            borderColor = Color.argb((int)alpha, (int)Color.red((int)this.parentDarkOuter), (int)Color.green((int)this.parentDarkOuter), (int)Color.blue((int)this.parentDarkOuter));
            this.paint.setColor(borderColor);
            canvas.drawArc(this.leftBgArc, 90.0f, 180.0f, false, this.paint);
            canvas.drawArc(this.rightBgArc, 90.0f, -180.0f, false, this.paint);
            canvas.drawRect((float)this.outerRadii, 0.0f, (float)(this.width - this.outerRadii), (float)this.height, this.paint);
            canvas.drawArc(this.leftFgArc, 90.0f, 180.0f, false, this.paint);
            canvas.drawArc(this.rightFgArc, 90.0f, -180.0f, false, this.paint);
            canvas.drawRect((float)this.outerRadii, (float)(this.padding >>> 2), (float)(this.width - this.outerRadii), (float)(this.height - (this.padding >>> 2)), this.paint);
        } else {
            this.paint.setColor(this.colorDisabled);
            canvas.drawArc(this.leftBgArc, 90.0f, 180.0f, false, this.paint);
            canvas.drawArc(this.rightBgArc, 90.0f, -180.0f, false, this.paint);
            canvas.drawRect((float)this.outerRadii, 0.0f, (float)(this.width - this.outerRadii), (float)this.height, this.paint);
        }
        alpha = (int)((this.thumbBounds.centerX() - this.thumbOffCenterX) / (this.thumbOnCenterX - this.thumbOffCenterX) * 255.0f);
        alpha = alpha < 0 ? 0 : (alpha > 255 ? 255 : alpha);
        int onColor = this.isEnabled() ? Color.argb((int)alpha, (int)Color.red((int)this.parentInner), (int)Color.green((int)this.parentInner), (int)Color.blue((int)this.parentInner)) : Color.argb((int)alpha, (int)Color.red((int)this.colorDisabled), (int)Color.green((int)this.colorDisabled), (int)Color.blue((int)this.colorDisabled));
        this.paint.setColor(onColor);
        canvas.drawArc(this.leftFgArc, 90.0f, 180.0f, false, this.paint);
        canvas.drawArc(this.rightFgArc, 90.0f, -180.0f, false, this.paint);
        canvas.drawRect((float)this.outerRadii, (float)(this.padding >>> 2), (float)(this.width - this.outerRadii), (float)(this.height - (this.padding >>> 2)), this.paint);
        alpha = (int)((this.thumbOnCenterX - this.thumbBounds.centerX()) / (this.thumbOnCenterX - this.thumbOffCenterX) * 255.0f);
        alpha = alpha < 0 ? 0 : (alpha > 255 ? 255 : alpha);
        int offColor = Color.argb((int)alpha, (int)Color.red((int)this.parentDarkInner), (int)Color.green((int)this.parentDarkInner), (int)Color.blue((int)this.parentDarkInner));
        this.paint.setColor(offColor);
        canvas.drawArc(this.leftFgArc, 90.0f, 180.0f, false, this.paint);
        canvas.drawArc(this.rightFgArc, 90.0f, -180.0f, false, this.paint);
        canvas.drawRect((float)this.outerRadii, (float)(this.padding >>> 2), (float)(this.width - this.outerRadii), (float)(this.height - (this.padding >>> 2)), this.paint);
        int alpha2 = (int)((this.thumbOnCenterX - this.thumbBounds.centerX()) / (this.thumbOnCenterX - this.thumbOffCenterX) * 255.0f);
        alpha2 = alpha2 < 0 ? 0 : (alpha2 > 255 ? 255 : alpha2);
        int starColor = Color.argb((int)alpha2, (int)Color.red((int)this.stars), (int)Color.green((int)this.stars), (int)Color.blue((int)this.stars));
        this.paint.setColor(starColor);
        float nightAnimScale = (float)alpha2 / 255.0f;
        canvas.drawCircle((float)this.centerX + (float)(this.thumbRadii >>> 3) * nightAnimScale, (float)this.centerY + ((float)(this.height >>> 2) + (float)(this.thumbRadii >>> 3) * nightAnimScale), (float)(this.thumbRadii >>> 3) * nightAnimScale, this.paint);
        canvas.drawCircle((float)this.centerX + (float)(this.thumbRadii / 10) * nightAnimScale, (float)(this.centerY >>> 1) - (float)(this.thumbRadii / 10) * nightAnimScale, (float)(this.thumbRadii / 10) * nightAnimScale, this.paint);
        canvas.drawCircle((float)this.centerX + ((float)this.centerX - (float)this.thumbRadii / 1.5f * nightAnimScale), (float)this.centerY - (float)(this.thumbRadii >>> 3) * nightAnimScale, (float)(this.thumbRadii >>> 3) * nightAnimScale, this.paint);
        canvas.drawCircle((float)this.centerX + ((float)this.centerX - (float)this.thumbRadii * nightAnimScale), (float)this.centerY - ((float)this.centerY - (float)this.thumbRadii / 1.75f * nightAnimScale), (float)(this.thumbRadii / 10) * nightAnimScale, this.paint);
        canvas.drawCircle((float)this.centerX + ((float)this.centerX - (float)this.thumbRadii / 1.25f * nightAnimScale), (float)this.centerY + ((float)this.centerY - (float)this.thumbRadii / 1.25f * nightAnimScale), (float)(this.thumbRadii / 10) * nightAnimScale, this.paint);
        canvas.drawCircle((float)this.centerX + (float)this.thumbRadii / 1.5f * nightAnimScale, (float)this.centerY - (float)(this.thumbRadii >>> 2) * nightAnimScale, (float)(this.thumbRadii >>> 4) * nightAnimScale, this.paint);
        canvas.drawCircle((float)this.centerX + (float)this.thumbRadii * nightAnimScale, (float)this.centerY + (float)(this.thumbRadii >>> 2) * nightAnimScale, (float)(this.thumbRadii >>> 4) * nightAnimScale, this.paint);
        canvas.save();
        alpha2 = (int)((this.thumbBounds.centerX() - this.thumbOffCenterX) / (this.thumbOnCenterX - this.thumbOffCenterX) * 255.0f);
        alpha2 = alpha2 < 0 ? 0 : (alpha2 > 255 ? 255 : alpha2);
        canvas.rotate((float)alpha2 / 255.0f * 360.0f, this.thumbBounds.centerX(), this.thumbBounds.centerY());
        int sunOuterColor = Color.argb((int)alpha2, (int)Color.red((int)this.sunOuter), (int)Color.green((int)this.sunOuter), (int)Color.blue((int)this.sunOuter));
        this.paint.setColor(sunOuterColor);
        canvas.drawCircle(this.thumbBounds.centerX(), this.thumbBounds.centerY(), (float)this.thumbRadii, this.paint);
        int sunInnerColor = Color.argb((int)alpha2, (int)Color.red((int)this.sunInner), (int)Color.green((int)this.sunInner), (int)Color.blue((int)this.sunInner));
        this.paint.setColor(sunInnerColor);
        canvas.drawCircle(this.thumbBounds.centerX(), this.thumbBounds.centerY(), (float)(this.thumbRadii - this.thumbRadii / 6), this.paint);
        alpha2 = (int)((this.thumbOnCenterX - this.thumbBounds.centerX()) / (this.thumbOnCenterX - this.thumbOffCenterX) * 255.0f);
        alpha2 = alpha2 < 0 ? 0 : (alpha2 > 255 ? 255 : alpha2);
        int moonOuterColor = this.isEnabled() ? Color.argb((int)alpha2, (int)Color.red((int)this.moonOuter), (int)Color.green((int)this.moonOuter), (int)Color.blue((int)this.moonOuter)) : Color.argb((int)alpha2, (int)Color.red((int)this.colorDisabled), (int)Color.green((int)this.colorDisabled), (int)Color.blue((int)this.colorDisabled));
        this.paint.setColor(moonOuterColor);
        canvas.drawCircle(this.thumbBounds.centerX(), this.thumbBounds.centerY(), (float)this.thumbRadii, this.paint);
        int moonInnerColor = Color.argb((int)alpha2, (int)Color.red((int)this.moonInner), (int)Color.green((int)this.moonInner), (int)Color.blue((int)this.moonInner));
        this.paint.setColor(moonInnerColor);
        canvas.drawCircle(this.thumbBounds.centerX(), this.thumbBounds.centerY(), (float)(this.thumbRadii - this.thumbRadii / 6), this.paint);
        int craterBorderColor = Color.argb((int)alpha2, (int)Color.red((int)this.moonOuter), (int)Color.green((int)this.moonOuter), (int)Color.blue((int)this.moonOuter));
        this.paint.setColor(craterBorderColor);
        canvas.drawCircle(this.thumbBounds.centerX() - (float)(this.thumbRadii >>> 1), this.thumbBounds.centerY() - (float)(this.thumbRadii >>> 1), (float)(this.thumbRadii >>> 2), this.paint);
        int craterInnerColor = Color.argb((int)alpha2, (int)Color.red((int)this.craterInner), (int)Color.green((int)this.craterInner), (int)Color.blue((int)this.craterInner));
        this.paint.setColor(craterInnerColor);
        canvas.drawCircle(this.thumbBounds.centerX() - (float)(this.thumbRadii >>> 1), this.thumbBounds.centerY() - (float)(this.thumbRadii >>> 1), (float)(this.thumbRadii >>> 4), this.paint);
        this.paint.setColor(craterBorderColor);
        canvas.drawCircle(this.thumbBounds.centerX() + (float)(this.thumbRadii / 3), this.thumbBounds.centerY() + (float)(this.thumbRadii >>> 1), (float)(this.thumbRadii >>> 2), this.paint);
        this.paint.setColor(craterInnerColor);
        canvas.drawCircle(this.thumbBounds.centerX() + (float)(this.thumbRadii / 3), this.thumbBounds.centerY() + (float)(this.thumbRadii >>> 1), (float)(this.thumbRadii >>> 4), this.paint);
        this.paint.setColor(craterBorderColor);
        canvas.drawCircle(this.thumbBounds.centerX() + (float)(this.thumbRadii >>> 1), this.thumbBounds.centerY() - (float)this.thumbRadii / 2.75f, (float)(this.thumbRadii / 3), this.paint);
        this.paint.setColor(craterInnerColor);
        canvas.drawCircle(this.thumbBounds.centerX() + (float)(this.thumbRadii >>> 1), this.thumbBounds.centerY() - (float)this.thumbRadii / 2.75f, (float)(this.thumbRadii / 6), this.paint);
        canvas.restore();
        alpha2 = (int)((this.thumbBounds.centerX() - this.thumbOffCenterX) / (this.thumbOnCenterX - this.thumbOffCenterX) * 255.0f);
        alpha2 = alpha2 < 0 ? 0 : (alpha2 > 255 ? 255 : alpha2);
        float dayAnimScale = (float)alpha2 / 255.0f;
        this.initOuterCloud(dayAnimScale);
        int cloudOuterColor = Color.argb((int)alpha2, (int)Color.red((int)this.cloudOuter), (int)Color.green((int)this.cloudOuter), (int)Color.blue((int)this.cloudOuter));
        this.paint.setColor(cloudOuterColor);
        canvas.drawPath(this.outerCloud, this.paint);
        int cloudInnerColor = Color.argb((int)alpha2, (int)Color.red((int)this.cloudInner), (int)Color.green((int)this.cloudInner), (int)Color.blue((int)this.cloudInner));
        this.paint.setColor(cloudInnerColor);
        canvas.save();
        canvas.scale(0.8f, 0.8f, (float)this.cloudCenterX + (1.0f - dayAnimScale) * (float)(this.width >>> 2), (float)this.cloudCenterY);
        canvas.drawPath(this.outerCloud, this.paint);
        canvas.restore();
    }

    private void initOuterCloud(float dayAnimScale) {
        float translationScale = 1.0f - dayAnimScale;
        this.outerCloud.reset();
        this.outerCloud.moveTo((float)(this.cloudCenterX + (this.width >>> 3)) + translationScale * (float)(this.width >>> 2), (float)this.cloudCenterY + (float)this.height / 3.5f - (float)(this.centerY >>> 2));
        this.outerCloud.lineTo((float)(this.cloudCenterX - (this.width >>> 3)) + translationScale * (float)(this.width >>> 2), (float)this.cloudCenterY + (float)this.height / 3.5f - (float)(this.centerY >>> 2));
        this.outerCloud.cubicTo((float)(this.cloudCenterX - this.width / 5) + translationScale * (float)(this.width >>> 2), (float)this.cloudCenterY + (float)this.height / 3.5f - (float)(this.centerY >>> 2), (float)(this.cloudCenterX - this.width / 5) + translationScale * (float)(this.width >>> 2), (float)(this.cloudCenterY + this.height / 20 - (this.centerY >>> 2)), (float)(this.cloudCenterX - (this.width >>> 3)) + translationScale * (float)(this.width >>> 2), (float)(this.cloudCenterY + this.height / 20 - (this.centerY >>> 2)));
        this.outerCloud.cubicTo((float)(this.cloudCenterX - (this.width >>> 3)) + translationScale * (float)(this.width >>> 2), (float)(this.cloudCenterY - (this.height >>> 3) - (this.centerY >>> 2)), (float)this.cloudCenterX + translationScale * (float)(this.width >>> 2), (float)(this.cloudCenterY - (this.height >>> 3) - (this.centerY >>> 2)), (float)this.cloudCenterX + translationScale * (float)(this.width >>> 2), (float)(this.cloudCenterY - (this.centerY >>> 2)));
        this.outerCloud.cubicTo((float)this.cloudCenterX + translationScale * (float)(this.width >>> 2), (float)(this.cloudCenterY - this.height / 12 - (this.centerY >>> 2)), (float)(this.cloudCenterX + this.width / 10) + translationScale * (float)(this.width >>> 2), (float)(this.cloudCenterY - this.height / 12 - (this.centerY >>> 2)), (float)(this.cloudCenterX + this.width / 10) + translationScale * (float)(this.width >>> 2), (float)(this.cloudCenterY + (this.height >>> 4) - (this.centerY >>> 2)));
        this.outerCloud.cubicTo((float)(this.cloudCenterX + this.width / 6) + translationScale * (float)(this.width >>> 2), (float)(this.cloudCenterY + (this.height >>> 4) - (this.centerY >>> 2)), (float)(this.cloudCenterX + this.width / 6) + translationScale * (float)(this.width >>> 2), (float)this.cloudCenterY + (float)this.height / 3.5f - (float)(this.centerY >>> 2), (float)(this.cloudCenterX + (this.width >>> 3)) + translationScale * (float)(this.width >>> 2), (float)this.cloudCenterY + (float)this.height / 3.5f - (float)(this.centerY >>> 2));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredWidth = this.getResources().getDimensionPixelSize(R.dimen.day_night_default_width);
        int desiredHeight = this.getResources().getDimensionPixelSize(R.dimen.day_night_default_height);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
        this.height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(desiredHeight, heightSize) : desiredHeight);
        this.setMeasuredDimension(this.width, this.height);
        this.centerX = this.width >>> 1;
        this.centerY = this.height >>> 1;
        this.outerRadii = Math.min(this.centerX, this.centerY);
        this.thumbRadii = (int)((float)Math.min(this.width, this.height) / 2.88f);
        this.padding = this.height - this.thumbRadii >>> 1;
        this.thumbBounds.set((float)(this.width - this.padding - this.thumbRadii), (float)this.padding, (float)(this.width - this.padding), (float)(this.height - this.padding));
        this.thumbOnCenterX = this.thumbBounds.centerX();
        this.thumbBounds.set((float)this.padding, (float)this.padding, (float)(this.padding + this.thumbRadii), (float)(this.height - this.padding));
        this.thumbOffCenterX = this.thumbBounds.centerX();
        if (this.isOn) {
            this.thumbBounds.set((float)(this.width - this.padding - this.thumbRadii), (float)this.padding, (float)(this.width - this.padding), (float)(this.height - this.padding));
        } else {
            this.thumbBounds.set((float)this.padding, (float)this.padding, (float)(this.padding + this.thumbRadii), (float)(this.height - this.padding));
        }
        this.leftBgArc.set(0.0f, 0.0f, (float)(this.outerRadii << 1), (float)this.height);
        this.rightBgArc.set((float)(this.width - (this.outerRadii << 1)), 0.0f, (float)this.width, (float)this.height);
        this.leftFgArc.set((float)(this.padding >>> 2), (float)(this.padding >>> 2), (float)((this.outerRadii << 1) - (this.padding >>> 2)), (float)(this.height - (this.padding >>> 2)));
        this.rightFgArc.set((float)(this.width - (this.outerRadii << 1) + (this.padding >>> 2)), (float)(this.padding >>> 2), (float)(this.width - (this.padding >>> 2)), (float)(this.height - (this.padding >>> 2)));
        this.cloudCenterX = this.centerX;
        this.cloudCenterY = this.centerY + (this.centerY >>> 2);
    }

    public final boolean performClick() {
        super.performClick();
        if (this.isOn) {
            ValueAnimator switchColor = ValueAnimator.ofFloat((float[])new float[]{this.width - this.padding - this.thumbRadii, this.padding});
            switchColor.addUpdateListener(animation -> {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                this.thumbBounds.set(value, this.thumbBounds.top, value + (float)this.thumbRadii, this.thumbBounds.bottom);
                this.invalidate();
            });
            switchColor.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            switchColor.setDuration(150L);
            switchColor.start();
        } else {
            ValueAnimator switchColor = ValueAnimator.ofFloat((float[])new float[]{this.padding, this.width - this.padding - this.thumbRadii});
            switchColor.addUpdateListener(animation -> {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                this.thumbBounds.set(value, this.thumbBounds.top, value + (float)this.thumbRadii, this.thumbBounds.bottom);
                this.invalidate();
            });
            switchColor.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            switchColor.setDuration(150L);
            switchColor.start();
        }
        boolean bl = this.isOn = !this.isOn;
        if (this.onToggledListener != null) {
            this.onToggledListener.onSwitched(this, this.isOn);
        }
        return true;
    }

    public final boolean onTouchEvent(MotionEvent event) {
        if (this.isEnabled()) {
            float x = event.getX();
            switch (event.getAction()) {
                case 0: {
                    this.startTime = System.currentTimeMillis();
                    return true;
                }
                case 2: {
                    if (x - (float)(this.thumbRadii >>> 1) > (float)this.padding && x + (float)(this.thumbRadii >>> 1) < (float)(this.width - this.padding)) {
                        this.thumbBounds.set(x - (float)(this.thumbRadii >>> 1), this.thumbBounds.top, x + (float)(this.thumbRadii >>> 1), this.thumbBounds.bottom);
                        this.invalidate();
                    }
                    return true;
                }
                case 1: 
                case 3: {
                    long endTime = System.currentTimeMillis();
                    long span = endTime - this.startTime;
                    if (span < 200L) {
                        this.performClick();
                    } else {
                        if (x >= (float)this.centerX) {
                            ValueAnimator thumbAnimator = ValueAnimator.ofFloat((float[])new float[]{x > (float)(this.width - this.padding - this.thumbRadii) ? (float)(this.width - this.padding - this.thumbRadii) : x, this.width - this.padding - this.thumbRadii});
                            thumbAnimator.addUpdateListener(animation -> {
                                float value = ((Float)animation.getAnimatedValue()).floatValue();
                                this.thumbBounds.set(value, this.thumbBounds.top, value + (float)this.thumbRadii, this.thumbBounds.bottom);
                                this.invalidate();
                            });
                            thumbAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                            thumbAnimator.setDuration(150L);
                            thumbAnimator.start();
                            this.isOn = true;
                        } else {
                            ValueAnimator thumbAnimator = ValueAnimator.ofFloat((float[])new float[]{x < (float)this.padding ? (float)this.padding : x - (float)this.thumbRadii, this.padding});
                            thumbAnimator.addUpdateListener(animation -> {
                                float value = ((Float)animation.getAnimatedValue()).floatValue();
                                this.thumbBounds.set(value, this.thumbBounds.top, value + (float)this.thumbRadii, this.thumbBounds.bottom);
                                this.invalidate();
                            });
                            thumbAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                            thumbAnimator.setDuration(150L);
                            thumbAnimator.start();
                            this.isOn = false;
                        }
                        if (this.onToggledListener != null) {
                            this.onToggledListener.onSwitched(this, this.isOn);
                        }
                    }
                    this.invalidate();
                    return true;
                }
            }
            return super.onTouchEvent(event);
        }
        return false;
    }

    @Override
    public void setOn(boolean on) {
        super.setOn(on);
        if (this.isOn) {
            this.thumbBounds.set((float)(this.width - this.padding - this.thumbRadii), (float)this.padding, (float)(this.width - this.padding), (float)(this.height - this.padding));
        } else {
            this.thumbBounds.set((float)this.padding, (float)this.padding, (float)(this.padding + this.thumbRadii), (float)(this.height - this.padding));
        }
        this.invalidate();
    }
}

