/*
 * Decompiled with CFR 0.152.
 */
package androidmads.library.qrgenearator;

import android.graphics.Bitmap;
import android.util.Log;
import androidmads.library.qrgenearator.QRGContents;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class QRGSaver {
    public boolean save(String saveLocation, String imageName, Bitmap bitmap, int imageFormat) {
        boolean success = false;
        String imageDetail = saveLocation + imageName + this.imgFormat(imageFormat);
        File file = new File(saveLocation);
        if (!file.exists()) {
            file.mkdir();
        } else {
            Log.d((String)"QRGSaver", (String)"Folder Exists");
        }
        try {
            FileOutputStream outStream = new FileOutputStream(imageDetail);
            bitmap.compress((Bitmap.CompressFormat)this.compressFormat(imageFormat), 100, (OutputStream)outStream);
            outStream.flush();
            outStream.close();
            success = true;
        }
        catch (IOException e) {
            Log.d((String)"QRGSaver", (String)e.toString());
        }
        return success;
    }

    public boolean save(String saveLocation, String imageName, Bitmap bitmap) {
        return this.save(saveLocation, imageName, bitmap, QRGContents.ImageType.IMAGE_PNG);
    }

    private String imgFormat(int imageFormat) {
        return imageFormat == QRGContents.ImageType.IMAGE_PNG ? ".png" : ".jpg";
    }

    private Comparable<? extends Comparable<? extends Comparable<?>>> compressFormat(int imageFormat) {
        return imageFormat == QRGContents.ImageType.IMAGE_PNG ? Bitmap.CompressFormat.PNG : (imageFormat == QRGContents.ImageType.IMAGE_WEBP ? Bitmap.CompressFormat.WEBP : Bitmap.CompressFormat.JPEG);
    }
}

