/*
 * Decompiled with CFR 0.152.
 */
package androidmads.library.qrgenearator;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.telephony.PhoneNumberUtils;
import androidmads.library.qrgenearator.QRGContents;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import java.util.EnumMap;
import java.util.HashSet;

public class QRGEncoder {
    private int WHITE = -1;
    private int BLACK = -16777216;
    private int dimension = Integer.MIN_VALUE;
    private String contents = null;
    private String displayContents = null;
    private String title = null;
    private BarcodeFormat format = null;
    private boolean encoded = false;

    public void setColorWhite(int color) {
        this.WHITE = color;
    }

    public void setColorBlack(int color) {
        this.BLACK = color;
    }

    public int getColorWhite() {
        return this.WHITE;
    }

    public int getColorBlack() {
        return this.BLACK;
    }

    public QRGEncoder(String data, String type) {
        this.encoded = this.encodeContents(data, null, "TEXT_TYPE");
    }

    public QRGEncoder(String data, String type, int dimension) {
        this.dimension = dimension;
        this.encoded = this.encodeContents(data, null, "TEXT_TYPE");
    }

    public QRGEncoder(String data, Bundle bundle, String type, int dimension) {
        this.dimension = dimension;
        this.encoded = this.encodeContents(data, bundle, type);
    }

    public String getTitle() {
        return this.title;
    }

    private boolean encodeContents(String data, Bundle bundle, String type) {
        this.format = BarcodeFormat.QR_CODE;
        if (this.format == BarcodeFormat.QR_CODE) {
            this.format = BarcodeFormat.QR_CODE;
            this.encodeQRCodeContents(data, bundle, type);
        } else if (data != null && data.length() > 0) {
            this.contents = data;
            this.displayContents = data;
            this.title = "Text";
        }
        return this.contents != null && this.contents.length() > 0;
    }

    private void encodeQRCodeContents(String data, Bundle bundle, String type) {
        switch (type) {
            case "TEXT_TYPE": {
                if (data == null || data.length() <= 0) break;
                this.contents = data.replace("\\n", "\n");
                this.displayContents = data;
                this.title = "Text";
                break;
            }
            case "EMAIL_TYPE": {
                data = this.trim(data);
                if (data == null) break;
                this.contents = "mailto:" + data;
                this.displayContents = data;
                this.title = "E-Mail";
                break;
            }
            case "PHONE_TYPE": {
                data = this.trim(data);
                if (data == null) break;
                this.contents = "tel:" + data;
                this.displayContents = PhoneNumberUtils.formatNumber((String)data);
                this.title = "Phone";
                break;
            }
            case "SMS_TYPE": {
                data = this.trim(data);
                if (data == null) break;
                this.contents = "sms:" + data;
                this.displayContents = PhoneNumberUtils.formatNumber((String)data);
                this.title = "SMS";
                break;
            }
            case "CONTACT_TYPE": {
                String note;
                String url;
                String address;
                if (bundle == null) break;
                StringBuilder newContents = new StringBuilder(100);
                StringBuilder newDisplayContents = new StringBuilder(100);
                newContents.append("BEGIN:VCARD\n");
                String name = this.trim(bundle.getString("name"));
                if (name != null) {
                    newContents.append("N:").append(this.escapeVCard(name)).append(';');
                    newDisplayContents.append(name);
                    newContents.append("\n");
                }
                if ((address = this.trim(bundle.getString("postal"))) != null) {
                    newContents.append("ADR:").append(this.escapeVCard(address));
                    newContents.append("\n");
                    newDisplayContents.append('\n').append(address);
                }
                HashSet<String> uniquePhones = new HashSet<String>(QRGContents.PHONE_KEYS.length);
                for (int x = 0; x < QRGContents.PHONE_KEYS.length; ++x) {
                    String phone = this.trim(bundle.getString(QRGContents.PHONE_KEYS[x]));
                    if (phone == null) continue;
                    uniquePhones.add(phone);
                }
                for (String phone : uniquePhones) {
                    newContents.append("TEL:").append(this.escapeVCard(phone));
                    newContents.append("\n");
                    newDisplayContents.append('\n').append(PhoneNumberUtils.formatNumber((String)phone));
                }
                HashSet<String> uniqueEmails = new HashSet<String>(QRGContents.EMAIL_KEYS.length);
                for (int x = 0; x < QRGContents.EMAIL_KEYS.length; ++x) {
                    String email = this.trim(bundle.getString(QRGContents.EMAIL_KEYS[x]));
                    if (email == null) continue;
                    uniqueEmails.add(email);
                }
                for (String email : uniqueEmails) {
                    newContents.append("EMAIL:").append(this.escapeVCard(email));
                    newContents.append("\n");
                    newDisplayContents.append('\n').append(email);
                }
                String organization = this.trim(bundle.getString("company"));
                if (organization != null) {
                    newContents.append("ORG:").append(organization);
                    newContents.append("\n");
                    newDisplayContents.append('\n').append(organization);
                }
                if ((url = this.trim(bundle.getString("data"))) != null) {
                    newContents.append("URL:").append(this.escapeVCard(url));
                    newContents.append("\n");
                    newDisplayContents.append('\n').append(url);
                }
                if ((note = this.trim(bundle.getString("notes"))) != null) {
                    newContents.append("NOTE:").append(this.escapeVCard(note));
                    newContents.append("\n");
                    newDisplayContents.append('\n').append(note);
                }
                if (newDisplayContents.length() > 0) {
                    newContents.append("END:VCARD");
                    newContents.append(';');
                    this.contents = newContents.toString();
                    this.displayContents = newDisplayContents.toString();
                    this.title = "Contact";
                    break;
                }
                this.contents = null;
                this.displayContents = null;
                break;
            }
            case "LOCATION_TYPE": {
                if (bundle == null) break;
                float latitude = bundle.getFloat("LAT", Float.MAX_VALUE);
                float longitude = bundle.getFloat("LONG", Float.MAX_VALUE);
                if (latitude == Float.MAX_VALUE || longitude == Float.MAX_VALUE) break;
                this.contents = "geo:" + latitude + ',' + longitude;
                this.displayContents = latitude + "," + longitude;
                this.title = "Location";
            }
        }
    }

    public Bitmap getBitmap() {
        if (!this.encoded) {
            return null;
        }
        try {
            EnumMap<EncodeHintType, String> hints = null;
            String encoding = this.guessAppropriateEncoding(this.contents);
            if (encoding != null) {
                hints = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
                hints.put(EncodeHintType.CHARACTER_SET, encoding);
            }
            MultiFormatWriter writer = new MultiFormatWriter();
            BitMatrix result = writer.encode(this.contents, this.format, this.dimension, this.dimension, hints);
            int width = result.getWidth();
            int height = result.getHeight();
            int[] pixels = new int[width * height];
            for (int y = 0; y < height; ++y) {
                int offset = y * width;
                for (int x = 0; x < width; ++x) {
                    pixels[offset + x] = result.get(x, y) ? this.getColorWhite() : this.getColorBlack();
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
            return bitmap;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Bitmap getBitmap(int margin) {
        if (!this.encoded) {
            return null;
        }
        try {
            EnumMap<EncodeHintType, Object> hints = null;
            hints = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
            String encoding = this.guessAppropriateEncoding(this.contents);
            if (encoding != null) {
                hints.put(EncodeHintType.CHARACTER_SET, (Object)encoding);
            }
            hints.put(EncodeHintType.MARGIN, (Object)margin);
            MultiFormatWriter writer = new MultiFormatWriter();
            BitMatrix result = writer.encode(this.contents, this.format, this.dimension, this.dimension, hints);
            int width = result.getWidth();
            int height = result.getHeight();
            int[] pixels = new int[width * height];
            for (int y = 0; y < height; ++y) {
                int offset = y * width;
                for (int x = 0; x < width; ++x) {
                    pixels[offset + x] = result.get(x, y) ? this.getColorBlack() : this.getColorWhite();
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
            return bitmap;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String guessAppropriateEncoding(CharSequence contents) {
        for (int i = 0; i < contents.length(); ++i) {
            if (contents.charAt(i) <= '\u00ff') continue;
            return "UTF-8";
        }
        return "UTF-8";
    }

    private String trim(String s) {
        if (s == null) {
            return null;
        }
        String result = s.trim();
        return result.length() == 0 ? null : result;
    }

    private String escapeVCard(String input) {
        if (input == null || input.indexOf(58) < 0 && input.indexOf(59) < 0) {
            return input;
        }
        int length = input.length();
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            if (c == ':' || c == ';') {
                result.append('\\');
            }
            result.append(c);
        }
        return result.toString();
    }
}

