/*
 * Decompiled with CFR 0.152.
 */
package androidmads.library.qrgenearator;

import android.graphics.Bitmap;
import androidmads.library.qrgenearator.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.util.EnumMap;

public class BarcodeEncoder {
    private int WHITE = -1;
    private int BLACK = -16777216;
    private int dimension = 500;
    private String contents = null;
    private BarcodeFormat format = BarcodeFormat.CODE_128;

    public void setColorWhite(int color) {
        this.WHITE = color;
    }

    public void setColorBlack(int color) {
        this.BLACK = color;
    }

    public int getColorWhite() {
        return this.WHITE;
    }

    public int getColorBlack() {
        return this.BLACK;
    }

    public BarcodeEncoder(String data, BarcodeFormat format) {
        this.contents = data;
        this.format = format;
    }

    public BarcodeEncoder(String data, BarcodeFormat format, int dimension) {
        this.contents = data;
        this.format = format;
        this.dimension = dimension;
    }

    public Bitmap getBitmap() {
        return this.getBitmap(0);
    }

    public Bitmap getBitmap(int margin) {
        if (this.contents == null || this.contents.isEmpty()) {
            return null;
        }
        try {
            EnumMap<EncodeHintType, Integer> hints = new EnumMap<EncodeHintType, Integer>(EncodeHintType.class);
            hints.put(EncodeHintType.MARGIN, margin);
            MultiFormatWriter writer = new MultiFormatWriter();
            BitMatrix result = writer.encode(this.contents, BarcodeEncoder.convertToZXingFormat(this.format), this.dimension, this.dimension, hints);
            int width = result.getWidth();
            int height = result.getHeight();
            int[] pixels = new int[width * height];
            for (int y = 0; y < height; ++y) {
                int offset = y * width;
                for (int x = 0; x < width; ++x) {
                    pixels[offset + x] = result.get(x, y) ? this.getColorBlack() : this.getColorWhite();
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
            return bitmap;
        }
        catch (WriterException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static com.google.zxing.BarcodeFormat convertToZXingFormat(BarcodeFormat aFormat) {
        if (aFormat == null) {
            throw new IllegalArgumentException("Format cannot be null");
        }
        switch (aFormat) {
            case AZTEC: {
                return com.google.zxing.BarcodeFormat.AZTEC;
            }
            case CODABAR: {
                return com.google.zxing.BarcodeFormat.CODABAR;
            }
            case CODE_39: {
                return com.google.zxing.BarcodeFormat.CODE_39;
            }
            case CODE_93: {
                return com.google.zxing.BarcodeFormat.CODE_93;
            }
            case CODE_128: {
                return com.google.zxing.BarcodeFormat.CODE_128;
            }
            case DATA_MATRIX: {
                return com.google.zxing.BarcodeFormat.DATA_MATRIX;
            }
            case EAN_8: {
                return com.google.zxing.BarcodeFormat.EAN_8;
            }
            case EAN_13: {
                return com.google.zxing.BarcodeFormat.EAN_13;
            }
            case ITF: {
                return com.google.zxing.BarcodeFormat.ITF;
            }
            case MAXICODE: {
                return com.google.zxing.BarcodeFormat.MAXICODE;
            }
            case PDF_417: {
                return com.google.zxing.BarcodeFormat.PDF_417;
            }
            case QR_CODE: {
                return com.google.zxing.BarcodeFormat.QR_CODE;
            }
            case RSS_14: {
                return com.google.zxing.BarcodeFormat.RSS_14;
            }
            case RSS_EXPANDED: {
                return com.google.zxing.BarcodeFormat.RSS_EXPANDED;
            }
            case UPC_A: {
                return com.google.zxing.BarcodeFormat.UPC_A;
            }
            case UPC_E: {
                return com.google.zxing.BarcodeFormat.UPC_E;
            }
            case UPC_EAN_EXTENSION: {
                return com.google.zxing.BarcodeFormat.UPC_EAN_EXTENSION;
            }
        }
        throw new IllegalArgumentException("Unsupported format: " + (Object)((Object)aFormat));
    }
}

