/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib.components.indicators;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.anastr.speedviewlib.Speedometer;
import com.github.anastr.speedviewlib.components.indicators.KiteIndicator;
import com.github.anastr.speedviewlib.components.indicators.LineIndicator;
import com.github.anastr.speedviewlib.components.indicators.NeedleIndicator;
import com.github.anastr.speedviewlib.components.indicators.NoIndicator;
import com.github.anastr.speedviewlib.components.indicators.NormalIndicator;
import com.github.anastr.speedviewlib.components.indicators.NormalSmallIndicator;
import com.github.anastr.speedviewlib.components.indicators.SpindleIndicator;
import com.github.anastr.speedviewlib.components.indicators.TriangleIndicator;
import java.util.Observable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u0000 4*\u0010\b\u0000\u0010\u0001 \u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002:\u000245B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000eJ\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000eH&J\b\u0010(\u001a\u00020\u000eH\u0016J\u0006\u0010)\u001a\u00020\u000eJ\u0006\u0010*\u001a\u00020\u000eJ\u0006\u0010+\u001a\u00020\u000eJ\b\u0010,\u001a\u00020\u000eH\u0016J\u0006\u0010-\u001a\u00020\u000eJ\u0013\u0010.\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020$2\u0006\u00101\u001a\u000202H$J\b\u00103\u001a\u00020$H&J\u000e\u00101\u001a\u00020$2\u0006\u00101\u001a\u000202R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00066"}, d2={"Lcom/github/anastr/speedviewlib/components/indicators/Indicator;", "I", "Ljava/util/Observable;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "indicatorColor", "", "color", "getColor", "()I", "setColor", "(I)V", "density", "", "indicatorPaint", "Landroid/graphics/Paint;", "getIndicatorPaint", "()Landroid/graphics/Paint;", "setIndicatorPaint", "(Landroid/graphics/Paint;)V", "speedometer", "Lcom/github/anastr/speedviewlib/Speedometer;", "getSpeedometer", "()Lcom/github/anastr/speedviewlib/Speedometer;", "setSpeedometer", "(Lcom/github/anastr/speedviewlib/Speedometer;)V", "indicatorWidth", "width", "getWidth", "()F", "setWidth", "(F)V", "dpTOpx", "dp", "draw", "", "canvas", "Landroid/graphics/Canvas;", "degree", "getBottom", "getCenterX", "getCenterY", "getLightBottom", "getTop", "getViewSize", "setTargetSpeedometer", "(Lcom/github/anastr/speedviewlib/Speedometer;)Lcom/github/anastr/speedviewlib/components/indicators/Indicator;", "setWithEffects", "withEffects", "", "updateIndicator", "Companion", "Indicators", "speedviewlib_release"})
public abstract class Indicator<I extends Indicator<? extends I>>
extends Observable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Paint indicatorPaint;
    private final float density;
    @Nullable
    private Speedometer speedometer;
    private float width;
    private int color;

    public Indicator(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.indicatorPaint = new Paint(1);
        this.density = context.getResources().getDisplayMetrics().density;
        this.color = -14575885;
        this.indicatorPaint.setColor(this.color);
    }

    @NotNull
    protected final Paint getIndicatorPaint() {
        return this.indicatorPaint;
    }

    protected final void setIndicatorPaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.indicatorPaint = paint;
    }

    @Nullable
    protected final Speedometer getSpeedometer() {
        return this.speedometer;
    }

    protected final void setSpeedometer(@Nullable Speedometer speedometer) {
        this.speedometer = speedometer;
    }

    public final float getWidth() {
        return this.width;
    }

    public final void setWidth(float indicatorWidth) {
        this.width = indicatorWidth;
        Speedometer speedometer = this.speedometer;
        if (speedometer != null) {
            Speedometer speedometer2 = speedometer;
            boolean bl = false;
            boolean bl2 = false;
            Speedometer it = speedometer2;
            boolean bl3 = false;
            this.updateIndicator();
        }
        this.setChanged();
        this.notifyObservers(null);
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int indicatorColor) {
        this.color = indicatorColor;
        Speedometer speedometer = this.speedometer;
        if (speedometer != null) {
            Speedometer speedometer2 = speedometer;
            boolean bl = false;
            boolean bl2 = false;
            Speedometer it = speedometer2;
            boolean bl3 = false;
            this.updateIndicator();
        }
        this.setChanged();
        this.notifyObservers(null);
    }

    public float getTop() {
        float f;
        if (this.speedometer != null) {
            Speedometer speedometer = this.speedometer;
            Intrinsics.checkNotNull((Object)speedometer);
            f = speedometer.getPadding();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public float getBottom() {
        return this.getCenterY();
    }

    public final float getLightBottom() {
        return this.getCenterY() > this.getBottom() ? this.getBottom() : this.getCenterY();
    }

    public final float getCenterX() {
        float f;
        if (this.speedometer != null) {
            Speedometer speedometer = this.speedometer;
            Intrinsics.checkNotNull((Object)speedometer);
            f = (float)speedometer.getSize() / 2.0f;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final float getCenterY() {
        float f;
        if (this.speedometer != null) {
            Speedometer speedometer = this.speedometer;
            Intrinsics.checkNotNull((Object)speedometer);
            f = (float)speedometer.getSize() / 2.0f;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public abstract void draw(@NotNull Canvas var1, float var2);

    public abstract void updateIndicator();

    protected abstract void setWithEffects(boolean var1);

    @NotNull
    public final I setTargetSpeedometer(@NotNull Speedometer speedometer) {
        Intrinsics.checkNotNullParameter((Object)speedometer, (String)"speedometer");
        this.deleteObservers();
        this.addObserver(speedometer);
        this.speedometer = speedometer;
        this.updateIndicator();
        return (I)this;
    }

    public final float dpTOpx(float dp) {
        return dp * this.density;
    }

    public final float getViewSize() {
        Speedometer speedometer = this.speedometer;
        if (speedometer != null) {
            Speedometer speedometer2 = speedometer;
            boolean bl = false;
            boolean bl2 = false;
            Speedometer it = speedometer2;
            boolean bl3 = false;
            return (float)it.getSize() - (float)it.getPadding() * 2.0f;
        }
        return 0.0f;
    }

    public final void withEffects(boolean withEffects) {
        this.setWithEffects(withEffects);
        Speedometer speedometer = this.speedometer;
        if (speedometer != null) {
            Speedometer speedometer2 = speedometer;
            boolean bl = false;
            boolean bl2 = false;
            Speedometer it = speedometer2;
            boolean bl3 = false;
            this.updateIndicator();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/github/anastr/speedviewlib/components/indicators/Indicator$Indicators;", "", "(Ljava/lang/String;I)V", "NoIndicator", "NormalIndicator", "NormalSmallIndicator", "TriangleIndicator", "SpindleIndicator", "LineIndicator", "HalfLineIndicator", "QuarterLineIndicator", "KiteIndicator", "NeedleIndicator", "speedviewlib_release"})
    public static final class Indicators
    extends Enum<Indicators> {
        public static final /* enum */ Indicators NoIndicator = new Indicators();
        public static final /* enum */ Indicators NormalIndicator = new Indicators();
        public static final /* enum */ Indicators NormalSmallIndicator = new Indicators();
        public static final /* enum */ Indicators TriangleIndicator = new Indicators();
        public static final /* enum */ Indicators SpindleIndicator = new Indicators();
        public static final /* enum */ Indicators LineIndicator = new Indicators();
        public static final /* enum */ Indicators HalfLineIndicator = new Indicators();
        public static final /* enum */ Indicators QuarterLineIndicator = new Indicators();
        public static final /* enum */ Indicators KiteIndicator = new Indicators();
        public static final /* enum */ Indicators NeedleIndicator = new Indicators();
        private static final /* synthetic */ Indicators[] $VALUES;

        public static Indicators[] values() {
            return (Indicators[])$VALUES.clone();
        }

        public static Indicators valueOf(String value) {
            return Enum.valueOf(Indicators.class, value);
        }

        static {
            $VALUES = indicatorsArray = new Indicators[]{Indicators.NoIndicator, Indicators.NormalIndicator, Indicators.NormalSmallIndicator, Indicators.TriangleIndicator, Indicators.SpindleIndicator, Indicators.LineIndicator, Indicators.HalfLineIndicator, Indicators.QuarterLineIndicator, Indicators.KiteIndicator, Indicators.NeedleIndicator};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/github/anastr/speedviewlib/components/indicators/Indicator$Companion;", "", "()V", "createIndicator", "Lcom/github/anastr/speedviewlib/components/indicators/Indicator;", "context", "Landroid/content/Context;", "speedometer", "Lcom/github/anastr/speedviewlib/Speedometer;", "indicator", "Lcom/github/anastr/speedviewlib/components/indicators/Indicator$Indicators;", "speedviewlib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Indicator<?> createIndicator(@NotNull Context context, @NotNull Speedometer speedometer, @NotNull Indicators indicator) {
            Indicator indicator2;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)speedometer, (String)"speedometer");
            Intrinsics.checkNotNullParameter((Object)((Object)indicator), (String)"indicator");
            Indicators indicators = indicator;
            int n = WhenMappings.$EnumSwitchMapping$0[indicators.ordinal()];
            switch (n) {
                case 1: {
                    indicator2 = new NoIndicator(context);
                    break;
                }
                case 2: {
                    indicator2 = new NormalIndicator(context);
                    break;
                }
                case 3: {
                    indicator2 = new NormalSmallIndicator(context);
                    break;
                }
                case 4: {
                    indicator2 = new TriangleIndicator(context);
                    break;
                }
                case 5: {
                    indicator2 = new SpindleIndicator(context);
                    break;
                }
                case 6: {
                    indicator2 = new LineIndicator(context, 1.0f);
                    break;
                }
                case 7: {
                    indicator2 = new LineIndicator(context, 0.5f);
                    break;
                }
                case 8: {
                    indicator2 = new LineIndicator(context, 0.25f);
                    break;
                }
                case 9: {
                    indicator2 = new KiteIndicator(context);
                    break;
                }
                case 10: {
                    indicator2 = new NeedleIndicator(context);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return indicator2.setTargetSpeedometer(speedometer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Indicators.values().length];
                nArray[Indicators.NoIndicator.ordinal()] = 1;
                nArray[Indicators.NormalIndicator.ordinal()] = 2;
                nArray[Indicators.NormalSmallIndicator.ordinal()] = 3;
                nArray[Indicators.TriangleIndicator.ordinal()] = 4;
                nArray[Indicators.SpindleIndicator.ordinal()] = 5;
                nArray[Indicators.LineIndicator.ordinal()] = 6;
                nArray[Indicators.HalfLineIndicator.ordinal()] = 7;
                nArray[Indicators.QuarterLineIndicator.ordinal()] = 8;
                nArray[Indicators.KiteIndicator.ordinal()] = 9;
                nArray[Indicators.NeedleIndicator.ordinal()] = 10;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

