/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastr.speedviewlib.components.indicators;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.anastr.speedviewlib.Speedometer;
import com.github.anastr.speedviewlib.components.indicators.Indicator$Companion$WhenMappings;
import com.github.anastr.speedviewlib.components.indicators.KiteIndicator;
import com.github.anastr.speedviewlib.components.indicators.LineIndicator;
import com.github.anastr.speedviewlib.components.indicators.NeedleIndicator;
import com.github.anastr.speedviewlib.components.indicators.NoIndicator;
import com.github.anastr.speedviewlib.components.indicators.NormalIndicator;
import com.github.anastr.speedviewlib.components.indicators.NormalSmallIndicator;
import com.github.anastr.speedviewlib.components.indicators.SpindleIndicator;
import com.github.anastr.speedviewlib.components.indicators.TriangleIndicator;
import java.util.Observable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u0000 4*\u0010\b\u0000\u0010\u0001 \u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002:\u000245B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000eJ\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000eH&J\b\u0010(\u001a\u00020\u000eH\u0016J\u0006\u0010)\u001a\u00020\u000eJ\u0006\u0010*\u001a\u00020\u000eJ\u0006\u0010+\u001a\u00020\u000eJ\b\u0010,\u001a\u00020\u000eH\u0016J\u0006\u0010-\u001a\u00020\u000eJ\u0013\u0010.\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020$2\u0006\u00101\u001a\u000202H$J\b\u00103\u001a\u00020$H&J\u000e\u00101\u001a\u00020$2\u0006\u00101\u001a\u000202R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00066"}, d2={"Lcom/github/anastr/speedviewlib/components/indicators/Indicator;", "I", "Ljava/util/Observable;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "indicatorColor", "", "color", "getColor", "()I", "setColor", "(I)V", "density", "", "indicatorPaint", "Landroid/graphics/Paint;", "getIndicatorPaint", "()Landroid/graphics/Paint;", "setIndicatorPaint", "(Landroid/graphics/Paint;)V", "speedometer", "Lcom/github/anastr/speedviewlib/Speedometer;", "getSpeedometer", "()Lcom/github/anastr/speedviewlib/Speedometer;", "setSpeedometer", "(Lcom/github/anastr/speedviewlib/Speedometer;)V", "indicatorWidth", "width", "getWidth", "()F", "setWidth", "(F)V", "dpTOpx", "dp", "draw", "", "canvas", "Landroid/graphics/Canvas;", "degree", "getBottom", "getCenterX", "getCenterY", "getLightBottom", "getTop", "getViewSize", "setTargetSpeedometer", "(Lcom/github/anastr/speedviewlib/Speedometer;)Lcom/github/anastr/speedviewlib/components/indicators/Indicator;", "setWithEffects", "withEffects", "", "updateIndicator", "Companion", "Indicators", "speedviewlib_release"})
public abstract class Indicator<I extends Indicator<? extends I>>
extends Observable {
    @NotNull
    private Paint indicatorPaint;
    private final float density;
    @Nullable
    private Speedometer speedometer;
    private float width;
    private int color;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final Paint getIndicatorPaint() {
        return this.indicatorPaint;
    }

    protected final void setIndicatorPaint(@NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"<set-?>");
        this.indicatorPaint = paint;
    }

    @Nullable
    protected final Speedometer getSpeedometer() {
        return this.speedometer;
    }

    protected final void setSpeedometer(@Nullable Speedometer speedometer) {
        this.speedometer = speedometer;
    }

    public final float getWidth() {
        return this.width;
    }

    public final void setWidth(float indicatorWidth) {
        this.width = indicatorWidth;
        Speedometer speedometer = this.speedometer;
        if (speedometer != null) {
            Speedometer speedometer2 = speedometer;
            boolean bl = false;
            boolean bl2 = false;
            Speedometer it = speedometer2;
            boolean bl3 = false;
            this.updateIndicator();
        }
        this.setChanged();
        this.notifyObservers(null);
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int indicatorColor) {
        this.color = indicatorColor;
        Speedometer speedometer = this.speedometer;
        if (speedometer != null) {
            Speedometer speedometer2 = speedometer;
            boolean bl = false;
            boolean bl2 = false;
            Speedometer it = speedometer2;
            boolean bl3 = false;
            this.updateIndicator();
        }
        this.setChanged();
        this.notifyObservers(null);
    }

    public float getTop() {
        float f;
        if (this.speedometer != null) {
            Speedometer speedometer = this.speedometer;
            if (speedometer == null) {
                Intrinsics.throwNpe();
            }
            f = speedometer.getPadding();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public float getBottom() {
        return this.getCenterY();
    }

    public final float getLightBottom() {
        return this.getCenterY() > this.getBottom() ? this.getBottom() : this.getCenterY();
    }

    public final float getCenterX() {
        float f;
        if (this.speedometer != null) {
            Speedometer speedometer = this.speedometer;
            if (speedometer == null) {
                Intrinsics.throwNpe();
            }
            f = (float)speedometer.getSize() / 2.0f;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final float getCenterY() {
        float f;
        if (this.speedometer != null) {
            Speedometer speedometer = this.speedometer;
            if (speedometer == null) {
                Intrinsics.throwNpe();
            }
            f = (float)speedometer.getSize() / 2.0f;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public abstract void draw(@NotNull Canvas var1, float var2);

    public abstract void updateIndicator();

    protected abstract void setWithEffects(boolean var1);

    @NotNull
    public final I setTargetSpeedometer(@NotNull Speedometer speedometer) {
        Intrinsics.checkParameterIsNotNull((Object)speedometer, (String)"speedometer");
        this.deleteObservers();
        this.addObserver(speedometer);
        this.speedometer = speedometer;
        this.updateIndicator();
        Indicator indicator = this;
        if (indicator == null) {
            throw new TypeCastException("null cannot be cast to non-null type I");
        }
        return (I)indicator;
    }

    public final float dpTOpx(float dp) {
        return dp * this.density;
    }

    public final float getViewSize() {
        Speedometer speedometer = this.speedometer;
        if (speedometer != null) {
            Speedometer speedometer2 = speedometer;
            boolean bl = false;
            boolean bl2 = false;
            Speedometer it = speedometer2;
            boolean bl3 = false;
            return (float)it.getSize() - (float)it.getPadding() * 2.0f;
        }
        return 0.0f;
    }

    public final void withEffects(boolean withEffects) {
        block0: {
            this.setWithEffects(withEffects);
            Speedometer speedometer = this.speedometer;
            if (speedometer == null) break block0;
            Speedometer speedometer2 = speedometer;
            boolean bl = false;
            boolean bl2 = false;
            Speedometer it = speedometer2;
            boolean bl3 = false;
            this.updateIndicator();
        }
    }

    public Indicator(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.indicatorPaint = new Paint(1);
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        this.density = resources.getDisplayMetrics().density;
        this.color = (int)4280391411L;
        this.indicatorPaint.setColor(this.color);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/github/anastr/speedviewlib/components/indicators/Indicator$Indicators;", "", "(Ljava/lang/String;I)V", "NoIndicator", "NormalIndicator", "NormalSmallIndicator", "TriangleIndicator", "SpindleIndicator", "LineIndicator", "HalfLineIndicator", "QuarterLineIndicator", "KiteIndicator", "NeedleIndicator", "speedviewlib_release"})
    public static final class Indicators
    extends Enum<Indicators> {
        public static final /* enum */ Indicators NoIndicator;
        public static final /* enum */ Indicators NormalIndicator;
        public static final /* enum */ Indicators NormalSmallIndicator;
        public static final /* enum */ Indicators TriangleIndicator;
        public static final /* enum */ Indicators SpindleIndicator;
        public static final /* enum */ Indicators LineIndicator;
        public static final /* enum */ Indicators HalfLineIndicator;
        public static final /* enum */ Indicators QuarterLineIndicator;
        public static final /* enum */ Indicators KiteIndicator;
        public static final /* enum */ Indicators NeedleIndicator;
        private static final /* synthetic */ Indicators[] $VALUES;

        static {
            Indicators[] indicatorsArray = new Indicators[10];
            Indicators[] indicatorsArray2 = indicatorsArray;
            indicatorsArray[0] = NoIndicator = new Indicators();
            indicatorsArray[1] = NormalIndicator = new Indicators();
            indicatorsArray[2] = NormalSmallIndicator = new Indicators();
            indicatorsArray[3] = TriangleIndicator = new Indicators();
            indicatorsArray[4] = SpindleIndicator = new Indicators();
            indicatorsArray[5] = LineIndicator = new Indicators();
            indicatorsArray[6] = HalfLineIndicator = new Indicators();
            indicatorsArray[7] = QuarterLineIndicator = new Indicators();
            indicatorsArray[8] = KiteIndicator = new Indicators();
            indicatorsArray[9] = NeedleIndicator = new Indicators();
            $VALUES = indicatorsArray;
        }

        public static Indicators[] values() {
            return (Indicators[])$VALUES.clone();
        }

        public static Indicators valueOf(String string) {
            return Enum.valueOf(Indicators.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/github/anastr/speedviewlib/components/indicators/Indicator$Companion;", "", "()V", "createIndicator", "Lcom/github/anastr/speedviewlib/components/indicators/Indicator;", "context", "Landroid/content/Context;", "speedometer", "Lcom/github/anastr/speedviewlib/Speedometer;", "indicator", "Lcom/github/anastr/speedviewlib/components/indicators/Indicator$Indicators;", "speedviewlib_release"})
    public static final class Companion {
        @NotNull
        public final Indicator<?> createIndicator(@NotNull Context context, @NotNull Speedometer speedometer, @NotNull Indicators indicator) {
            Indicator indicator2;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)speedometer, (String)"speedometer");
            Intrinsics.checkParameterIsNotNull((Object)((Object)indicator), (String)"indicator");
            switch (Indicator$Companion$WhenMappings.$EnumSwitchMapping$0[indicator.ordinal()]) {
                case 1: {
                    indicator2 = new NoIndicator(context);
                    break;
                }
                case 2: {
                    indicator2 = new NormalIndicator(context);
                    break;
                }
                case 3: {
                    indicator2 = new NormalSmallIndicator(context);
                    break;
                }
                case 4: {
                    indicator2 = new TriangleIndicator(context);
                    break;
                }
                case 5: {
                    indicator2 = new SpindleIndicator(context);
                    break;
                }
                case 6: {
                    indicator2 = new LineIndicator(context, 1.0f);
                    break;
                }
                case 7: {
                    indicator2 = new LineIndicator(context, 0.5f);
                    break;
                }
                case 8: {
                    indicator2 = new LineIndicator(context, 0.25f);
                    break;
                }
                case 9: {
                    indicator2 = new KiteIndicator(context);
                    break;
                }
                case 10: {
                    indicator2 = new NeedleIndicator(context);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return indicator2.setTargetSpeedometer(speedometer);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

