/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage.filter;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;

public class GPUImageOpacityFilter
extends GPUImageFilter {
    public static final String OPACITY_FRAGMENT_SHADER = "  varying highp vec2 textureCoordinate;\n  \n  uniform sampler2D inputImageTexture;\n  uniform lowp float opacity;\n  \n  void main()\n  {\n      lowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n      \n      gl_FragColor = vec4(textureColor.rgb, textureColor.a * opacity);\n  }\n";
    private int opacityLocation;
    private float opacity;

    public GPUImageOpacityFilter() {
        this(1.0f);
    }

    public GPUImageOpacityFilter(float opacity) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", OPACITY_FRAGMENT_SHADER);
        this.opacity = opacity;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.opacityLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"opacity");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setOpacity(this.opacity);
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
        this.setFloat(this.opacityLocation, this.opacity);
    }
}

