package amf.shapes.client.platform.model.domain

import amf.core.client.platform.model.BoolField
import amf.core.client.platform.model.domain.Shape
import amf.shapes.internal.convert.ShapeClientConverters.ClientList

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}
import amf.shapes.internal.convert.ShapeClientConverters._
import amf.shapes.client.scala.model.domain.{TupleShape => InternalTupleShape}

@JSExportAll
case class TupleShape(private[amf] override val _internal: InternalTupleShape) extends DataArrangeShape(_internal) {

  @JSExportTopLevel("TupleShape")
  def this() = this(InternalTupleShape())

  def items: ClientList[Shape] = _internal.items.asClient

  def withItems(items: ClientList[Shape]): this.type = {
    _internal.withItems(items.asInternal)
    this
  }

  def closedItems: BoolField = _internal.closedItems

  def withClosedItems(closedItems: Boolean): this.type = {
    _internal.withClosedItems(closedItems)
    this
  }

  def additionalItemsSchema: Shape = _internal.additionalItemsSchema

  override def linkCopy(): TupleShape = _internal.linkCopy()
}
