/*
 * Decompiled with CFR 0.152.
 */
package com.github.amlcurran.showcaseview.targets;

import android.app.Activity;
import android.graphics.Point;
import android.view.ViewParent;
import com.github.amlcurran.showcaseview.targets.ActionBarViewWrapper;
import com.github.amlcurran.showcaseview.targets.Reflector;
import com.github.amlcurran.showcaseview.targets.ReflectorFactory;
import com.github.amlcurran.showcaseview.targets.Target;
import com.github.amlcurran.showcaseview.targets.ViewTarget;

public class ActionViewTarget
implements Target {
    private final Activity mActivity;
    private final Type mType;
    ActionBarViewWrapper mActionBarWrapper;
    Reflector mReflector;

    public ActionViewTarget(Activity activity, Type type) {
        this.mActivity = activity;
        this.mType = type;
    }

    protected void setUp() {
        this.mReflector = ReflectorFactory.getReflectorForActivity(this.mActivity);
        ViewParent p = this.mReflector.getActionBarView();
        this.mActionBarWrapper = new ActionBarViewWrapper(p);
    }

    @Override
    public Point getPoint() {
        Target internal = null;
        this.setUp();
        switch (this.mType) {
            case SPINNER: {
                internal = new ViewTarget(this.mActionBarWrapper.getSpinnerView());
                break;
            }
            case HOME: {
                internal = new ViewTarget(this.mReflector.getHomeButton());
                break;
            }
            case OVERFLOW: {
                internal = new ViewTarget(this.mActionBarWrapper.getOverflowView());
                break;
            }
            case TITLE: {
                internal = new ViewTarget(this.mActionBarWrapper.getTitleView());
                break;
            }
            case MEDIA_ROUTE_BUTTON: {
                internal = new ViewTarget(this.mActionBarWrapper.getMediaRouterButtonView());
            }
        }
        return internal.getPoint();
    }

    public static enum Type {
        SPINNER,
        HOME,
        TITLE,
        OVERFLOW,
        MEDIA_ROUTE_BUTTON;

    }
}

