/*
 * Decompiled with CFR 0.152.
 */
package com.github.amlcurran.showcaseview;

import android.content.Context;
import android.content.SharedPreferences;

class ShotStateStore {
    private static final String PREFS_SHOWCASE_INTERNAL = "showcase_internal";
    private static final int INVALID_SHOT_ID = -1;
    long shotId = -1L;
    private final Context context;

    public ShotStateStore(Context context) {
        this.context = context;
    }

    boolean hasShot() {
        return this.isSingleShot() && this.context.getSharedPreferences(PREFS_SHOWCASE_INTERNAL, 0).getBoolean("hasShot" + this.shotId, false);
    }

    boolean isSingleShot() {
        return this.shotId != -1L;
    }

    void storeShot() {
        if (this.isSingleShot()) {
            SharedPreferences internal = this.context.getSharedPreferences(PREFS_SHOWCASE_INTERNAL, 0);
            internal.edit().putBoolean("hasShot" + this.shotId, true).apply();
        }
    }

    void setSingleShot(long shotId) {
        this.shotId = shotId;
    }
}

