/*
 * Decompiled with CFR 0.152.
 */
package com.amitshekhar.server;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import androidx.sqlite.db.SupportSQLiteDatabase;
import com.amitshekhar.model.Response;
import com.amitshekhar.model.RowDataRequest;
import com.amitshekhar.model.TableDataResponse;
import com.amitshekhar.model.UpdateRowResponse;
import com.amitshekhar.sqlite.DBFactory;
import com.amitshekhar.sqlite.InMemoryDebugSQLiteDB;
import com.amitshekhar.sqlite.SQLiteDB;
import com.amitshekhar.utils.DatabaseFileProvider;
import com.amitshekhar.utils.DatabaseHelper;
import com.amitshekhar.utils.PrefHelper;
import com.amitshekhar.utils.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestHandler {
    private final Context mContext;
    private final Gson mGson;
    private final AssetManager mAssets;
    private final DBFactory mDbFactory;
    private boolean isDbOpened;
    private SQLiteDB sqLiteDB;
    private HashMap<String, Pair<File, String>> mDatabaseFiles;
    private HashMap<String, Pair<File, String>> mCustomDatabaseFiles;
    private String mSelectedDatabase = null;
    private HashMap<String, SupportSQLiteDatabase> mRoomInMemoryDatabases = new HashMap();

    public RequestHandler(Context context, DBFactory dbFactory) {
        this.mContext = context;
        this.mAssets = context.getResources().getAssets();
        this.mGson = new GsonBuilder().serializeNulls().create();
        this.mDbFactory = dbFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Socket socket) throws IOException {
        BufferedReader reader = null;
        PrintStream output = null;
        try {
            byte[] bytes;
            String line;
            String route = null;
            reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while (!TextUtils.isEmpty((CharSequence)(line = reader.readLine()))) {
                if (!line.startsWith("GET /")) continue;
                int start = line.indexOf(47) + 1;
                int end = line.indexOf(32, start);
                route = line.substring(start, end);
                break;
            }
            output = new PrintStream(socket.getOutputStream());
            if (route == null || route.isEmpty()) {
                route = "index.html";
            }
            if (route.startsWith("getDbList")) {
                String response = this.getDBListResponse();
                bytes = response.getBytes();
            } else if (route.startsWith("getAllDataFromTheTable")) {
                String response = this.getAllDataFromTheTableResponse(route);
                bytes = response.getBytes();
            } else if (route.startsWith("getTableList")) {
                String response = this.getTableListResponse(route);
                bytes = response.getBytes();
            } else if (route.startsWith("addTableData")) {
                String response = this.addTableDataAndGetResponse(route);
                bytes = response.getBytes();
            } else if (route.startsWith("updateTableData")) {
                String response = this.updateTableDataAndGetResponse(route);
                bytes = response.getBytes();
            } else if (route.startsWith("deleteTableData")) {
                String response = this.deleteTableDataAndGetResponse(route);
                bytes = response.getBytes();
            } else if (route.startsWith("query")) {
                String response = this.executeQueryAndGetResponse(route);
                bytes = response.getBytes();
            } else if (route.startsWith("deleteDb")) {
                String response = this.deleteSelectedDatabaseAndGetResponse();
                bytes = response.getBytes();
            } else {
                bytes = route.startsWith("downloadDb") ? Utils.getDatabase(this.mSelectedDatabase, this.mDatabaseFiles) : Utils.loadContent(route, this.mAssets);
            }
            if (null == bytes) {
                this.writeServerError(output);
                return;
            }
            output.println("HTTP/1.0 200 OK");
            output.println("Content-Type: " + Utils.detectMimeType(route));
            if (route.startsWith("downloadDb")) {
                output.println("Content-Disposition: attachment; filename=" + this.mSelectedDatabase);
            } else {
                output.println("Content-Length: " + bytes.length);
            }
            output.println();
            output.write(bytes);
            output.flush();
        }
        finally {
            try {
                if (null != output) {
                    output.close();
                }
                if (null != reader) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setCustomDatabaseFiles(HashMap<String, Pair<File, String>> customDatabaseFiles) {
        this.mCustomDatabaseFiles = customDatabaseFiles;
    }

    public void setInMemoryRoomDatabases(HashMap<String, SupportSQLiteDatabase> databases) {
        this.mRoomInMemoryDatabases = databases;
    }

    private void writeServerError(PrintStream output) {
        output.println("HTTP/1.0 500 Internal Server Error");
        output.flush();
    }

    private void openDatabase(String database) {
        this.closeDatabase();
        if (this.mRoomInMemoryDatabases.containsKey(database)) {
            this.sqLiteDB = new InMemoryDebugSQLiteDB(this.mRoomInMemoryDatabases.get(database));
        } else {
            File databaseFile = (File)this.mDatabaseFiles.get((Object)database).first;
            String password = (String)this.mDatabaseFiles.get((Object)database).second;
            this.sqLiteDB = this.mDbFactory.create(this.mContext, databaseFile.getAbsolutePath(), password);
        }
        this.isDbOpened = true;
    }

    private void closeDatabase() {
        if (this.sqLiteDB != null && this.sqLiteDB.isOpen()) {
            this.sqLiteDB.close();
        }
        this.sqLiteDB = null;
        this.isDbOpened = false;
    }

    private String getDBListResponse() {
        String[] dbEntry;
        this.mDatabaseFiles = DatabaseFileProvider.getDatabaseFiles(this.mContext);
        if (this.mCustomDatabaseFiles != null) {
            this.mDatabaseFiles.putAll(this.mCustomDatabaseFiles);
        }
        Response response = new Response();
        if (this.mDatabaseFiles != null) {
            for (Map.Entry<String, Pair<File, String>> entry : this.mDatabaseFiles.entrySet()) {
                dbEntry = new String[]{entry.getKey(), !((String)entry.getValue().second).equals("") ? "true" : "false", "true"};
                response.rows.add(dbEntry);
            }
        }
        if (this.mRoomInMemoryDatabases != null) {
            for (Map.Entry<String, Pair<File, String>> entry : this.mRoomInMemoryDatabases.entrySet()) {
                dbEntry = new String[]{entry.getKey(), "false", "false"};
                response.rows.add(dbEntry);
            }
        }
        response.rows.add(new String[]{"APP_SHARED_PREFERENCES", "false", "false"});
        response.isSuccessful = true;
        return this.mGson.toJson((Object)response);
    }

    private String getAllDataFromTheTableResponse(String route) {
        TableDataResponse response;
        String tableName = null;
        if (route.contains("?tableName=")) {
            tableName = route.substring(route.indexOf("=") + 1, route.length());
        }
        if (this.isDbOpened) {
            String sql = "SELECT * FROM " + tableName;
            response = DatabaseHelper.getTableData(this.sqLiteDB, sql, tableName);
        } else {
            response = PrefHelper.getAllPrefData(this.mContext, tableName);
        }
        return this.mGson.toJson((Object)response);
    }

    private String executeQueryAndGetResponse(String route) {
        String data;
        block10: {
            String query = null;
            data = null;
            try {
                if (route.contains("?query=")) {
                    query = route.substring(route.indexOf("=") + 1, route.length());
                }
                try {
                    query = URLDecoder.decode(query, "UTF-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (query == null) break block10;
                String[] statements = query.split(";");
                for (int i = 0; i < statements.length; ++i) {
                    TableDataResponse response;
                    String aQuery = statements[i].trim();
                    String first = aQuery.split(" ")[0].toLowerCase();
                    if (first.equals("select") || first.equals("pragma")) {
                        response = DatabaseHelper.getTableData(this.sqLiteDB, aQuery, null);
                        data = this.mGson.toJson((Object)response);
                        if (response.isSuccessful) continue;
                    } else {
                        response = DatabaseHelper.exec(this.sqLiteDB, aQuery);
                        data = this.mGson.toJson((Object)response);
                        if (response.isSuccessful) {
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (data == null) {
            Response response = new Response();
            response.isSuccessful = false;
            data = this.mGson.toJson((Object)response);
        }
        return data;
    }

    private String getTableListResponse(String route) {
        Response response;
        String database = null;
        if (route.contains("?database=")) {
            database = route.substring(route.indexOf("=") + 1, route.length());
        }
        if ("APP_SHARED_PREFERENCES".equals(database)) {
            response = PrefHelper.getAllPrefTableName(this.mContext);
            this.closeDatabase();
            this.mSelectedDatabase = "APP_SHARED_PREFERENCES";
        } else {
            this.openDatabase(database);
            response = DatabaseHelper.getAllTableName(this.sqLiteDB);
            this.mSelectedDatabase = database;
        }
        return this.mGson.toJson((Object)response);
    }

    private String addTableDataAndGetResponse(String route) {
        try {
            Uri uri = Uri.parse((String)URLDecoder.decode(route, "UTF-8"));
            String tableName = uri.getQueryParameter("tableName");
            String updatedData = uri.getQueryParameter("addData");
            List rowDataRequests = (List)this.mGson.fromJson(updatedData, new TypeToken<List<RowDataRequest>>(){}.getType());
            UpdateRowResponse response = "APP_SHARED_PREFERENCES".equals(this.mSelectedDatabase) ? PrefHelper.addOrUpdateRow(this.mContext, tableName, rowDataRequests) : DatabaseHelper.addRow(this.sqLiteDB, tableName, rowDataRequests);
            return this.mGson.toJson((Object)response);
        }
        catch (Exception e) {
            e.printStackTrace();
            UpdateRowResponse response = new UpdateRowResponse();
            response.isSuccessful = false;
            return this.mGson.toJson((Object)response);
        }
    }

    private String updateTableDataAndGetResponse(String route) {
        try {
            Uri uri = Uri.parse((String)URLDecoder.decode(route, "UTF-8"));
            String tableName = uri.getQueryParameter("tableName");
            String updatedData = uri.getQueryParameter("updatedData");
            List rowDataRequests = (List)this.mGson.fromJson(updatedData, new TypeToken<List<RowDataRequest>>(){}.getType());
            UpdateRowResponse response = "APP_SHARED_PREFERENCES".equals(this.mSelectedDatabase) ? PrefHelper.addOrUpdateRow(this.mContext, tableName, rowDataRequests) : DatabaseHelper.updateRow(this.sqLiteDB, tableName, rowDataRequests);
            return this.mGson.toJson((Object)response);
        }
        catch (Exception e) {
            e.printStackTrace();
            UpdateRowResponse response = new UpdateRowResponse();
            response.isSuccessful = false;
            return this.mGson.toJson((Object)response);
        }
    }

    private String deleteTableDataAndGetResponse(String route) {
        try {
            Uri uri = Uri.parse((String)URLDecoder.decode(route, "UTF-8"));
            String tableName = uri.getQueryParameter("tableName");
            String updatedData = uri.getQueryParameter("deleteData");
            List rowDataRequests = (List)this.mGson.fromJson(updatedData, new TypeToken<List<RowDataRequest>>(){}.getType());
            UpdateRowResponse response = "APP_SHARED_PREFERENCES".equals(this.mSelectedDatabase) ? PrefHelper.deleteRow(this.mContext, tableName, rowDataRequests) : DatabaseHelper.deleteRow(this.sqLiteDB, tableName, rowDataRequests);
            return this.mGson.toJson((Object)response);
        }
        catch (Exception e) {
            e.printStackTrace();
            UpdateRowResponse response = new UpdateRowResponse();
            response.isSuccessful = false;
            return this.mGson.toJson((Object)response);
        }
    }

    private String deleteSelectedDatabaseAndGetResponse() {
        UpdateRowResponse response = new UpdateRowResponse();
        if (this.mSelectedDatabase == null || !this.mDatabaseFiles.containsKey(this.mSelectedDatabase)) {
            response.isSuccessful = false;
            return this.mGson.toJson((Object)response);
        }
        try {
            this.closeDatabase();
            File dbFile = (File)this.mDatabaseFiles.get((Object)this.mSelectedDatabase).first;
            response.isSuccessful = dbFile.delete();
            if (response.isSuccessful) {
                this.mDatabaseFiles.remove(this.mSelectedDatabase);
                this.mCustomDatabaseFiles.remove(this.mSelectedDatabase);
            }
            return this.mGson.toJson((Object)response);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.isSuccessful = false;
            return this.mGson.toJson((Object)response);
        }
    }
}

