/*
 * Decompiled with CFR 0.152.
 */
package com.amitshekhar.utils;

import android.content.res.AssetManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class Utils {
    private static final String TAG = "Utils";

    private Utils() {
    }

    public static String detectMimeType(String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            return null;
        }
        if (fileName.endsWith(".html")) {
            return "text/html";
        }
        if (fileName.endsWith(".js")) {
            return "application/javascript";
        }
        if (fileName.endsWith(".css")) {
            return "text/css";
        }
        return "application/octet-stream";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadContent(String fileName, AssetManager assetManager) throws IOException {
        InputStream input = null;
        try {
            int size;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            input = assetManager.open(fileName);
            byte[] buffer = new byte[1024];
            while (-1 != (size = input.read(buffer))) {
                output.write(buffer, 0, size);
            }
            output.flush();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (FileNotFoundException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (null != input) {
                    input.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] getDatabase(String selectedDatabase, HashMap<String, Pair<File, String>> databaseFiles) {
        if (TextUtils.isEmpty((CharSequence)selectedDatabase) || !databaseFiles.containsKey(selectedDatabase)) {
            return null;
        }
        byte[] byteArray = new byte[]{};
        try {
            File file = (File)databaseFiles.get((Object)selectedDatabase).first;
            byteArray = null;
            try {
                int bytesRead;
                FileInputStream inputStream = new FileInputStream(file);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] b = new byte[(int)file.length()];
                while ((bytesRead = ((InputStream)inputStream).read(b)) != -1) {
                    bos.write(b, 0, bytesRead);
                }
                byteArray = bos.toByteArray();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"getDatabase: ", (Throwable)e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return byteArray;
    }
}

