/*
 * Decompiled with CFR 0.152.
 */
package com.amitshekhar.utils;

import android.content.Context;
import android.util.Pair;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;

public class DatabaseFileProvider {
    private static final String DB_PASSWORD_RESOURCE = "DB_PASSWORD_{0}";

    private DatabaseFileProvider() {
    }

    public static HashMap<String, Pair<File, String>> getDatabaseFiles(Context context) {
        HashMap<String, Pair<File, String>> databaseFiles = new HashMap<String, Pair<File, String>>();
        try {
            for (String databaseName : context.databaseList()) {
                String password = DatabaseFileProvider.getDbPasswordFromStringResources(context, databaseName);
                databaseFiles.put(databaseName, (Pair<File, String>)new Pair((Object)context.getDatabasePath(databaseName), (Object)password));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return databaseFiles;
    }

    private static String getDbPasswordFromStringResources(Context context, String name) {
        String nameWithoutExt = name;
        if (nameWithoutExt.endsWith(".db")) {
            nameWithoutExt = nameWithoutExt.substring(0, nameWithoutExt.lastIndexOf(46));
        }
        String resourceName = MessageFormat.format(DB_PASSWORD_RESOURCE, nameWithoutExt.toUpperCase());
        String password = "";
        int resourceId = context.getResources().getIdentifier(resourceName, "string", context.getPackageName());
        if (resourceId != 0) {
            password = context.getString(resourceId);
        }
        return password;
    }
}

