/*
 * Decompiled with CFR 0.152.
 */
package am.leon;

import am.leon.Media;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.util.DisplayMetrics;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.view.ContextThemeWrapper;
import java.util.Locale;

class Utils {
    private static final String YouTube_Thumb = "https://img.youtube.com/vi/";

    Utils() {
    }

    static void youtubePlay(Context context, String id) {
        Intent appIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)("vnd.youtube:" + id)));
        Intent webIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)("http://www.youtube.com/watch?v=" + id)));
        try {
            context.startActivity(appIntent);
        }
        catch (ActivityNotFoundException ex) {
            context.startActivity(webIntent);
        }
    }

    static AppCompatActivity unwrap(Context context) {
        while (context instanceof ContextThemeWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        return (AppCompatActivity)context;
    }

    private static boolean isRTL(Locale locale) {
        byte directionality = Character.getDirectionality(locale.getDisplayName().charAt(0));
        return directionality == 1 || directionality == 2;
    }

    static int convertDpToPixel(Context context, float dp) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return (int)(dp * ((float)metrics.densityDpi / 160.0f));
    }

    static String getStringPath(String path) {
        if (!path.contains("http") && !path.contains("file")) {
            return "file://" + path;
        }
        return path;
    }

    static String getMediaPath(Media media) {
        if (media.getType().equals("video")) {
            return YouTube_Thumb.concat(media.getPath().substring(media.getPath().indexOf("=") + 1)).concat("/0.jpg");
        }
        return Utils.getStringPath(media.getPath());
    }
}

