/*
 * Decompiled with CFR 0.152.
 */
package rm.com.clocks;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rm.com.clocks.Clock;
import rm.com.clocks.ConstantsKt;
import rm.com.clocks.GraphicsKt;
import rm.com.clocks.MathsKt;
import rm.com.clocks.Stroke;
import rm.com.clocks.StrokeKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 `2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002_`B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010P\u001a\u00020QH\u0016J\u0018\u0010R\u001a\u00020Q2\u0006\u0010-\u001a\u00020\n2\u0006\u00109\u001a\u00020\nH\u0016J\u0012\u0010S\u001a\u00020Q2\b\u0010T\u001a\u0004\u0018\u00010UH\u0016J\b\u0010V\u001a\u00020\nH\u0016J\b\u0010W\u001a\u00020'H\u0016J\u0010\u0010X\u001a\u00020Q2\u0006\u0010Y\u001a\u00020\nH\u0016J\u0012\u0010Z\u001a\u00020Q2\b\u0010[\u001a\u0004\u0018\u00010\\H\u0016J\b\u0010]\u001a\u00020QH\u0016J\b\u0010^\u001a\u00020QH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R(\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\f\u001a\u0004\u0018\u00010\u0012@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000fR$\u0010\"\u001a\u00020!2\u0006\u0010\f\u001a\u00020!@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R$\u0010(\u001a\u00020'2\u0006\u0010\f\u001a\u00020'@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R$\u0010-\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010\u001a\"\u0004\b/\u0010\u001cR\u000e\u00100\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u000fR\u0016\u00103\u001a\n 5*\u0004\u0018\u00010404X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u000f\"\u0004\b8\u0010\u0011R$\u00109\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010\u001a\"\u0004\b;\u0010\u001cR\u000e\u0010<\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010=\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u000fR$\u0010?\u001a\u00020!2\u0006\u0010\f\u001a\u00020!@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010$\"\u0004\bA\u0010&R\u000e\u0010B\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010C\u001a\n 5*\u0004\u0018\u00010404X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010E\u001a\u00020D2\u0006\u0010\f\u001a\u00020D@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR$\u0010K\u001a\u00020J2\u0006\u0010\f\u001a\u00020J@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010O\u00a8\u0006a"}, d2={"Lrm/com/clocks/ClockDrawable;", "Landroid/graphics/drawable/Drawable;", "Lrm/com/clocks/Clock;", "Landroid/graphics/drawable/Animatable;", "ctx", "Landroid/content/Context;", "(Landroid/content/Context;)V", "_absMinutes", "", "_hours", "", "_minutes", "value", "absMinutes", "getAbsMinutes", "()F", "setAbsMinutes", "(F)V", "Landroid/animation/Animator$AnimatorListener;", "animationListener", "getAnimationListener", "()Landroid/animation/Animator$AnimatorListener;", "setAnimationListener", "(Landroid/animation/Animator$AnimatorListener;)V", "clockColor", "getClockColor", "()I", "setClockColor", "(I)V", "frame", "Landroid/graphics/Paint;", "frameRadius", "getFrameRadius", "Lrm/com/clocks/Stroke;", "frameWidth", "getFrameWidth", "()Lrm/com/clocks/Stroke;", "setFrameWidth", "(Lrm/com/clocks/Stroke;)V", "", "hasFrame", "getHasFrame", "()Z", "setHasFrame", "(Z)V", "hours", "getHours", "setHours", "hoursAngle", "hoursRadius", "getHoursRadius", "indeterminateAnimator", "Landroid/animation/ValueAnimator;", "kotlin.jvm.PlatformType", "indeterminateSpeed", "getIndeterminateSpeed", "setIndeterminateSpeed", "minutes", "getMinutes", "setMinutes", "minutesAngle", "minutesRadius", "getMinutesRadius", "pointerWidth", "getPointerWidth", "setPointerWidth", "pointers", "timeSetAnimator", "", "timeSetDuration", "getTimeSetDuration", "()J", "setTimeSetDuration", "(J)V", "Landroid/animation/TimeInterpolator;", "timeSetInterpolator", "getTimeSetInterpolator", "()Landroid/animation/TimeInterpolator;", "setTimeSetInterpolator", "(Landroid/animation/TimeInterpolator;)V", "animateIndeterminate", "", "animateToTime", "draw", "canvas", "Landroid/graphics/Canvas;", "getOpacity", "isRunning", "setAlpha", "alpha", "setColorFilter", "filter", "Landroid/graphics/ColorFilter;", "start", "stop", "Builder", "Companion", "lib_release"})
public final class ClockDrawable
extends Drawable
implements Clock,
Animatable {
    private int _minutes;
    private int _hours;
    private int clockColor;
    private boolean hasFrame;
    @NotNull
    private Stroke frameWidth;
    @NotNull
    private Stroke pointerWidth;
    private float indeterminateSpeed;
    @NotNull
    private TimeInterpolator timeSetInterpolator;
    private long timeSetDuration;
    @Nullable
    private Animator.AnimatorListener animationListener;
    private final Paint frame;
    private final Paint pointers;
    private float minutesAngle;
    private float hoursAngle;
    private float _absMinutes;
    private final ValueAnimator indeterminateAnimator;
    private final ValueAnimator timeSetAnimator;
    private final Context ctx;
    public static final Companion Companion = new Companion(null);

    @Override
    public int getMinutes() {
        return this._minutes;
    }

    @Override
    public void setMinutes(int value) {
        this._minutes = MathsKt.cycledClamp(value, ConstantsKt.COUNT_MINUTES);
        this.minutesAngle = MathsKt.minutesDegOf(this._minutes);
        this.invalidateSelf();
    }

    @Override
    public int getHours() {
        return this._hours;
    }

    @Override
    public void setHours(int value) {
        this._hours = MathsKt.cycledClamp(value, ConstantsKt.COUNT_HOURS);
        this.hoursAngle = MathsKt.hoursDegOf(this._hours, this._minutes);
        this.invalidateSelf();
    }

    @Override
    public int getClockColor() {
        return this.clockColor;
    }

    @Override
    public void setClockColor(int value) {
        this.clockColor = value;
        this.frame.setColor(this.clockColor);
        this.pointers.setColor(this.clockColor);
        this.invalidateSelf();
    }

    @Override
    public boolean getHasFrame() {
        return this.hasFrame;
    }

    @Override
    public void setHasFrame(boolean value) {
        this.hasFrame = value;
        this.invalidateSelf();
    }

    @Override
    @NotNull
    public Stroke getFrameWidth() {
        return this.frameWidth;
    }

    @Override
    public void setFrameWidth(@NotNull Stroke value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.frameWidth = value;
        this.frame.setStrokeWidth(StrokeKt.toDip(this.frameWidth, this.ctx));
        this.invalidateSelf();
    }

    @Override
    @NotNull
    public Stroke getPointerWidth() {
        return this.pointerWidth;
    }

    @Override
    public void setPointerWidth(@NotNull Stroke value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.pointerWidth = value;
        this.pointers.setStrokeWidth(StrokeKt.toDip(this.pointerWidth, this.ctx));
        this.invalidateSelf();
    }

    @Override
    public float getIndeterminateSpeed() {
        return this.indeterminateSpeed;
    }

    @Override
    public void setIndeterminateSpeed(float f) {
        this.indeterminateSpeed = f;
    }

    @Override
    @NotNull
    public TimeInterpolator getTimeSetInterpolator() {
        return this.timeSetInterpolator;
    }

    @Override
    public void setTimeSetInterpolator(@NotNull TimeInterpolator value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.timeSetInterpolator = value;
        this.timeSetAnimator.setInterpolator(this.timeSetInterpolator);
    }

    @Override
    public long getTimeSetDuration() {
        return this.timeSetDuration;
    }

    @Override
    public void setTimeSetDuration(long value) {
        this.timeSetDuration = value;
        this.timeSetAnimator.setDuration(this.timeSetDuration);
    }

    @Override
    @Nullable
    public Animator.AnimatorListener getAnimationListener() {
        return this.animationListener;
    }

    @Override
    public void setAnimationListener(@Nullable Animator.AnimatorListener value) {
        block0: {
            Animator.AnimatorListener animatorListener = this.animationListener = value;
            if (animatorListener == null) break block0;
            Animator.AnimatorListener animatorListener2 = animatorListener;
            Animator.AnimatorListener it = animatorListener2;
            this.timeSetAnimator.removeAllListeners();
            this.timeSetAnimator.addListener(it);
        }
    }

    private final float getFrameRadius() {
        return (float)(GraphicsKt.getWidth(this) / 2) - this.frame.getStrokeWidth();
    }

    private final float getMinutesRadius() {
        return this.getFrameRadius() * ConstantsKt.POINTER_FACTOR_MINUTES;
    }

    private final float getHoursRadius() {
        return this.getFrameRadius() * ConstantsKt.POINTER_FACTOR_HOURS;
    }

    private final float getAbsMinutes() {
        return this._absMinutes;
    }

    private final void setAbsMinutes(float value) {
        this._absMinutes = value;
        this.setMinutes((int)(this._absMinutes % (float)ConstantsKt.COUNT_MINUTES));
        this.setHours(MathsKt.floorDiv((int)this._absMinutes, ConstantsKt.COUNT_MINUTES));
    }

    public void draw(@Nullable Canvas canvas) {
        if (canvas == null) {
            return;
        }
        if (this.getHasFrame()) {
            canvas.drawCircle(GraphicsKt.getCenterX(this), GraphicsKt.getCenterY(this), this.getFrameRadius(), this.frame);
        }
        GraphicsKt.drawLineWithAngle(canvas, GraphicsKt.getCenterX(this), GraphicsKt.getCenterY(this), this.minutesAngle, this.getMinutesRadius(), this.pointers);
        GraphicsKt.drawLineWithAngle(canvas, GraphicsKt.getCenterX(this), GraphicsKt.getCenterY(this), this.hoursAngle, this.getHoursRadius(), this.pointers);
    }

    public void setAlpha(int alpha) {
        this.frame.setAlpha(alpha);
        this.pointers.setAlpha(alpha);
    }

    public int getOpacity() {
        return this.pointers.getAlpha();
    }

    public void setColorFilter(@Nullable ColorFilter filter) {
        this.frame.setColorFilter(filter);
        this.pointers.setColorFilter(filter);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void animateToTime(int hours, int minutes) {
        void $receiver;
        if (this.isRunning()) {
            this.stop();
        }
        this._hours = MathsKt.cycledClamp(hours, ConstantsKt.COUNT_HOURS);
        this._minutes = MathsKt.cycledClamp(minutes, ConstantsKt.COUNT_MINUTES);
        this._absMinutes = ConstantsKt.COUNT_MINUTES * this._hours + this._minutes;
        float beforeHrs = this.hoursAngle;
        float beforeMins = this.minutesAngle;
        float afterHrs = MathsKt.hoursDegOf(this._hours, this._minutes);
        float afterMins = MathsKt.minutesDegOf(this._minutes);
        float diffHrs = afterHrs - this.hoursAngle;
        float diffMins = afterMins - this.minutesAngle;
        ValueAnimator valueAnimator = this.timeSetAnimator;
        ValueAnimator valueAnimator2 = valueAnimator;
        $receiver.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, beforeHrs, diffHrs, beforeMins, diffMins){
            final /* synthetic */ ClockDrawable this$0;
            final /* synthetic */ float $beforeHrs$inlined;
            final /* synthetic */ float $diffHrs$inlined;
            final /* synthetic */ float $beforeMins$inlined;
            final /* synthetic */ float $diffMins$inlined;

            public final void onAnimationUpdate(ValueAnimator it) {
                ClockDrawable.access$setHoursAngle$p(this.this$0, this.$beforeHrs$inlined + this.$diffHrs$inlined * it.getAnimatedFraction());
                ClockDrawable.access$setMinutesAngle$p(this.this$0, this.$beforeMins$inlined + this.$diffMins$inlined * it.getAnimatedFraction());
                this.this$0.invalidateSelf();
            }
            {
                this.this$0 = clockDrawable;
                this.$beforeHrs$inlined = f;
                this.$diffHrs$inlined = f2;
                this.$beforeMins$inlined = f3;
                this.$diffMins$inlined = f4;
            }
        });
        $receiver.start();
    }

    @Override
    public void animateIndeterminate() {
        this.start();
    }

    public boolean isRunning() {
        return this.indeterminateAnimator.isRunning();
    }

    public void start() {
        this.indeterminateAnimator.start();
    }

    public void stop() {
        this.indeterminateAnimator.cancel();
    }

    public ClockDrawable(@NotNull Context ctx) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        this.ctx = ctx;
        this.clockColor = -1;
        this.hasFrame = true;
        this.frameWidth = ConstantsKt.getDEFAULT_STROKE();
        this.pointerWidth = ConstantsKt.getDEFAULT_STROKE();
        this.indeterminateSpeed = ConstantsKt.DEFAULT_SPEED;
        this.timeSetInterpolator = (TimeInterpolator)ConstantsKt.getDEFAULT_INTERPOLATOR();
        this.timeSetDuration = ConstantsKt.DEFAULT_DURATION;
        Paint paint2 = GraphicsKt.linePaintOf$default(0, 1, null);
        ClockDrawable clockDrawable = this;
        Paint $receiver = paint2;
        $receiver.setStrokeWidth(StrokeKt.toDip(this.getFrameWidth(), this.ctx));
        $receiver.setColor(this.getClockColor());
        clockDrawable.frame = paint = paint2;
        paint2 = GraphicsKt.linePaintOf$default(0, 1, null);
        clockDrawable = this;
        $receiver = paint2;
        $receiver.setStrokeWidth(StrokeKt.toDip(this.getPointerWidth(), this.ctx));
        $receiver.setColor(this.getClockColor());
        clockDrawable.pointers = paint = paint2;
        this.minutesAngle = MathsKt.minutesDegOf$default(0, 1, null);
        this.hoursAngle = MathsKt.hoursDegOf$default(0, 0, 3, null);
        clockDrawable = this;
        paint2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        $receiver = (ValueAnimator)paint2;
        $receiver.setRepeatMode(1);
        $receiver.setRepeatCount(-1);
        $receiver.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ ClockDrawable this$0;

            public final void onAnimationUpdate(ValueAnimator it) {
                ClockDrawable clockDrawable = this.this$0;
                ClockDrawable.access$setAbsMinutes$p(clockDrawable, ClockDrawable.access$getAbsMinutes$p(clockDrawable) + this.this$0.getIndeterminateSpeed());
            }
            {
                this.this$0 = clockDrawable;
            }
        });
        paint = (ValueAnimator)paint2;
        clockDrawable.indeterminateAnimator = paint;
        clockDrawable = this;
        paint2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        $receiver = (ValueAnimator)paint2;
        $receiver.setInterpolator(this.getTimeSetInterpolator());
        $receiver.setDuration(this.getTimeSetDuration());
        paint = (ValueAnimator)paint2;
        clockDrawable.timeSetAnimator = paint;
    }

    public static final /* synthetic */ float access$getHoursAngle$p(ClockDrawable $this) {
        return $this.hoursAngle;
    }

    public static final /* synthetic */ void access$setHoursAngle$p(ClockDrawable $this, float f) {
        $this.hoursAngle = f;
    }

    public static final /* synthetic */ float access$getMinutesAngle$p(ClockDrawable $this) {
        return $this.minutesAngle;
    }

    public static final /* synthetic */ void access$setMinutesAngle$p(ClockDrawable $this, float f) {
        $this.minutesAngle = f;
    }

    public static final /* synthetic */ float access$getAbsMinutes$p(ClockDrawable $this) {
        return $this.getAbsMinutes();
    }

    public static final /* synthetic */ void access$setAbsMinutes$p(ClockDrawable $this, float f) {
        $this.setAbsMinutes(f);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        return Companion.builder(ctx);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000eJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\fJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\fJ\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lrm/com/clocks/ClockDrawable$Builder;", "", "ctx", "Landroid/content/Context;", "(Landroid/content/Context;)V", "clockDrawable", "Lrm/com/clocks/ClockDrawable;", "color", "", "duration", "", "frameWidth", "Lrm/com/clocks/Stroke;", "hasFrame", "", "hours", "interpolator", "Landroid/animation/TimeInterpolator;", "listener", "Landroid/animation/Animator$AnimatorListener;", "minutes", "pointerWidth", "speed", "", "build", "into", "view", "Landroid/widget/ImageView;", "withColor", "withDuration", "withFrame", "with", "withFrameWidth", "width", "withInterpolator", "withListener", "withPointerWidth", "withSpeed", "lib_release"})
    public static final class Builder {
        private int hours;
        private int minutes;
        private int color;
        private float speed;
        private boolean hasFrame;
        private Stroke frameWidth;
        private Stroke pointerWidth;
        private long duration;
        private TimeInterpolator interpolator;
        private Animator.AnimatorListener listener;
        private ClockDrawable clockDrawable;
        private final Context ctx;

        @NotNull
        public final Builder hours(int hours) {
            Builder builder = this;
            Builder $receiver = builder;
            $receiver.hours = hours;
            return builder;
        }

        @NotNull
        public final Builder minutes(int minutes) {
            Builder builder = this;
            Builder $receiver = builder;
            $receiver.minutes = minutes;
            return builder;
        }

        @NotNull
        public final Builder withColor(int color) {
            Builder builder = this;
            Builder $receiver = builder;
            $receiver.color = color;
            return builder;
        }

        @NotNull
        public final Builder withSpeed(float speed) {
            Builder builder = this;
            Builder $receiver = builder;
            $receiver.speed = speed;
            return builder;
        }

        @NotNull
        public final Builder withFrame(boolean with) {
            Builder builder = this;
            Builder $receiver = builder;
            $receiver.hasFrame = with;
            return builder;
        }

        @NotNull
        public final Builder withFrameWidth(@NotNull Stroke width) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)width), (String)"width");
            Builder builder = this;
            Builder $receiver = builder;
            $receiver.frameWidth = width;
            return builder;
        }

        @NotNull
        public final Builder withPointerWidth(@NotNull Stroke width) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)width), (String)"width");
            Builder builder = this;
            Builder $receiver = builder;
            $receiver.pointerWidth = width;
            return builder;
        }

        @NotNull
        public final Builder withDuration(long duration) {
            Builder builder = this;
            Builder builder2 = builder;
            $receiver.duration = duration;
            return builder;
        }

        @NotNull
        public final Builder withInterpolator(@NotNull TimeInterpolator interpolator) {
            Intrinsics.checkParameterIsNotNull((Object)interpolator, (String)"interpolator");
            Builder builder = this;
            Builder $receiver = builder;
            $receiver.interpolator = interpolator;
            return builder;
        }

        @NotNull
        public final Builder withListener(@NotNull Animator.AnimatorListener listener) {
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            Builder builder = this;
            Builder $receiver = builder;
            $receiver.listener = listener;
            return builder;
        }

        @NotNull
        public final ClockDrawable into(@NotNull ImageView view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            ClockDrawable clockDrawable = this.build();
            ClockDrawable $receiver = clockDrawable;
            view.setImageDrawable((Drawable)$receiver);
            return clockDrawable;
        }

        @NotNull
        public final ClockDrawable build() {
            ClockDrawable clockDrawable = this.clockDrawable = new ClockDrawable(this.ctx);
            if (clockDrawable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clockDrawable");
            }
            clockDrawable.setHours(this.hours);
            ClockDrawable clockDrawable2 = this.clockDrawable;
            if (clockDrawable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clockDrawable");
            }
            clockDrawable2.setMinutes(this.minutes);
            ClockDrawable clockDrawable3 = this.clockDrawable;
            if (clockDrawable3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clockDrawable");
            }
            clockDrawable3.setClockColor(this.color);
            ClockDrawable clockDrawable4 = this.clockDrawable;
            if (clockDrawable4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clockDrawable");
            }
            clockDrawable4.setIndeterminateSpeed(this.speed);
            ClockDrawable clockDrawable5 = this.clockDrawable;
            if (clockDrawable5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clockDrawable");
            }
            clockDrawable5.setHasFrame(this.hasFrame);
            ClockDrawable clockDrawable6 = this.clockDrawable;
            if (clockDrawable6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clockDrawable");
            }
            clockDrawable6.setFrameWidth(this.frameWidth);
            ClockDrawable clockDrawable7 = this.clockDrawable;
            if (clockDrawable7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clockDrawable");
            }
            clockDrawable7.setPointerWidth(this.pointerWidth);
            ClockDrawable clockDrawable8 = this.clockDrawable;
            if (clockDrawable8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clockDrawable");
            }
            clockDrawable8.setTimeSetDuration(this.duration);
            ClockDrawable clockDrawable9 = this.clockDrawable;
            if (clockDrawable9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clockDrawable");
            }
            clockDrawable9.setTimeSetInterpolator(this.interpolator);
            ClockDrawable clockDrawable10 = this.clockDrawable;
            if (clockDrawable10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clockDrawable");
            }
            clockDrawable10.setAnimationListener(this.listener);
            ClockDrawable clockDrawable11 = this.clockDrawable;
            if (clockDrawable11 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clockDrawable");
            }
            return clockDrawable11;
        }

        public Builder(@NotNull Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            this.ctx = ctx;
            this.color = -1;
            this.speed = ConstantsKt.DEFAULT_SPEED;
            this.hasFrame = true;
            this.frameWidth = ConstantsKt.getDEFAULT_STROKE();
            this.pointerWidth = ConstantsKt.getDEFAULT_STROKE();
            this.duration = ConstantsKt.DEFAULT_DURATION;
            this.interpolator = (TimeInterpolator)ConstantsKt.getDEFAULT_INTERPOLATOR();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lrm/com/clocks/ClockDrawable$Companion;", "", "()V", "builder", "Lrm/com/clocks/ClockDrawable$Builder;", "ctx", "Landroid/content/Context;", "lib_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Builder builder(@NotNull Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            return new Builder(ctx);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

