/*
 * Decompiled with CFR 0.152.
 */
package com.alorma.timeline.painter.line;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.alorma.timeline.AttributesUtils;
import com.alorma.timeline.R;
import com.alorma.timeline.painter.Painter;
import com.alorma.timeline.painter.line.DashedLinePainter;
import com.alorma.timeline.painter.line.LineStylePainter;
import com.alorma.timeline.painter.line.LinearLinePainter;
import com.alorma.timeline.property.LineColor;
import com.alorma.timeline.property.LineStyle;
import com.alorma.timeline.property.LineWidth;
import com.alorma.timeline.property.Property;
import com.alorma.timeline.property.TimelinePosition;
import com.alorma.timeline.property.TimelinePositionOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u000bH\u0002J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0002J\u001c\u0010*\u001a\u00020\u001b\"\u0004\b\u0000\u0010+2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H+0,H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/alorma/timeline/painter/line/LinePainter;", "Lcom/alorma/timeline/painter/Painter;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "currentPainter", "Lcom/alorma/timeline/painter/line/LineStylePainter;", "dashedPainter", "horizontalPosition", "Lcom/alorma/timeline/property/TimelinePositionOption;", "lineColor", "", "lineWidth", "", "linearPainter", "paint", "Landroid/graphics/Paint;", "getPaint", "()Landroid/graphics/Paint;", "setPaint", "(Landroid/graphics/Paint;)V", "validHorizontalPositions", "", "validVerticalPositions", "verticalPosition", "createPaint", "draw", "", "canvas", "Landroid/graphics/Canvas;", "rect", "Landroid/graphics/Rect;", "getLineStylePainter", "property", "Lcom/alorma/timeline/property/LineStyle;", "style", "initProperties", "typedArray", "Landroid/content/res/TypedArray;", "readLineColor", "readLineStyle", "readLineWidth", "updateProperty", "T", "Lcom/alorma/timeline/property/Property;", "Companion", "timeline_release"})
public final class LinePainter
implements Painter {
    private final LineStylePainter linearPainter;
    private final LineStylePainter dashedPainter;
    private LineStylePainter currentPainter;
    private float lineWidth;
    private int lineColor;
    @NotNull
    public Paint paint;
    private List<? extends TimelinePositionOption> validVerticalPositions;
    private List<? extends TimelinePositionOption> validHorizontalPositions;
    private TimelinePositionOption verticalPosition;
    private TimelinePositionOption horizontalPosition;
    public static final int STYLE_LINEAR = -1;
    public static final int STYLE_DASHED = 0;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Paint getPaint() {
        Paint paint = this.paint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paint");
        }
        return paint;
    }

    public final void setPaint(@NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"<set-?>");
        this.paint = paint;
    }

    private final Paint createPaint() {
        Paint paint;
        Paint $receiver = paint = new Paint();
        boolean bl = false;
        $receiver.setFlags(1);
        $receiver.setColor(this.lineColor);
        $receiver.setStrokeWidth(this.lineWidth);
        $receiver.setStyle(Paint.Style.STROKE);
        this.currentPainter.paintLineStyle($receiver);
        return paint;
    }

    @Override
    public void initProperties(@NotNull TypedArray typedArray) {
        Intrinsics.checkParameterIsNotNull((Object)typedArray, (String)"typedArray");
        this.readLineStyle(typedArray);
        this.readLineWidth(typedArray);
        this.readLineColor(typedArray);
        this.paint = this.createPaint();
    }

    private final void readLineStyle(TypedArray typedArray) {
        int style = typedArray.getInt(R.styleable.TimelineView_timeline_lineStyle, -1);
        this.currentPainter = this.getLineStylePainter(style);
    }

    private final void readLineWidth(TypedArray typedArray) {
        this.lineWidth = typedArray.getDimension(R.styleable.TimelineView_timeline_lineWidth, this.lineWidth);
    }

    private final void readLineColor(TypedArray typedArray) {
        this.lineColor = typedArray.getColor(R.styleable.TimelineView_timeline_lineColor, this.lineColor);
    }

    @Override
    public <T> void updateProperty(@NotNull Property<T> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        Property<T> property2 = property;
        if (property2 instanceof LineStyle) {
            this.currentPainter = this.getLineStylePainter((LineStyle)property);
        } else if (property2 instanceof LineColor) {
            this.lineColor = ((LineColor)property).getLineColor();
        } else if (property2 instanceof LineWidth) {
            this.lineWidth = ((LineWidth)property).getLineWidth();
        } else if (property2 instanceof TimelinePosition) {
            TimelinePositionOption timelinePositionOption;
            Object var10_9;
            LinePainter linePainter;
            block14: {
                Object v2;
                TimelinePositionOption timelinePositionOption2;
                TimelinePositionOption it;
                Iterable $receiver$iv;
                block13: {
                    Object v0;
                    Iterable iterable = (Iterable)((TimelinePosition)property).getValue();
                    linePainter = this;
                    for (Object element$iv : $receiver$iv) {
                        it = (TimelinePositionOption)element$iv;
                        boolean bl = false;
                        if (!this.validVerticalPositions.contains(it)) continue;
                        v0 = element$iv;
                        break block13;
                    }
                    v0 = var10_9 = null;
                }
                if ((timelinePositionOption2 = (TimelinePositionOption)var10_9) == null) {
                    timelinePositionOption2 = linePainter.verticalPosition = this.verticalPosition;
                }
                if (this.verticalPosition instanceof TimelinePositionOption.POSITION_CENTER) {
                    this.verticalPosition = TimelinePositionOption.POSITION_CENTER_VERTICAL.INSTANCE;
                }
                $receiver$iv = (Iterable)((TimelinePosition)property).getValue();
                linePainter = this;
                for (Object element$iv : $receiver$iv) {
                    it = (TimelinePositionOption)element$iv;
                    boolean bl = false;
                    if (!this.validHorizontalPositions.contains(it)) continue;
                    v2 = element$iv;
                    break block14;
                }
                v2 = var10_9 = null;
            }
            if ((timelinePositionOption = (TimelinePositionOption)var10_9) == null) {
                timelinePositionOption = linePainter.horizontalPosition = this.horizontalPosition;
            }
            if (this.horizontalPosition instanceof TimelinePositionOption.POSITION_CENTER) {
                this.horizontalPosition = TimelinePositionOption.POSITION_CENTER_HORIZONTAL.INSTANCE;
            }
        }
        this.paint = this.createPaint();
    }

    private final LineStylePainter getLineStylePainter(int style) {
        LineStyle lineStyle;
        switch (style) {
            case 0: {
                lineStyle = LineStyle.DASHED.INSTANCE;
                break;
            }
            default: {
                lineStyle = LineStyle.LINEAR.INSTANCE;
            }
        }
        LineStyle lineStyle2 = lineStyle;
        return this.getLineStylePainter(lineStyle2);
    }

    private final LineStylePainter getLineStylePainter(LineStyle property) {
        LineStylePainter lineStylePainter;
        LineStyle lineStyle = property;
        if (lineStyle instanceof LineStyle.LINEAR) {
            lineStylePainter = this.linearPainter;
        } else if (lineStyle instanceof LineStyle.DASHED) {
            lineStylePainter = this.dashedPainter;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return lineStylePainter;
    }

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        TimelinePositionOption timelinePositionOption = this.verticalPosition;
        Rect vRect = Intrinsics.areEqual((Object)timelinePositionOption, (Object)TimelinePositionOption.POSITION_TOP.INSTANCE) ? new Rect(rect.left, rect.top, rect.right, rect.centerY()) : (Intrinsics.areEqual((Object)timelinePositionOption, (Object)TimelinePositionOption.POSITION_BOTTOM.INSTANCE) ? new Rect(rect.left, rect.centerY(), rect.right, rect.bottom) : rect);
        TimelinePositionOption timelinePositionOption2 = this.horizontalPosition;
        Rect hRect = Intrinsics.areEqual((Object)timelinePositionOption2, (Object)TimelinePositionOption.POSITION_START.INSTANCE) ? new Rect(rect.left, vRect.top, rect.left, vRect.bottom) : (Intrinsics.areEqual((Object)timelinePositionOption2, (Object)TimelinePositionOption.POSITION_END.INSTANCE) ? new Rect(rect.right, vRect.top, rect.right, vRect.bottom) : rect);
        Rect useRect = new Rect(hRect.left, vRect.top, hRect.right, vRect.bottom);
        Paint paint = this.paint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paint");
        }
        this.currentPainter.draw(canvas, useRect, paint);
    }

    public LinePainter(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.linearPainter = new LinearLinePainter();
        this.dashedPainter = new DashedLinePainter();
        this.currentPainter = this.linearPainter;
        this.lineWidth = context.getResources().getDimensionPixelOffset(R.dimen.default_lineWidth);
        this.lineColor = AttributesUtils.INSTANCE.colorPrimary(context, -7829368);
        this.validVerticalPositions = CollectionsKt.listOf((Object[])new TimelinePositionOption[]{TimelinePositionOption.POSITION_TOP.INSTANCE, TimelinePositionOption.POSITION_CENTER.INSTANCE, TimelinePositionOption.POSITION_BOTTOM.INSTANCE});
        this.validHorizontalPositions = CollectionsKt.listOf((Object[])new TimelinePositionOption[]{TimelinePositionOption.POSITION_START.INSTANCE, TimelinePositionOption.POSITION_CENTER.INSTANCE, TimelinePositionOption.POSITION_END.INSTANCE});
        this.verticalPosition = TimelinePositionOption.POSITION_CENTER_VERTICAL.INSTANCE;
        this.horizontalPosition = TimelinePositionOption.POSITION_CENTER_HORIZONTAL.INSTANCE;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/alorma/timeline/painter/line/LinePainter$Companion;", "", "()V", "STYLE_DASHED", "", "STYLE_LINEAR", "timeline_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

