/*
 * Decompiled with CFR 0.152.
 */
package com.alorma.timeline;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.TypedValue;
import com.alorma.timeline.R;

class AttributesUtils {
    AttributesUtils() {
    }

    static int windowBackground(Context context, int defaultValue) {
        return AttributesUtils.getColor(context, 16842836, defaultValue);
    }

    public static int colorPrimary(Context context, int defaultValue) {
        if (Build.VERSION.SDK_INT >= 21) {
            return AttributesUtils.getColor(context, 16843827, defaultValue);
        }
        return AttributesUtils.getColor(context, R.attr.colorPrimary, defaultValue);
    }

    public static int colorAccent(Context context, int defaultValue) {
        if (Build.VERSION.SDK_INT >= 21) {
            return AttributesUtils.getColor(context, 16843829, defaultValue);
        }
        return AttributesUtils.getColor(context, R.attr.colorAccent, defaultValue);
    }

    private static int getColor(Context context, int id, int defaultValue) {
        TypedValue value = new TypedValue();
        Resources.Theme theme = context.getTheme();
        if (theme != null && theme.resolveAttribute(id, value, true)) {
            if (value.type >= 16 && value.type <= 31) {
                return value.data;
            }
            if (value.type == 3) {
                return context.getResources().getColor(value.resourceId);
            }
        }
        return defaultValue;
    }
}

