/*
 * Decompiled with CFR 0.152.
 */
package com.alorma.timeline;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.TypedValue;
import com.alorma.timeline.R;

class AttributesUtils {
    private static TypedValue value;

    AttributesUtils() {
    }

    public static int windowBackground(Context context, int defaultValue) {
        return AttributesUtils.getColor(context, 16842836, defaultValue);
    }

    @TargetApi(value=21)
    public static int colorPrimary(Context context, int defaultValue) {
        if (Build.VERSION.SDK_INT >= 21) {
            return AttributesUtils.getColor(context, 16843827, defaultValue);
        }
        return AttributesUtils.getColor(context, R.attr.colorPrimary, defaultValue);
    }

    @TargetApi(value=21)
    public static int colorAccent(Context context, int defaultValue) {
        if (Build.VERSION.SDK_INT >= 21) {
            return AttributesUtils.getColor(context, 16843829, defaultValue);
        }
        return AttributesUtils.getColor(context, R.attr.colorAccent, defaultValue);
    }

    private static int getColor(Context context, int id, int defaultValue) {
        if (value == null) {
            value = new TypedValue();
        }
        try {
            Resources.Theme theme = context.getTheme();
            if (theme != null && theme.resolveAttribute(id, value, true)) {
                if (AttributesUtils.value.type >= 16 && AttributesUtils.value.type <= 31) {
                    return AttributesUtils.value.data;
                }
                if (AttributesUtils.value.type == 3) {
                    return context.getResources().getColor(AttributesUtils.value.resourceId);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }
}

