/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dsl.components;

import com.almasb.fxgl.time.LocalTimer;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0006J\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0018\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\b\"\u0004\b\u001a\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lcom/almasb/fxgl/dsl/components/LiftData;", "", "timer", "Lcom/almasb/fxgl/time/LocalTimer;", "(Lcom/almasb/fxgl/time/LocalTimer;)V", "distance", "", "getDistance", "()D", "setDistance", "(D)V", "duration", "Ljavafx/util/Duration;", "getDuration", "()Ljavafx/util/Duration;", "setDuration", "(Ljavafx/util/Duration;)V", "isGoingPositive", "", "()Z", "setGoingPositive", "(Z)V", "isOn", "setOn", "speed", "getSpeed", "setSpeed", "getTimer", "()Lcom/almasb/fxgl/time/LocalTimer;", "enable", "", "initTimer", "update", "tpf", "fxgl"})
final class LiftData {
    @NotNull
    private final LocalTimer timer;
    private boolean isOn;
    private boolean isGoingPositive;
    private double distance;
    @NotNull
    private Duration duration;
    private double speed;

    public LiftData(@NotNull LocalTimer timer2) {
        Intrinsics.checkNotNullParameter((Object)timer2, (String)"timer");
        this.timer = timer2;
        this.isGoingPositive = true;
        Duration duration = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
        this.duration = duration;
    }

    @NotNull
    public final LocalTimer getTimer() {
        return this.timer;
    }

    public final boolean isOn() {
        return this.isOn;
    }

    public final void setOn(boolean bl) {
        this.isOn = bl;
    }

    public final boolean isGoingPositive() {
        return this.isGoingPositive;
    }

    public final void setGoingPositive(boolean bl) {
        this.isGoingPositive = bl;
    }

    public final double getDistance() {
        return this.distance;
    }

    public final void setDistance(double d) {
        this.distance = d;
    }

    @NotNull
    public final Duration getDuration() {
        return this.duration;
    }

    public final void setDuration(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.duration = duration;
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final void setSpeed(double d) {
        this.speed = d;
    }

    public final void initTimer() {
        this.timer.capture();
    }

    public final void enable(double distance, @NotNull Duration duration, double speed) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this.distance = distance;
        this.duration = duration;
        this.speed = speed;
        this.isOn = true;
    }

    public final double update(double tpf) {
        if (this.timer.elapsed(this.duration)) {
            this.isGoingPositive = !this.isGoingPositive;
            this.timer.capture();
        }
        return this.isGoingPositive ? this.speed * tpf : -this.speed * tpf;
    }
}

