/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dev.editor;

import com.almasb.fxgl.app.services.FXGLAssetLoaderService;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.dev.editor.DevSpinComponent;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.dsl.components.HealthIntComponent;
import com.almasb.fxgl.dsl.components.ProjectileComponent;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.component.ComponentListener;
import com.almasb.fxgl.entity.components.CollidableComponent;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.ui.FXGLButton;
import com.almasb.fxgl.ui.FXGLScrollPane;
import com.almasb.fxgl.ui.UIFactoryService;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\b\u001a\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tj\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/almasb/fxgl/dev/editor/EntityInspector;", "Lcom/almasb/fxgl/ui/FXGLScrollPane;", "Lcom/almasb/fxgl/entity/component/ComponentListener;", "()V", "addComponentButton", "Lcom/almasb/fxgl/ui/FXGLButton;", "addCustomComponentButton", "addViewButton", "componentTypes", "Ljava/util/ArrayList;", "Ljava/lang/Class;", "Lcom/almasb/fxgl/entity/component/Component;", "Lkotlin/collections/ArrayList;", "value", "Lcom/almasb/fxgl/entity/Entity;", "entity", "getEntity", "()Lcom/almasb/fxgl/entity/Entity;", "setEntity", "(Lcom/almasb/fxgl/entity/Entity;)V", "innerBox", "Ljavafx/scene/layout/VBox;", "generateView", "Ljavafx/scene/layout/GridPane;", "component", "onAdded", "", "onRemoved", "updateView", "fxgl"})
public final class EntityInspector
extends FXGLScrollPane
implements ComponentListener {
    @NotNull
    private final VBox innerBox = new VBox(5.0);
    @NotNull
    private final ArrayList<Class<? extends Component>> componentTypes;
    @NotNull
    private final FXGLButton addViewButton;
    @NotNull
    private final FXGLButton addComponentButton;
    @NotNull
    private final FXGLButton addCustomComponentButton;
    @Nullable
    private Entity entity;

    public EntityInspector() {
        Object[] objectArray = new Class[]{DevSpinComponent.class, ProjectileComponent.class, HealthIntComponent.class, CollidableComponent.class};
        this.componentTypes = CollectionsKt.arrayListOf((Object[])objectArray);
        this.addViewButton = new FXGLButton("Add View");
        this.addComponentButton = new FXGLButton("Add Component");
        this.addCustomComponentButton = new FXGLButton("Add Custom Component");
        objectArray = new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, null, null)};
        this.setBackground(new Background((BackgroundFill[])objectArray));
        objectArray = new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, null, null)};
        this.innerBox.setBackground(new Background((BackgroundFill[])objectArray));
        this.innerBox.setPadding(new Insets(5.0));
        this.addViewButton.setOnAction(arg_0 -> EntityInspector._init_$lambda-2(this, arg_0));
        this.addComponentButton.setOnAction(arg_0 -> EntityInspector._init_$lambda-6(this, arg_0));
        this.addCustomComponentButton.setOnAction(arg_0 -> EntityInspector._init_$lambda-9(this, arg_0));
        this.setMaxWidth(460.0);
        this.setContent((Node)this.innerBox);
    }

    @Nullable
    public final Entity getEntity() {
        return this.entity;
    }

    public final void setEntity(@Nullable Entity value) {
        if (this.entity != null) {
            Entity entity = this.entity;
            Intrinsics.checkNotNull((Object)entity);
            entity.removeComponentListener((ComponentListener)this);
        }
        this.entity = value;
        this.updateView();
    }

    private final void updateView() {
        this.innerBox.getChildren().clear();
        if (this.entity == null) {
            return;
        }
        ObservableList observableList = this.innerBox.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"innerBox.children");
        ((Collection)observableList).add(this.addViewButton);
        observableList = this.innerBox.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"innerBox.children");
        ((Collection)observableList).add(this.addComponentButton);
        observableList = this.innerBox.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"innerBox.children");
        ((Collection)observableList).add(this.addCustomComponentButton);
        Entity entity = this.entity;
        Intrinsics.checkNotNull((Object)entity);
        List list = entity.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"entity!!.components");
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Component it = (Component)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getClass().getSimpleName());
                it = (Component)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getClass().getSimpleName())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component comp = (Component)element$iv;
            boolean bl = false;
            ObservableList observableList2 = this.innerBox.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)observableList2, (String)"innerBox.children");
            Collection collection = (Collection)observableList2;
            Intrinsics.checkNotNullExpressionValue((Object)comp, (String)"comp");
            collection.add(this.generateView(comp));
        }
        Entity entity2 = this.entity;
        Intrinsics.checkNotNull((Object)entity2);
        entity2.addComponentListener((ComponentListener)this);
    }

    /*
     * WARNING - void declaration
     */
    private final GridPane generateView(Component component) {
        void $this$forEach$iv;
        Iterable $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        GridPane pane = new GridPane();
        pane.setHgap(25.0);
        pane.setVgap(10.0);
        int index = 0;
        UIFactoryService uIFactoryService = FXGL.Companion.getUIFactoryService();
        String string = component.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"component.javaClass.simpleName");
        Text title = uIFactoryService.newText(StringsKt.removeSuffix((String)string, (CharSequence)"Component"), Color.ANTIQUEWHITE, 22.0);
        int n = index;
        index = n + 1;
        Node[] nodeArray = new Node[]{(Node)title};
        pane.addRow(n, nodeArray);
        int n2 = index;
        index = n2 + 1;
        Object[] objectArray = new Node[]{(Node)new Rectangle(165.0, 2.0, (Paint)Color.ANTIQUEWHITE)};
        pane.addRow(n2, objectArray);
        objectArray = component.getClass().getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"component.javaClass.methods");
        objectArray = objectArray;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Method it = (Method)element$iv$iv;
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
            if (!StringsKt.endsWith$default((String)string2, (String)"Property", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Method it = (Method)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Method)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method method = (Method)element$iv;
            boolean bl = false;
            Object value = method.invoke((Object)component, new Object[0]);
            UIFactoryService uIFactoryService2 = FXGLForKtKt.getUIFactoryService();
            String string3 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"method.name");
            Node view2 = uIFactoryService2.newPropertyView(StringsKt.removeSuffix((String)string3, (CharSequence)"Property"), value);
            int n3 = index;
            index = n3 + 1;
            Node[] nodeArray2 = new Node[]{view2};
            pane.addRow(n3, nodeArray2);
        }
        int n4 = index;
        index = n4 + 1;
        Node[] nodeArray3 = new Node[]{(Node)new Text("")};
        pane.addRow(n4, nodeArray3);
        return pane;
    }

    public void onAdded(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        ObservableList observableList = this.innerBox.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"innerBox.children");
        ((Collection)observableList).add(this.generateView(component));
    }

    public void onRemoved(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
    }

    private static final void _init_$lambda-2(EntityInspector this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Entity entity = this$0.entity;
        if (entity != null) {
            File file;
            Entity it2 = entity;
            boolean bl = false;
            ViewComponent viewComp = it2.getViewComponent();
            FileChooser chooser = new FileChooser();
            chooser.setInitialDirectory(new File(System.getProperty("user.dir")));
            chooser.setTitle("Select image");
            Object[] objectArray = new FileChooser.ExtensionFilter[1];
            String[] stringArray = new String[]{"*.png", "*.jpg"};
            objectArray[0] = new FileChooser.ExtensionFilter("Images", stringArray);
            chooser.getExtensionFilters().addAll(objectArray);
            File file2 = file = chooser.showOpenDialog(null);
            if (file2 != null) {
                File it3 = file2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)viewComp, (String)"viewComp");
                FXGLAssetLoaderService fXGLAssetLoaderService = FXGLForKtKt.getAssetLoader();
                URL uRL = it3.toURI().toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"it.toURI().toURL()");
                ViewComponent.addChild$default((ViewComponent)viewComp, (Node)((Node)fXGLAssetLoaderService.loadTexture(uRL)), (boolean)false, (int)2, null);
            }
        }
    }

    private static final void lambda-6$lambda-5$lambda-4(ComboBox $box, Entity $selectedEntity, ButtonType it) {
        Intrinsics.checkNotNullParameter((Object)$box, (String)"$box");
        Intrinsics.checkNotNullParameter((Object)$selectedEntity, (String)"$selectedEntity");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)it, (Object)ButtonType.OK)) {
            Class clazz = (Class)$box.getSelectionModel().getSelectedItem();
            if (clazz != null) {
                Class item = clazz;
                boolean bl = false;
                Component comp = (Component)ReflectionUtils.newInstance((Class)item);
                $selectedEntity.addComponent(comp);
            }
        }
    }

    private static final void _init_$lambda-6(EntityInspector this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Entity entity = this$0.entity;
        if (entity != null) {
            Entity selectedEntity = entity;
            boolean bl = false;
            ComboBox box = new ComboBox(FXCollections.observableList((List)this$0.componentTypes));
            box.getSelectionModel().selectFirst();
            Dialog dialog = new Dialog();
            Object[] objectArray = new ButtonType[]{ButtonType.OK, ButtonType.CANCEL};
            dialog.getDialogPane().getButtonTypes().addAll(objectArray);
            dialog.getDialogPane().setContent((Node)box);
            dialog.showAndWait().ifPresent(arg_0 -> EntityInspector.lambda-6$lambda-5$lambda-4(box, selectedEntity, arg_0));
        }
    }

    private static final void _init_$lambda-9(EntityInspector this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            Path file;
            Path path = file = Paths.get("fxgl-samples/target/classes/", new String[0]);
            if (path != null) {
                Path it2 = path;
                boolean bl = false;
                URL uRL = it2.toFile().toURI().toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"it.toFile().toURI().toURL()");
                URL url = uRL;
                URL[] uRLArray = new URL[]{url};
                URL[] urls = uRLArray;
                ClassLoader cl = new URLClassLoader(urls);
                Class<?> cls = cl.loadClass("sandbox.CustomComponent");
                Object obj = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (obj == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.almasb.fxgl.entity.component.Component");
                }
                Component instance = (Component)obj;
                System.out.println(instance);
                Entity entity = this$0.getEntity();
                if (entity != null) {
                    Entity it3 = entity;
                    boolean bl2 = false;
                    it3.addComponent(instance);
                    this$0.updateView();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

