/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.app.scene.FXGLScene;
import com.almasb.fxgl.app.scene.Viewport;
import com.almasb.fxgl.input.MouseEventData;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.scene.Scene;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ!\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f\"\u00020 H\u0016\u00a2\u0006\u0002\u0010!J!\u0010\"\u001a\u00020\u001d2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0\u001f\"\u00020$H\u0016\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u001dH\u0016J\u0010\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u001dH\u0002J\b\u0010-\u001a\u00020\u001dH\u0002J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020/H\u0014J\b\u00100\u001a\u00020\u001dH\u0016J\b\u00101\u001a\u00020$H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000eR\u000e\u0010\u0016\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000eR\u0014\u0010\u001a\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000e\u00a8\u00062"}, d2={"Lcom/almasb/fxgl/app/PrimaryStageWindow;", "Lcom/almasb/fxgl/app/MainWindow;", "stage", "Ljavafx/stage/Stage;", "scene", "Lcom/almasb/fxgl/app/scene/FXGLScene;", "settings", "Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "(Ljavafx/stage/Stage;Lcom/almasb/fxgl/app/scene/FXGLScene;Lcom/almasb/fxgl/app/ReadOnlyGameSettings;)V", "fxScene", "Ljavafx/scene/Scene;", "height", "", "getHeight", "()D", "isFocused", "", "()Z", "getStage", "()Ljavafx/stage/Stage;", "width", "getWidth", "windowBorderHeight", "windowBorderWidth", "x", "getX", "y", "getY", "addCSS", "", "cssList", "", "Lcom/almasb/fxgl/scene/CSS;", "([Lcom/almasb/fxgl/scene/CSS;)V", "addIcons", "images", "Ljavafx/scene/image/Image;", "([Ljavafx/scene/image/Image;)V", "close", "createFXScene", "root", "Ljavafx/scene/Parent;", "iconifiedProperty", "Ljavafx/beans/property/ReadOnlyBooleanProperty;", "initStage", "onStageResize", "setRoot", "Ljavafx/scene/layout/Pane;", "show", "takeScreenshot", "fxgl"})
public final class PrimaryStageWindow
extends MainWindow {
    @NotNull
    private final Stage stage;
    @NotNull
    private final javafx.scene.Scene fxScene;
    private double windowBorderWidth;
    private double windowBorderHeight;

    public PrimaryStageWindow(@NotNull Stage stage, @NotNull FXGLScene scene, @NotNull ReadOnlyGameSettings settings) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        Intrinsics.checkNotNullParameter((Object)((Object)scene), (String)"scene");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(scene, settings, null);
        this.stage = stage;
        this.fxScene = this.createFXScene((Parent)scene.getRoot());
        this.setInitialScene(scene);
        this.initStage();
        this.addKeyHandler(this.fxScene, (Function1<? super KeyEvent, Unit>)((Function1)new Function1<KeyEvent, Unit>(){

            public final void invoke(final @NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.getInput$fxgl().onKeyEvent(e);
                this.getStateMachine().runOnActiveStates((Function1)new Function1<Scene, Unit>(){

                    public final void invoke(@NotNull Scene it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.getInput().onKeyEvent(e);
                    }
                });
            }
        }));
        this.addMouseHandler(this.fxScene, (Function1<? super MouseEventData, Unit>)((Function1)new Function1<MouseEventData, Unit>(){

            public final void invoke(final @NotNull MouseEventData e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.getInput$fxgl().onMouseEvent(e);
                this.getStateMachine().runOnActiveStates((Function1)new Function1<Scene, Unit>(){

                    public final void invoke(@NotNull Scene it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.getInput().onMouseEvent(e);
                    }
                });
            }
        }));
        this.addGlobalHandler(this.fxScene, (Function1<? super Event, Unit>)((Function1)new Function1<Event, Unit>(){

            public final void invoke(final @NotNull Event e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.getInput$fxgl().fireEventViaFilters(e);
                this.getStateMachine().runOnActiveStates((Function1)new Function1<Scene, Unit>(){

                    public final void invoke(@NotNull Scene it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.getInput().fireEventViaFilters(e);
                    }
                });
            }
        }), (Function1<? super Event, Unit>)((Function1)new Function1<Event, Unit>(){

            public final void invoke(final @NotNull Event e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.getInput$fxgl().fireEventViaHandlers(e);
                this.getStateMachine().runOnActiveStates((Function1)new Function1<Scene, Unit>(){

                    public final void invoke(@NotNull Scene it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.getInput().fireEventViaHandlers(e);
                    }
                });
            }
        }));
    }

    @NotNull
    public final Stage getStage() {
        return this.stage;
    }

    @Override
    public double getX() {
        return this.stage.getX();
    }

    @Override
    public double getY() {
        return this.stage.getY();
    }

    @Override
    public double getWidth() {
        return this.stage.getWidth();
    }

    @Override
    public double getHeight() {
        return this.stage.getHeight();
    }

    @Override
    public boolean isFocused() {
        return this.stage.isFocused();
    }

    private final javafx.scene.Scene createFXScene(Parent root) {
        Rectangle2D bounds;
        this.getLog().debug("Creating a JavaFX scene");
        double newW = this.getSettings().getWidth();
        double newH = this.getSettings().getHeight();
        Rectangle2D rectangle2D = bounds = this.getSettings().isFullScreenAllowed() ? Screen.getPrimary().getBounds() : Screen.getPrimary().getVisualBounds();
        if (newW > bounds.getWidth() || newH > bounds.getHeight()) {
            this.getLog().debug("Target size > screen size");
            double extraMargin = 25.0;
            double ratio = newW / newH;
            int n = (int)bounds.getWidth();
            if (1 <= n) {
                do {
                    int newWidth;
                    if (!((double)(newWidth = n--) / ratio <= bounds.getHeight())) continue;
                    newW = (double)newWidth - extraMargin;
                    newH = (double)newWidth / ratio;
                    break;
                } while (1 <= n);
            }
        }
        newW = (int)newW;
        newH = (int)newH;
        javafx.scene.Scene scene = new javafx.scene.Scene(root, newW, newH);
        this.getScaledWidth().set(newW);
        this.getScaledHeight().set(newH);
        this.getScaleRatioX().set(this.getScaledWidth().getValue() / (double)this.getSettings().getWidth());
        this.getScaleRatioY().set(this.getScaledHeight().getValue() / (double)this.getSettings().getHeight());
        this.getLog().debug("Target settings size: " + (double)this.getSettings().getWidth() + " x " + (double)this.getSettings().getHeight());
        this.getLog().debug("Scaled scene size:    " + newW + " x " + newH);
        this.getLog().debug("Scaled ratio: (" + this.getScaleRatioX().getValue() + ", " + this.getScaleRatioY().getValue() + ")");
        return scene;
    }

    private final void initStage() {
        Stage $this$initStage_u24lambda_u2d2 = this.stage;
        boolean bl = false;
        $this$initStage_u24lambda_u2d2.setScene(this.fxScene);
        $this$initStage_u24lambda_u2d2.setTitle(this.getSettings().getTitle() + " " + this.getSettings().getVersion());
        $this$initStage_u24lambda_u2d2.setResizable(this.getSettings().isManualResizeEnabled());
        if (this.getSettings().isDesktop()) {
            $this$initStage_u24lambda_u2d2.initStyle(this.getSettings().getStageStyle());
        }
        $this$initStage_u24lambda_u2d2.setOnCloseRequest(arg_0 -> PrimaryStageWindow.initStage$lambda-2$lambda-0(this, arg_0));
        if (this.getSettings().isFullScreenAllowed()) {
            $this$initStage_u24lambda_u2d2.setFullScreenExitHint("");
            $this$initStage_u24lambda_u2d2.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
            this.getSettings().getFullScreen().addListener((arg_0, arg_1, arg_2) -> PrimaryStageWindow.initStage$lambda-2$lambda-1($this$initStage_u24lambda_u2d2, arg_0, arg_1, arg_2));
        }
        $this$initStage_u24lambda_u2d2.sizeToScene();
        $this$initStage_u24lambda_u2d2.centerOnScreen();
    }

    @Override
    public void show() {
        this.getLog().debug("Opening main window");
        this.stage.show();
        double d = this.stage.getWidth();
        Double d2 = this.getScaledWidth().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"scaledWidth.value");
        this.windowBorderWidth = d - ((Number)d2).doubleValue();
        double d3 = this.stage.getHeight();
        d2 = this.getScaledHeight().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"scaledHeight.value");
        this.windowBorderHeight = d3 - ((Number)d2).doubleValue();
        if (this.windowBorderHeight < 0.5 && this.getSettings().isLinux()) {
            this.windowBorderHeight = 35.0;
        }
        this.getScaledWidth().bind((ObservableValue)this.stage.widthProperty().subtract((ObservableNumberValue)Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)this.stage.fullScreenProperty())).then(0).otherwise(this.windowBorderWidth)));
        this.getScaledHeight().bind((ObservableValue)this.stage.heightProperty().subtract((ObservableNumberValue)Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)this.stage.fullScreenProperty())).then(0).otherwise(this.windowBorderHeight)));
        this.getSettings().getScaledWidthProp$fxgl().bind((ObservableValue)this.getScaledWidth());
        this.getSettings().getScaledHeightProp$fxgl().bind((ObservableValue)this.getScaledHeight());
        if (this.getSettings().isScaleAffectedOnResize()) {
            if (this.getSettings().isPreserveResizeRatio()) {
                this.getScaleRatioX().bind((ObservableValue)Bindings.min((ObservableNumberValue)((ObservableNumberValue)this.getScaledWidth().divide(this.getSettings().getWidth())), (ObservableNumberValue)((ObservableNumberValue)this.getScaledHeight().divide(this.getSettings().getHeight()))));
                this.getScaleRatioY().bind((ObservableValue)this.getScaleRatioX());
            } else {
                this.getScaleRatioX().bind((ObservableValue)this.getScaledWidth().divide(this.getSettings().getWidth()));
                this.getScaleRatioY().bind((ObservableValue)this.getScaledHeight().divide(this.getSettings().getHeight()));
            }
        } else {
            this.getScaleRatioX().setValue((Number)1.0);
            this.getScaleRatioY().setValue((Number)1.0);
            this.getScaledWidth().addListener((arg_0, arg_1, arg_2) -> PrimaryStageWindow.show$lambda-3(this, arg_0, arg_1, arg_2));
            this.getScaledHeight().addListener((arg_0, arg_1, arg_2) -> PrimaryStageWindow.show$lambda-4(this, arg_0, arg_1, arg_2));
        }
        this.getLog().debug("Window border size: (" + this.windowBorderWidth + ", " + this.windowBorderHeight + ")");
        this.getLog().debug("Scaled size: " + this.getScaledWidth().getValue() + " x " + this.getScaledHeight().getValue());
        this.getLog().debug("Scaled ratio: (" + this.getScaleRatioX().getValue() + ", " + this.getScaleRatioY().getValue() + ")");
        this.getLog().debug("Scene size: " + this.stage.getScene().getWidth() + " x " + this.stage.getScene().getHeight());
        this.getLog().debug("Stage size: " + this.stage.getWidth() + " x " + this.stage.getHeight());
        if (this.getSettings().isFullScreenAllowed() && this.getSettings().isFullScreenFromStart()) {
            this.stage.setFullScreen(true);
            this.getLog().debug("Going fullscreen");
        }
    }

    @Override
    public void close() {
        this.getLog().debug("Closing main window");
        this.stage.close();
    }

    @Override
    public void addIcons(Image ... images) {
        Intrinsics.checkNotNullParameter((Object)images, (String)"images");
        if (!this.getSettings().isNative()) {
            ObservableList observableList = this.stage.getIcons();
            Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"stage.icons");
            CollectionsKt.addAll((Collection)((Collection)observableList), (Object[])images);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addCSS(CSS ... cssList) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)cssList, (String)"cssList");
        ObservableList observableList = this.fxScene.getStylesheets();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"fxScene.stylesheets");
        CSS[] cSSArray = cssList;
        Collection collection = (Collection)observableList;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var12_13 = item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getExternalForm());
        }
        CollectionsKt.addAll((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    @Override
    protected void setRoot(@NotNull Pane root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.fxScene.setRoot((Parent)root);
    }

    @Override
    @NotNull
    public ReadOnlyBooleanProperty iconifiedProperty() {
        ReadOnlyBooleanProperty readOnlyBooleanProperty = this.stage.iconifiedProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyBooleanProperty, (String)"stage.iconifiedProperty()");
        return readOnlyBooleanProperty;
    }

    @Override
    @NotNull
    public Image takeScreenshot() {
        WritableImage writableImage = this.fxScene.snapshot(null);
        Intrinsics.checkNotNullExpressionValue((Object)writableImage, (String)"fxScene.snapshot(null)");
        return (Image)writableImage;
    }

    /*
     * WARNING - void declaration
     */
    private final void onStageResize() {
        void $this$filterIsInstanceTo$iv$iv;
        Double newW = this.getScaledWidth().getValue();
        Double newH = this.getScaledHeight().getValue();
        this.getLog().debug("On Stage resize: " + newW + "x" + newH);
        Iterable $this$filterIsInstance$iv = this.getScenes();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FXGLScene)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FXGLScene it = (FXGLScene)((Object)element$iv);
            boolean bl = false;
            Viewport viewport = it.getViewport();
            Intrinsics.checkNotNullExpressionValue((Object)newW, (String)"newW");
            viewport.setWidth(newW);
            Viewport viewport2 = it.getViewport();
            Intrinsics.checkNotNullExpressionValue((Object)newH, (String)"newH");
            viewport2.setHeight(newH);
        }
    }

    private static final void initStage$lambda-2$lambda-0(PrimaryStageWindow this$0, WindowEvent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        e.consume();
        Function0<Unit> function0 = this$0.getOnClose();
        if (function0 != null) {
            function0.invoke();
        }
    }

    private static final void initStage$lambda-2$lambda-1(Stage $this_with, ObservableValue $noName_0, Boolean $noName_1, Boolean fullscreenNow) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        Intrinsics.checkNotNullExpressionValue((Object)fullscreenNow, (String)"fullscreenNow");
        $this_with.setFullScreen(fullscreenNow.booleanValue());
    }

    private static final void show$lambda-3(PrimaryStageWindow this$0, ObservableValue $noName_0, Number $noName_1, Number newWidth) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onStageResize();
    }

    private static final void show$lambda-4(PrimaryStageWindow this$0, ObservableValue $noName_0, Number $noName_1, Number newHeight) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onStageResize();
    }
}

