/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.LoopRunner;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.logging.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J#\u0010\u001f\u001a\u0002H \"\b\b\u0000\u0010 *\u00020\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\u0018\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020$H\u0002J\u0006\u0010%\u001a\u00020$J\u0010\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0015H\u0002J\b\u0010(\u001a\u00020$H\u0002J\b\u0010)\u001a\u00020$H\u0002J\u0010\u0010\u0011\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010.\u001a\u00020$J\u000e\u0010/\u001a\u00020$2\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u00020$J\u0006\u00103\u001a\u00020$J\u0006\u00104\u001a\u00020$J\u0006\u00105\u001a\u00020$J\u000e\u00106\u001a\u00020$2\u0006\u00100\u001a\u000201R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR0\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0001`\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u0017\u001a.\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0018\u0012\u0004\u0012\u00020\u00150\nj\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0018\u0012\u0004\u0012\u00020\u0015`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00067"}, d2={"Lcom/almasb/fxgl/app/Engine;", "", "settings", "Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "(Lcom/almasb/fxgl/app/ReadOnlyGameSettings;)V", "cpuNanoTime", "", "getCpuNanoTime", "()J", "environmentVars", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getEnvironmentVars$fxgl", "()Ljava/util/HashMap;", "log", "Lcom/almasb/fxgl/logging/Logger;", "loop", "Lcom/almasb/fxgl/app/LoopRunner;", "services", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/core/EngineService;", "Lkotlin/collections/ArrayList;", "servicesCache", "Ljava/lang/Class;", "getSettings", "()Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "tpf", "", "getTpf", "()D", "getService", "T", "serviceClass", "(Ljava/lang/Class;)Lcom/almasb/fxgl/core/EngineService;", "initEnvironmentVars", "", "initServices", "injectDependenciesIntoService", "service", "logEnvironmentVarsAndServices", "logVersion", "onGameReady", "vars", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "onGameUpdate", "pauseLoop", "read", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "resumeLoop", "startLoop", "stopLoop", "stopLoopAndExitServices", "write", "fxgl"})
public final class Engine {
    @NotNull
    private final ReadOnlyGameSettings settings;
    @NotNull
    private final Logger log;
    @NotNull
    private final LoopRunner loop;
    @NotNull
    private final ArrayList<EngineService> services;
    @NotNull
    private final HashMap<Class<? extends EngineService>, EngineService> servicesCache;
    @NotNull
    private final HashMap<String, Object> environmentVars;

    public Engine(@NotNull ReadOnlyGameSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.log = Logger.Companion.get(this.getClass());
        this.loop = new LoopRunner(this.settings.getTicksPerSecond(), (Function1<? super Double, Unit>)((Function1)new Function1<Double, Unit>(this){
            final /* synthetic */ Engine this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(double it) {
                Engine.access$loop(this.this$0, it);
            }
        }));
        this.services = new ArrayList();
        this.servicesCache = new HashMap();
        this.environmentVars = new HashMap();
        this.logVersion();
    }

    @NotNull
    public final ReadOnlyGameSettings getSettings() {
        return this.settings;
    }

    public final double getTpf() {
        return this.loop.tpf();
    }

    public final long getCpuNanoTime() {
        return this.loop.getCpuNanoTime();
    }

    @NotNull
    public final HashMap<String, Object> getEnvironmentVars$fxgl() {
        return this.environmentVars;
    }

    private final void logVersion() {
        String jVersion = System.getProperty("java.version", "?");
        String fxVersion = System.getProperty("javafx.version", "?");
        String javaVendorName = System.getProperty("java.vendor", "?");
        String operatingSystemName = System.getProperty("os.name", "?");
        String operatingSystemVersion = System.getProperty("os.version", "?");
        String operatingSystemArchitecture = System.getProperty("os.arch", "?");
        String version = this.settings.getRuntimeInfo().getVersion();
        String build = this.settings.getRuntimeInfo().getBuild();
        this.log.info("FXGL-" + version + " (" + build + ") on " + this.settings.getPlatform() + " (J:" + jVersion + " FX:" + fxVersion + ")");
        this.log.debug("JRE Vendor Name: " + javaVendorName);
        this.log.debug("Running on OS: " + operatingSystemName + " version " + operatingSystemVersion);
        this.log.debug("Architecture: " + operatingSystemArchitecture);
        this.log.info("Source code and latest versions at: https://github.com/AlmasB/FXGL");
        this.log.info("      Ask questions and discuss at: https://github.com/AlmasB/FXGL/discussions");
        this.log.info("             Join the FXGL chat at: https://gitter.im/AlmasB/FXGL");
    }

    @NotNull
    public final <T extends EngineService> T getService(@NotNull Class<T> serviceClass) {
        EngineService engineService;
        EngineService engineService2;
        Object v1;
        block6: {
            Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
            if (this.servicesCache.containsKey(serviceClass)) {
                EngineService engineService3 = this.servicesCache.get(serviceClass);
                if (engineService3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type T of com.almasb.fxgl.app.Engine.getService");
                }
                return (T)engineService3;
            }
            for (Object t : (Iterable)this.services) {
                EngineService it = (EngineService)t;
                boolean bl = false;
                if (!serviceClass.isAssignableFrom(it.getClass())) continue;
                v1 = t;
                break block6;
            }
            v1 = null;
        }
        EngineService engineService4 = v1;
        if (engineService4 == null) {
            engineService2 = null;
        } else {
            EngineService engineService5;
            EngineService it = engineService5 = engineService4;
            boolean bl = false;
            ((Map)this.servicesCache).put(serviceClass, it);
            engineService2 = engineService = engineService5;
        }
        if (engineService == null) {
            throw new IllegalArgumentException("Engine does not have service: " + serviceClass);
        }
        return (T)engineService;
    }

    public final void initServices() {
        Class it;
        this.initEnvironmentVars();
        Iterable $this$forEach$iv = this.settings.getEngineServices();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Class)element$iv;
            boolean bl = false;
            ((Collection)this.services).add(ReflectionUtils.newInstance((Class)it));
        }
        $this$forEach$iv = this.services;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (EngineService)element$iv;
            boolean bl = false;
            this.injectDependenciesIntoService((EngineService)it);
        }
        $this$forEach$iv = this.services;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (EngineService)element$iv;
            boolean bl = false;
            it.onInit();
        }
        Runnable runnable = () -> Engine.initServices$lambda-5(this);
        Duration duration = Duration.seconds((double)3.0);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"seconds(3.0)");
        Async.INSTANCE.schedule(runnable, duration);
    }

    /*
     * Unable to fully structure code
     */
    private final void initEnvironmentVars() {
        this.log.debug("Initializing environment variables");
        var1_1 = this.settings.getClass().getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)var1_1, (String)"settings.javaClass.declaredMethods");
        $this$filter$iv = var1_1;
        $i$f$filter = false;
        var3_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var6_7 = $this$filterTo$iv$iv;
        var7_9 = 0;
        var8_11 = ((void)var6_7).length;
        while (var7_9 < var8_11) {
            element$iv$iv = var6_7[var7_9];
            ++var7_9;
            it = (Method)element$iv$iv;
            $i$a$-filter-Engine$initEnvironmentVars$1 = false;
            var12_16 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)var12_16, (String)"it.name");
            if (StringsKt.startsWith$default((String)var12_16, (String)"is", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            var12_16 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)var12_16, (String)"it.name");
            if (StringsKt.startsWith$default((String)var12_16, (String)"get", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            var12_16 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)var12_16, (String)"it.name");
            if (StringsKt.endsWith$default((String)var12_16, (String)"Property", (boolean)false, (int)2, null)) lbl-1000:
            // 3 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            if (!v0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (Method)element$iv;
            $i$a$-forEach-Engine$initEnvironmentVars$2 = false;
            v1 = this.getEnvironmentVars$fxgl();
            var7_10 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)var7_10, (String)"it.name");
            v2 = StringsKt.decapitalize((String)StringsKt.removePrefix((String)var7_10, (CharSequence)"get"));
            var8_12 = it.invoke((Object)this.getSettings(), new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)var8_12, (String)"it.invoke(settings)");
            v1.put(v2, var8_12);
        }
    }

    private final void injectDependenciesIntoService(EngineService service) {
        Field field;
        Array array = ReflectionUtils.findFieldsByAnnotation((Object)service, Inject.class);
        Intrinsics.checkNotNullExpressionValue((Object)array, (String)"findFieldsByAnnotation(s\u2026vice, Inject::class.java)");
        Iterable $this$forEach$iv = (Iterable)array;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            field = (Field)element$iv;
            boolean bl = false;
            String injectKey = field.getDeclaredAnnotation(Inject.class).value();
            if (!((Map)this.getEnvironmentVars$fxgl()).containsKey(injectKey)) {
                throw new IllegalArgumentException("Cannot inject @Inject(" + injectKey + "). No value present for " + injectKey);
            }
            ReflectionUtils.inject((Field)field, (Object)service, (Object)this.getEnvironmentVars$fxgl().get(injectKey));
        }
        $this$forEach$iv = ReflectionUtils.findFieldsByTypeRecursive((Object)service, EngineService.class);
        Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"findFieldsByTypeRecursiv\u2026ngineService::class.java)");
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            block5: {
                field = (Field)element$iv;
                boolean bl = false;
                for (Object t : (Iterable)this.services) {
                    EngineService it = (EngineService)t;
                    boolean bl2 = false;
                    if (!field.getType().isAssignableFrom(it.getClass())) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            EngineService engineService = v0;
            if (engineService == null) {
                throw new IllegalStateException("No provider found for " + field.getType());
            }
            EngineService provider = engineService;
            ReflectionUtils.inject((Field)field, (Object)service, (Object)provider);
        }
    }

    private final void logEnvironmentVarsAndServices() {
        Map.Entry element$iv;
        this.log.debug("Logging environment variables");
        Object $this$forEach$iv = MapsKt.toSortedMap((Map)this.environmentVars);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry $dstr$key$value = element$iv = iterator.next();
            boolean bl = false;
            String key = (String)$dstr$key$value.getKey();
            Object value = $dstr$key$value.getValue();
            this.log.debug(key + ": " + value);
        }
        this.log.debug("Logging services");
        $this$forEach$iv = this.services;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            this.log.debug(String.valueOf(it.getClass()));
        }
    }

    private final void loop(double tpf) {
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.onUpdate(tpf);
        }
    }

    public final void onGameUpdate(double tpf) {
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.onGameUpdate(tpf);
        }
    }

    public final void onGameReady(@NotNull PropertyMap vars) {
        Intrinsics.checkNotNullParameter((Object)vars, (String)"vars");
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.onGameReady(vars);
        }
    }

    public final void startLoop() {
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.onMainLoopStarting();
        }
        this.loop.start();
    }

    public final void stopLoop() {
        this.loop.stop();
    }

    public final void stopLoopAndExitServices() {
        this.loop.stop();
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.onExit();
        }
    }

    public final void pauseLoop() {
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.onMainLoopPausing();
        }
        this.loop.pause();
    }

    public final void resumeLoop() {
        this.loop.resume();
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.onMainLoopResumed();
        }
    }

    public final void write(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        this.settings.write(bundle);
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.write(bundle);
        }
    }

    public final void read(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        this.settings.read(bundle);
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.read(bundle);
        }
    }

    private static final void initServices$lambda-5(Engine this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.logEnvironmentVarsAndServices();
    }

    public static final /* synthetic */ void access$loop(Engine $this, double tpf) {
        $this.loop(tpf);
    }
}

