/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.multiplayer;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.collection.PropertyMapChangeListener;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.event.EventBus;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.KeyTrigger;
import com.almasb.fxgl.input.MouseTrigger;
import com.almasb.fxgl.input.Trigger;
import com.almasb.fxgl.input.TriggerListener;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.multiplayer.ActionBeginReplicationEvent;
import com.almasb.fxgl.multiplayer.ActionEndReplicationEvent;
import com.almasb.fxgl.multiplayer.EntityRemoveEvent;
import com.almasb.fxgl.multiplayer.EntitySpawnEvent;
import com.almasb.fxgl.multiplayer.EntityUpdateEvent;
import com.almasb.fxgl.multiplayer.MultiplayerService;
import com.almasb.fxgl.multiplayer.NetworkComponent;
import com.almasb.fxgl.multiplayer.PropertyRemoveReplicationEvent;
import com.almasb.fxgl.multiplayer.PropertyUpdateReplicationEvent;
import com.almasb.fxgl.multiplayer.ReplicationEvent;
import com.almasb.fxgl.net.Connection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.event.Event;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0014\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0017\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0018\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010\u001b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ/\u0010\u001c\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e\"\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010 J$\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\b2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\f0$H\u0002J\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0016J$\u0010(\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J$\u0010-\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010.\u001a\b\u0012\u0004\u0012\u00020*0/H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0005\u001a*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006j\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/almasb/fxgl/multiplayer/MultiplayerService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "replicatedEntitiesMap", "Ljava/util/HashMap;", "Lcom/almasb/fxgl/net/Connection;", "Lcom/almasb/fxgl/core/serialization/Bundle;", "Lcom/almasb/fxgl/multiplayer/MultiplayerService$ConnectionData;", "Lkotlin/collections/HashMap;", "addEntityReplicationReceiver", "", "connection", "gameWorld", "Lcom/almasb/fxgl/entity/GameWorld;", "addEventReplicationReceiver", "eventBus", "Lcom/almasb/fxgl/event/EventBus;", "addEventReplicationSender", "addInputReplicationReceiver", "input", "Lcom/almasb/fxgl/input/Input;", "addInputReplicationSender", "addPropertyReplicationReceiver", "map", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "addPropertyReplicationSender", "fire", "events", "", "Lcom/almasb/fxgl/multiplayer/ReplicationEvent;", "(Lcom/almasb/fxgl/net/Connection;[Lcom/almasb/fxgl/multiplayer/ReplicationEvent;)V", "handleIfReplicationBundle", "bundle", "handler", "Lkotlin/Function1;", "onGameUpdate", "tpf", "", "spawn", "entity", "Lcom/almasb/fxgl/entity/Entity;", "entityName", "", "updateReplicatedEntities", "entities", "", "ConnectionData", "fxgl"})
public final class MultiplayerService
extends EngineService {
    @NotNull
    private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
    @NotNull
    private final HashMap<Connection<Bundle>, ConnectionData> replicatedEntitiesMap;

    public MultiplayerService() {
        boolean bl = false;
        this.replicatedEntitiesMap = new HashMap();
    }

    public void onGameUpdate(double tpf) {
        if (this.replicatedEntitiesMap.isEmpty()) {
            return;
        }
        this.replicatedEntitiesMap.forEach((arg_0, arg_1) -> MultiplayerService.onGameUpdate$lambda-0(this, arg_0, arg_1));
    }

    private final void updateReplicatedEntities(Connection<Bundle> connection, List<Entity> entities) {
        boolean bl = false;
        ArrayList events = new ArrayList();
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl2;
            ReplicationEvent replicationEvent;
            Collection collection;
            Entity it = (Entity)element$iv;
            boolean bl3 = false;
            long networkID = ((NetworkComponent)it.getComponent(NetworkComponent.class)).getId();
            if (it.isActive()) {
                collection = events;
                replicationEvent = new EntityUpdateEvent(networkID, it.getX(), it.getY(), it.getZ());
                bl2 = false;
                collection.add(replicationEvent);
                continue;
            }
            collection = events;
            replicationEvent = new EntityRemoveEvent(networkID);
            bl2 = false;
            collection.add(replicationEvent);
        }
        ReplicationEvent[] replicationEventArray = (ReplicationEvent[])events;
        $i$f$forEach = false;
        if (!replicationEventArray.isEmpty()) {
            Collection $this$toTypedArray$iv = events;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ReplicationEvent[] replicationEventArray2 = thisCollection$iv.toArray(new ReplicationEvent[0]);
            if (replicationEventArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            replicationEventArray = replicationEventArray2;
            this.fire(connection, Arrays.copyOf(replicationEventArray, replicationEventArray.length));
        }
        entities.removeIf(MultiplayerService::updateReplicatedEntities$lambda-2);
    }

    public final void spawn(@NotNull Connection<Bundle> connection, @NotNull Entity entity, @NotNull String entityName) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        if (!entity.hasComponent(NetworkComponent.class)) {
            this.log.warning("Attempted to network-spawn entity " + entityName + ", but it does not have NetworkComponent");
            return;
        }
        NetworkComponent networkComponent = (NetworkComponent)entity.getComponent(NetworkComponent.class);
        EntitySpawnEvent event = new EntitySpawnEvent(networkComponent.getId(), entityName, entity.getX(), entity.getY(), entity.getZ());
        ReplicationEvent[] replicationEventArray = this.replicatedEntitiesMap.getOrDefault(connection, new ConnectionData());
        Intrinsics.checkNotNullExpressionValue((Object)replicationEventArray, (String)"replicatedEntitiesMap.getOrDefault(connection, ConnectionData())");
        ConnectionData data = replicationEventArray;
        replicationEventArray = data;
        Collection collection = replicationEventArray.getEntities();
        boolean bl = false;
        collection.add(entity);
        replicationEventArray = this.replicatedEntitiesMap;
        boolean bl2 = false;
        replicationEventArray.put(connection, data);
        replicationEventArray = new ReplicationEvent[]{event};
        this.fire(connection, replicationEventArray);
    }

    public final void addEntityReplicationReceiver(@NotNull Connection<Bundle> connection, @NotNull GameWorld gameWorld) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)gameWorld, (String)"gameWorld");
        connection.addMessageHandlerFX((arg_0, arg_1) -> MultiplayerService.addEntityReplicationReceiver$lambda-3(this, gameWorld, arg_0, arg_1));
    }

    public final void addInputReplicationSender(@NotNull Connection<Bundle> connection, @NotNull Input input) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        input.addTriggerListener(new TriggerListener(this, connection){
            final /* synthetic */ MultiplayerService this$0;
            final /* synthetic */ Connection<Bundle> $connection;
            {
                this.this$0 = $receiver;
                this.$connection = $connection;
            }

            protected void onActionBegin(@NotNull Trigger trigger) {
                Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
                ActionBeginReplicationEvent event = trigger.isKey() ? new ActionBeginReplicationEvent(((KeyTrigger)trigger).getKey(), null, 2, null) : new ActionBeginReplicationEvent(null, ((MouseTrigger)trigger).getButton(), 1, null);
                ReplicationEvent[] replicationEventArray = new ReplicationEvent[]{event};
                MultiplayerService.access$fire(this.this$0, this.$connection, replicationEventArray);
            }

            protected void onActionEnd(@NotNull Trigger trigger) {
                Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
                ActionEndReplicationEvent event = trigger.isKey() ? new ActionEndReplicationEvent(((KeyTrigger)trigger).getKey(), null, 2, null) : new ActionEndReplicationEvent(null, ((MouseTrigger)trigger).getButton(), 1, null);
                ReplicationEvent[] replicationEventArray = new ReplicationEvent[]{event};
                MultiplayerService.access$fire(this.this$0, this.$connection, replicationEventArray);
            }
        });
    }

    public final void addPropertyReplicationSender(@NotNull Connection<Bundle> connection, @NotNull PropertyMap map) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        map.addListener(new PropertyMapChangeListener(this, connection){
            final /* synthetic */ MultiplayerService this$0;
            final /* synthetic */ Connection<Bundle> $connection;
            {
                this.this$0 = $receiver;
                this.$connection = $connection;
            }

            public void onUpdated(@NotNull String propertyName, @NotNull Object propertyValue) {
                Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
                Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
                PropertyUpdateReplicationEvent event = new PropertyUpdateReplicationEvent(propertyName, propertyValue);
                ReplicationEvent[] replicationEventArray = new ReplicationEvent[]{event};
                MultiplayerService.access$fire(this.this$0, this.$connection, replicationEventArray);
            }

            public void onRemoved(@NotNull String propertyName, @NotNull Object propertyValue) {
                Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
                Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
                PropertyRemoveReplicationEvent event = new PropertyRemoveReplicationEvent(propertyName);
                ReplicationEvent[] replicationEventArray = new ReplicationEvent[]{event};
                MultiplayerService.access$fire(this.this$0, this.$connection, replicationEventArray);
            }
        });
    }

    public final void addPropertyReplicationReceiver(@NotNull Connection<Bundle> connection, @NotNull PropertyMap map) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        connection.addMessageHandlerFX((arg_0, arg_1) -> MultiplayerService.addPropertyReplicationReceiver$lambda-4(this, map, arg_0, arg_1));
    }

    public final void addInputReplicationReceiver(@NotNull Connection<Bundle> connection, @NotNull Input input) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        connection.addMessageHandlerFX((arg_0, arg_1) -> MultiplayerService.addInputReplicationReceiver$lambda-5(this, input, arg_0, arg_1));
    }

    public final void addEventReplicationSender(@NotNull Connection<Bundle> connection, @NotNull EventBus eventBus) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        eventBus.addEventHandler(ReplicationEvent.ANY, arg_0 -> MultiplayerService.addEventReplicationSender$lambda-6(this, connection, arg_0));
    }

    public final void addEventReplicationReceiver(@NotNull Connection<Bundle> connection, @NotNull EventBus eventBus) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        connection.addMessageHandlerFX((arg_0, arg_1) -> MultiplayerService.addEventReplicationReceiver$lambda-7(this, eventBus, arg_0, arg_1));
    }

    private final void fire(Connection<Bundle> connection, ReplicationEvent ... events) {
        if (!connection.isConnected()) {
            return;
        }
        Bundle bundle = new Bundle("REPLICATION_EVENT");
        ArrayList list = new ArrayList(ArraysKt.toList((Object[])events));
        bundle.put("events", (Serializable)list);
        connection.send((Object)bundle);
    }

    private final void handleIfReplicationBundle(Bundle bundle, Function1<? super ReplicationEvent, Unit> handler) {
        if (Intrinsics.areEqual((Object)bundle.getName(), (Object)"REPLICATION_EVENT")) {
            List events = (List)bundle.get("events");
            Iterable $this$forEach$iv = events;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                handler.invoke(element$iv);
            }
        }
    }

    private static final void onGameUpdate$lambda-0(MultiplayerService this$0, Connection conn, ConnectionData data) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Collection collection = data.getEntities();
        boolean bl = false;
        if (!collection.isEmpty()) {
            this$0.updateReplicatedEntities((Connection<Bundle>)conn, (List<Entity>)data.getEntities());
        }
    }

    private static final boolean updateReplicatedEntities$lambda-2(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isActive();
    }

    private static final void addEntityReplicationReceiver$lambda-3(MultiplayerService this$0, GameWorld $gameWorld, Connection $noName_0, Bundle message) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$gameWorld, (String)"$gameWorld");
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        this$0.handleIfReplicationBundle(message, (Function1<? super ReplicationEvent, Unit>)((Function1)new Function1<ReplicationEvent, Unit>($gameWorld){
            final /* synthetic */ GameWorld $gameWorld;
            {
                this.$gameWorld = $gameWorld;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ReplicationEvent event) {
                block5: {
                    Map $this$filterValues$iv;
                    ReplicationEvent replicationEvent;
                    block6: {
                        void $this$forEach$iv;
                        Map $this$filterValues$iv2;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                            replicationEvent = event;
                            if (!(replicationEvent instanceof EntitySpawnEvent)) break block4;
                            long id = ((EntitySpawnEvent)event).getNetworkID();
                            String entityName = ((EntitySpawnEvent)event).getEntityName();
                            Entity e = this.$gameWorld.spawn(entityName, new SpawnData(((EntitySpawnEvent)event).getX(), ((EntitySpawnEvent)event).getY(), ((EntitySpawnEvent)event).getZ()));
                            e.getComponentOptional(NetworkComponent.class).ifPresent(arg_0 -> addEntityReplicationReceiver.1.1.invoke$lambda-0(id, arg_0));
                            break block5;
                        }
                        if (!(replicationEvent instanceof EntityUpdateEvent)) break block6;
                        long id = ((EntityUpdateEvent)event).getNetworkID();
                        Map entityName = this.$gameWorld.getEntitiesByComponentMapped(NetworkComponent.class);
                        boolean $i$f$filterValues = false;
                        LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                        void var8_14 = $this$filterValues$iv2;
                        boolean bl = false;
                        for (Map.Entry<K, V> entry$iv : var8_14.entrySet()) {
                            NetworkComponent it = (NetworkComponent)((Object)entry$iv.getValue());
                            boolean bl2 = false;
                            if (!(it.getId() == id)) continue;
                            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                        }
                        $this$filterValues$iv2 = result$iv;
                        boolean $i$f$forEach = false;
                        result$iv = $this$forEach$iv;
                        boolean bl3 = false;
                        Iterator<Map.Entry<K, V>> iterator = result$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> $dstr$e$_u24__u24 = element$iv = iterator.next();
                            boolean bl4 = false;
                            Map.Entry<K, V> bl2 = $dstr$e$_u24__u24;
                            boolean bl5 = false;
                            Entity e = (Entity)bl2.getKey();
                            e.setPosition3D(((EntityUpdateEvent)event).getX(), ((EntityUpdateEvent)event).getY(), ((EntityUpdateEvent)event).getZ());
                        }
                        break block5;
                    }
                    if (!(replicationEvent instanceof EntityRemoveEvent)) break block5;
                    long id = ((EntityRemoveEvent)event).getNetworkID();
                    Map $this$forEach$iv = this.$gameWorld.getEntitiesByComponentMapped(NetworkComponent.class);
                    boolean $i$f$filterValues = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    void var8_16 = $this$filterValues$iv;
                    boolean bl = false;
                    Object element$iv = var8_16.entrySet().iterator();
                    while (element$iv.hasNext()) {
                        Map.Entry<K, V> entry$iv = element$iv.next();
                        NetworkComponent it = (NetworkComponent)((Object)entry$iv.getValue());
                        boolean bl6 = false;
                        if (!(it.getId() == id)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    $this$filterValues$iv = result$iv;
                    boolean $i$f$forEach = false;
                    Map map = $this$forEach$iv;
                    boolean bl7 = false;
                    Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Object $dstr$e$_u24__u24 = element$iv = iterator.next();
                        boolean bl8 = false;
                        Object object = $dstr$e$_u24__u24;
                        boolean bl9 = false;
                        Entity e = (Entity)object.getKey();
                        e.removeFromWorld();
                    }
                }
            }

            private static final void invoke$lambda-0(long $id, NetworkComponent it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                it.setId$fxgl($id);
            }
        }));
    }

    private static final void addPropertyReplicationReceiver$lambda-4(MultiplayerService this$0, PropertyMap $map, Connection $noName_0, Bundle message) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$map, (String)"$map");
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        this$0.handleIfReplicationBundle(message, (Function1<? super ReplicationEvent, Unit>)((Function1)new Function1<ReplicationEvent, Unit>($map){
            final /* synthetic */ PropertyMap $map;
            {
                this.$map = $map;
                super(1);
            }

            public final void invoke(@NotNull ReplicationEvent event) {
                Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                ReplicationEvent replicationEvent = event;
                if (replicationEvent instanceof PropertyUpdateReplicationEvent) {
                    this.$map.setValue(((PropertyUpdateReplicationEvent)event).getPropertyName(), ((PropertyUpdateReplicationEvent)event).getPropertyValue());
                } else if (replicationEvent instanceof PropertyRemoveReplicationEvent) {
                    this.$map.remove(((PropertyRemoveReplicationEvent)event).getPropertyName());
                }
            }
        }));
    }

    private static final void addInputReplicationReceiver$lambda-5(MultiplayerService this$0, Input $input, Connection $noName_0, Bundle message) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$input, (String)"$input");
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        this$0.handleIfReplicationBundle(message, (Function1<? super ReplicationEvent, Unit>)((Function1)new Function1<ReplicationEvent, Unit>($input){
            final /* synthetic */ Input $input;
            {
                this.$input = $input;
                super(1);
            }

            public final void invoke(@NotNull ReplicationEvent event) {
                Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                if (event instanceof ActionBeginReplicationEvent) {
                    KeyCode it;
                    boolean bl;
                    boolean bl2;
                    Input input;
                    KeyCode keyCode;
                    KeyCode keyCode2 = ((ActionBeginReplicationEvent)event).getKey();
                    if (keyCode2 != null) {
                        keyCode = keyCode2;
                        input = this.$input;
                        bl2 = false;
                        bl = false;
                        it = keyCode;
                        boolean bl3 = false;
                        input.mockTriggerPress((Trigger)new KeyTrigger(it, null, 2, null));
                    }
                    keyCode2 = ((ActionBeginReplicationEvent)event).getBtn();
                    if (keyCode2 != null) {
                        keyCode = keyCode2;
                        input = this.$input;
                        bl2 = false;
                        bl = false;
                        it = keyCode;
                        boolean bl4 = false;
                        input.mockTriggerPress((Trigger)new MouseTrigger((MouseButton)it, null, 2, null));
                    }
                } else if (event instanceof ActionEndReplicationEvent) {
                    KeyCode it;
                    boolean bl;
                    boolean bl5;
                    Input input;
                    KeyCode keyCode;
                    KeyCode keyCode3 = ((ActionEndReplicationEvent)event).getKey();
                    if (keyCode3 != null) {
                        keyCode = keyCode3;
                        input = this.$input;
                        bl5 = false;
                        bl = false;
                        it = keyCode;
                        boolean bl6 = false;
                        input.mockTriggerRelease((Trigger)new KeyTrigger(it, null, 2, null));
                    }
                    keyCode3 = ((ActionEndReplicationEvent)event).getBtn();
                    if (keyCode3 != null) {
                        keyCode = keyCode3;
                        input = this.$input;
                        bl5 = false;
                        bl = false;
                        it = keyCode;
                        boolean bl7 = false;
                        input.mockTriggerRelease((Trigger)new MouseTrigger((MouseButton)it, null, 2, null));
                    }
                }
            }
        }));
    }

    private static final void addEventReplicationSender$lambda-6(MultiplayerService this$0, Connection $connection, ReplicationEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$connection, (String)"$connection");
        ReplicationEvent[] replicationEventArray = new ReplicationEvent[1];
        Intrinsics.checkNotNullExpressionValue((Object)((Object)event), (String)"event");
        replicationEventArray[0] = event;
        this$0.fire((Connection<Bundle>)$connection, replicationEventArray);
    }

    private static final void addEventReplicationReceiver$lambda-7(MultiplayerService this$0, EventBus $eventBus, Connection $noName_0, Bundle message) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$eventBus, (String)"$eventBus");
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        this$0.handleIfReplicationBundle(message, (Function1<? super ReplicationEvent, Unit>)((Function1)new Function1<ReplicationEvent, Unit>($eventBus){
            final /* synthetic */ EventBus $eventBus;
            {
                this.$eventBus = $eventBus;
                super(1);
            }

            public final void invoke(@NotNull ReplicationEvent it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                this.$eventBus.fireEvent((Event)it);
            }
        }));
    }

    public static final /* synthetic */ void access$fire(MultiplayerService $this, Connection connection, ReplicationEvent ... events) {
        $this.fire((Connection<Bundle>)connection, events);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/almasb/fxgl/multiplayer/MultiplayerService$ConnectionData;", "", "()V", "entities", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/entity/Entity;", "Lkotlin/collections/ArrayList;", "getEntities", "()Ljava/util/ArrayList;", "fxgl"})
    private static final class ConnectionData {
        @NotNull
        private final ArrayList<Entity> entities = new ArrayList();

        @NotNull
        public final ArrayList<Entity> getEntities() {
            return this.entities;
        }
    }
}

