/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.trade;

import com.almasb.fxgl.trade.ShopListener;
import com.almasb.fxgl.trade.TradeItem;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0002\u0010\u0006B!\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0002\u0010\tJ*\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u001f\u001a\u00020\bJ\u0006\u0010 \u001a\u00020!R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/almasb/fxgl/trade/Shop;", "T", "", "items", "", "Lcom/almasb/fxgl/trade/TradeItem;", "(Ljava/util/List;)V", "initialMoney", "", "(ILjava/util/List;)V", "Ljavafx/collections/ObservableList;", "getItems", "()Ljavafx/collections/ObservableList;", "listener", "Lcom/almasb/fxgl/trade/ShopListener;", "getListener", "()Lcom/almasb/fxgl/trade/ShopListener;", "setListener", "(Lcom/almasb/fxgl/trade/ShopListener;)V", "value", "money", "getMoney", "()I", "setMoney", "(I)V", "propMoney", "Ljavafx/beans/property/SimpleIntegerProperty;", "buyFrom", "", "other", "item", "qty", "moneyProperty", "Ljavafx/beans/property/IntegerProperty;", "fxgl-gameplay"})
public final class Shop<T> {
    @Nullable
    private ShopListener<T> listener;
    @NotNull
    private final ObservableList<TradeItem<T>> items;
    @NotNull
    private final SimpleIntegerProperty propMoney;

    public Shop(int initialMoney, @NotNull List<TradeItem<T>> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        ObservableList observableList = FXCollections.observableArrayList((Collection)items);
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"observableArrayList(items)");
        this.items = observableList;
        this.propMoney = new SimpleIntegerProperty(initialMoney);
    }

    public Shop(@NotNull List<TradeItem<T>> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this(0, items);
    }

    @Nullable
    public final ShopListener<T> getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable ShopListener<T> shopListener) {
        this.listener = shopListener;
    }

    @NotNull
    public final ObservableList<TradeItem<T>> getItems() {
        return this.items;
    }

    @NotNull
    public final IntegerProperty moneyProperty() {
        return (IntegerProperty)this.propMoney;
    }

    public final int getMoney() {
        Integer n = this.propMoney.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"propMoney.value");
        return ((Number)n).intValue();
    }

    public final void setMoney(int value) {
        this.propMoney.setValue((Number)value);
    }

    public final boolean buyFrom(@NotNull Shop<T> other, @NotNull TradeItem<T> item, int qty) {
        Object object;
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Intrinsics.checkNotNullParameter(item, (String)"item");
        if (item.getQuantity() < qty) {
            return false;
        }
        if (!other.items.contains(item)) {
            return false;
        }
        int cost = item.getBuyPrice() * qty;
        if (this.getMoney() < cost) {
            return false;
        }
        Shop<T> shop = this;
        shop.setMoney(shop.getMoney() - cost);
        shop = other;
        shop.setMoney(shop.getMoney() + cost);
        Shop<T> shop2 = item.copy();
        boolean bl = false;
        boolean bl2 = false;
        TradeItem<T> it = shop2;
        boolean bl3 = false;
        it.setQuantity(qty);
        TradeItem<T> copy = shop2;
        shop2 = this.listener;
        if (shop2 != null) {
            shop2.onBought(copy);
        }
        shop2 = other.listener;
        if (shop2 != null) {
            shop2.onSold(copy);
        }
        shop2 = item;
        ((TradeItem)((Object)shop2)).setQuantity(((TradeItem)((Object)shop2)).getQuantity() - qty);
        if (this.items.contains(item)) {
            Object v0;
            block9: {
                Iterable iterable = (Iterable)this.items;
                boolean bl4 = false;
                Iterable iterable2 = iterable;
                boolean bl5 = false;
                for (Object t : iterable2) {
                    TradeItem it2 = (TradeItem)t;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)it2, item)) continue;
                    v0 = t;
                    break block9;
                }
                v0 = null;
            }
            object = v0;
            Intrinsics.checkNotNull((Object)object);
            shop2 = object;
            ((TradeItem)((Object)shop2)).setQuantity(((TradeItem)((Object)shop2)).getQuantity() + qty);
        } else {
            shop2 = this;
            object = (Collection)shop2.items;
            TradeItem<T> tradeItem = item.copy();
            boolean bl7 = false;
            boolean bl8 = false;
            TradeItem<T> it3 = tradeItem;
            boolean bl9 = false;
            it3.setQuantity(qty);
            bl7 = false;
            object.add(tradeItem);
        }
        if (item.getQuantity() == 0) {
            shop2 = other;
            object = (Collection)shop2.items;
            boolean bl10 = false;
            object.remove(item);
        }
        return true;
    }
}

