/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.collision;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.collision.Manifold;
import com.almasb.fxgl.physics.box2d.common.JBoxSettings;
import com.almasb.fxgl.physics.box2d.common.Rotation;
import com.almasb.fxgl.physics.box2d.common.Transform;

public final class WorldManifold {
    private final Vec2 normal = new Vec2();
    private final Vec2[] points = new Vec2[JBoxSettings.maxManifoldPoints];
    private final Vec2 pool3 = new Vec2();
    private final Vec2 pool4 = new Vec2();

    public WorldManifold() {
        for (int i = 0; i < JBoxSettings.maxManifoldPoints; ++i) {
            this.points[i] = new Vec2();
        }
    }

    public float getNormalX() {
        return this.normal.x;
    }

    public float getNormalY() {
        return this.normal.y;
    }

    public Vec2 getPoint(int index) {
        return this.points[index];
    }

    public void initialize(Manifold manifold, Transform xfA, float radiusA, Transform xfB, float radiusB) {
        if (manifold.pointCount == 0) {
            return;
        }
        switch (manifold.type) {
            case CIRCLES: {
                Vec2 pointA = this.pool3;
                Vec2 pointB = this.pool4;
                this.normal.x = 1.0f;
                this.normal.y = 0.0f;
                Vec2 v = manifold.localPoint;
                pointA.x = xfA.q.c * v.x - xfA.q.s * v.y + xfA.p.x;
                pointA.y = xfA.q.s * v.x + xfA.q.c * v.y + xfA.p.y;
                Vec2 mp0p = manifold.points[0].localPoint;
                pointB.x = xfB.q.c * mp0p.x - xfB.q.s * mp0p.y + xfB.p.x;
                pointB.y = xfB.q.s * mp0p.x + xfB.q.c * mp0p.y + xfB.p.y;
                if (pointA.distanceSquared(pointB) > 1.4210855E-14f) {
                    this.normal.x = pointB.x - pointA.x;
                    this.normal.y = pointB.y - pointA.y;
                    this.normal.getLengthAndNormalize();
                }
                float cAx = this.normal.x * radiusA + pointA.x;
                float cAy = this.normal.y * radiusA + pointA.y;
                float cBx = -this.normal.x * radiusB + pointB.x;
                float cBy = -this.normal.y * radiusB + pointB.y;
                this.points[0].x = (cAx + cBx) * 0.5f;
                this.points[0].y = (cAy + cBy) * 0.5f;
                break;
            }
            case FACE_A: {
                Vec2 planePoint = this.pool3;
                Rotation.mulToOutUnsafe(xfA.q, manifold.localNormal, this.normal);
                Transform.mulToOut(xfA, manifold.localPoint, planePoint);
                Vec2 clipPoint = this.pool4;
                for (int i = 0; i < manifold.pointCount; ++i) {
                    Transform.mulToOut(xfB, manifold.points[i].localPoint, clipPoint);
                    float scalar = radiusA - ((clipPoint.x - planePoint.x) * this.normal.x + (clipPoint.y - planePoint.y) * this.normal.y);
                    float cAx = this.normal.x * scalar + clipPoint.x;
                    float cAy = this.normal.y * scalar + clipPoint.y;
                    float cBx = -this.normal.x * radiusB + clipPoint.x;
                    float cBy = -this.normal.y * radiusB + clipPoint.y;
                    this.points[i].x = (cAx + cBx) * 0.5f;
                    this.points[i].y = (cAy + cBy) * 0.5f;
                }
                break;
            }
            case FACE_B: {
                Vec2 planePoint = this.pool3;
                Rotation.mulToOutUnsafe(xfB.q, manifold.localNormal, this.normal);
                Transform.mulToOut(xfB, manifold.localPoint, planePoint);
                Vec2 clipPoint = this.pool4;
                for (int i = 0; i < manifold.pointCount; ++i) {
                    Transform.mulToOut(xfA, manifold.points[i].localPoint, clipPoint);
                    float scalar = radiusB - ((clipPoint.x - planePoint.x) * this.normal.x + (clipPoint.y - planePoint.y) * this.normal.y);
                    float cBx = this.normal.x * scalar + clipPoint.x;
                    float cBy = this.normal.y * scalar + clipPoint.y;
                    float cAx = -this.normal.x * radiusA + clipPoint.x;
                    float cAy = -this.normal.y * radiusA + clipPoint.y;
                    this.points[i].x = (cAx + cBx) * 0.5f;
                    this.points[i].y = (cAy + cBy) * 0.5f;
                }
                this.normal.x = -this.normal.x;
                this.normal.y = -this.normal.y;
            }
        }
    }
}

