/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.pool.Pools;
import com.almasb.fxgl.core.util.EmptyRunnable;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.physics.SensorCollisionHandler;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.BodyDef;
import com.almasb.fxgl.physics.box2d.dynamics.BodyType;
import com.almasb.fxgl.physics.box2d.dynamics.FixtureDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.geometry.Point2D;

public final class PhysicsComponent
extends Component {
    FixtureDef fixtureDef = new FixtureDef();
    BodyDef bodyDef = new BodyDef();
    Body body;
    private List<Entity> groundedList = new ArrayList<Entity>();
    private ReadOnlyBooleanWrapper onGroundProperty = new ReadOnlyBooleanWrapper(false);
    private boolean raycastIgnored = false;
    private Runnable onInitPhysics = EmptyRunnable.INSTANCE;
    private PhysicsWorld physicsWorld;
    private Map<HitBox, SensorCollisionHandler> sensorHandlers = new HashMap<HitBox, SensorCollisionHandler>();
    private Vec2 minMeters = (Vec2)Pools.obtain(Vec2.class);

    void setWorld(PhysicsWorld world) {
        this.physicsWorld = world;
    }

    private PhysicsWorld getPhysicsWorld() {
        if (this.physicsWorld == null) {
            throw new IllegalStateException("Physics not initialized yet! Use setOnPhysicsInitialized() instead");
        }
        return this.physicsWorld;
    }

    void onInitPhysics() {
        this.onInitPhysics.run();
    }

    public boolean isOnGround() {
        return !this.groundedList.isEmpty();
    }

    public ReadOnlyBooleanProperty onGroundProperty() {
        return this.onGroundProperty.getReadOnlyProperty();
    }

    public Body getBody() {
        if (this.body == null) {
            throw new IllegalStateException("Physics not initialized yet! Use setOnPhysicsInitialized() instead");
        }
        return this.body;
    }

    public void setOnPhysicsInitialized(Runnable code) {
        this.onInitPhysics = code;
    }

    public Map<HitBox, SensorCollisionHandler> getSensorHandlers() {
        return this.sensorHandlers;
    }

    public void addGroundSensor(HitBox box) {
        this.sensorHandlers.put(box, new SensorCollisionHandler(){

            @Override
            protected void onCollisionBegin(Entity other) {
                PhysicsComponent.this.groundedList.add(other);
                PhysicsComponent.this.onGroundProperty.setValue(Boolean.valueOf(PhysicsComponent.this.isOnGround()));
            }

            @Override
            protected void onCollisionEnd(Entity other) {
                PhysicsComponent.this.groundedList.remove(other);
                PhysicsComponent.this.onGroundProperty.setValue(Boolean.valueOf(PhysicsComponent.this.isOnGround()));
            }
        });
    }

    public void addSensor(HitBox box, SensorCollisionHandler handler) {
        this.sensorHandlers.put(box, handler);
    }

    public void removeSensor(HitBox box) {
        box.unbind();
        this.getPhysicsWorld().destroyFixture(this.body, box);
        this.sensorHandlers.remove(box);
    }

    public void setFixtureDef(FixtureDef def) {
        this.fixtureDef = def;
    }

    public void setBodyDef(BodyDef def) {
        this.bodyDef = def;
    }

    public void setBodyType(BodyType type) {
        this.bodyDef.setType(type);
    }

    public boolean isMovingX() {
        return FXGLMath.abs((double)this.getVelocityX()) > 0.0;
    }

    public boolean isMovingY() {
        return FXGLMath.abs((double)this.getVelocityY()) > 0.0;
    }

    public boolean isMoving() {
        return this.isMovingX() || this.isMovingY();
    }

    public void setLinearVelocity(Point2D vector) {
        this.setBodyLinearVelocity(this.getPhysicsWorld().toVector(vector));
    }

    public void setLinearVelocity(double x, double y) {
        this.setLinearVelocity(new Point2D(x, y));
    }

    public void setVelocityX(double x) {
        this.setLinearVelocity(x, this.getVelocityY());
    }

    public void setVelocityY(double y) {
        this.setLinearVelocity(this.getVelocityX(), y);
    }

    public double getVelocityX() {
        return this.getLinearVelocity().getX();
    }

    public double getVelocityY() {
        return this.getLinearVelocity().getY();
    }

    public void setBodyLinearVelocity(Vec2 vector) {
        this.getBody().setLinearVelocity(vector);
    }

    public Point2D getLinearVelocity() {
        return this.getPhysicsWorld().toVector(this.getBody().getLinearVelocity());
    }

    public void setAngularVelocity(double velocity) {
        this.getBody().setAngularVelocity((float)(-FXGLMath.toRadians((double)velocity)));
    }

    public void applyLinearImpulse(Point2D impulse, Point2D point, boolean wake) {
        this.applyBodyLinearImpulse(this.getPhysicsWorld().toVector(impulse), this.getPhysicsWorld().toPoint(point), wake);
    }

    public void applyBodyLinearImpulse(Vec2 impulse, Vec2 point, boolean wake) {
        this.getBody().applyLinearImpulse(impulse, point, wake);
    }

    public void applyForce(Point2D force, Point2D point) {
        this.applyBodyForce(this.getPhysicsWorld().toVector(force), this.getPhysicsWorld().toPoint(point));
    }

    public void applyBodyForce(Vec2 force, Vec2 point) {
        this.getBody().applyForce(force, point);
    }

    public void applyForceToCenter(Point2D force) {
        this.applyBodyForceToCenter(this.getPhysicsWorld().toVector(force));
    }

    public void applyBodyForceToCenter(Vec2 force) {
        this.getBody().applyForceToCenter(force);
    }

    public void setRaycastIgnored(boolean b) {
        this.raycastIgnored = b;
    }

    public boolean isRaycastIgnored() {
        return this.raycastIgnored;
    }

    @Override
    public void onUpdate(double tpf) {
        if (this.body == null) {
            return;
        }
        this.minMeters.set(this.getBody().getPosition().x - this.getPhysicsWorld().toMetersF(this.entity.getWidth() / 2.0), this.getBody().getPosition().y + this.getPhysicsWorld().toMetersF(this.entity.getHeight() / 2.0));
        Point2D minWorld = this.getPhysicsWorld().toPoint(this.minMeters);
        this.entity.setX(Math.round(minWorld.getX() - this.entity.getBoundingBoxComponent().getMinXLocal()));
        this.entity.setY(Math.round(minWorld.getY() - this.entity.getBoundingBoxComponent().getMinYLocal()));
        this.entity.setRotation(-Math.toDegrees(this.getBody().getAngle()));
    }

    @Override
    public void onRemoved() {
        Pools.free((Object)this.minMeters);
    }

    public void overwritePosition(Point2D point) {
        double w = this.getEntity().getWidth();
        double h = this.getEntity().getHeight();
        Vec2 positionMeters = this.getPhysicsWorld().toPoint(new Point2D(point.getX() + w / 2.0, point.getY() + h / 2.0));
        this.getBody().setTransform(positionMeters, this.getBody().getAngle());
    }

    public void overwriteAngle(double angDegrees) {
        this.getBody().setTransform(this.getBody().getPosition(), (float)(-FXGLMath.toRadians((double)angDegrees)));
    }

    @Override
    public boolean isComponentInjectionRequired() {
        return false;
    }
}

