/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.vector.style;

import android.graphics.Path;
import android.graphics.RectF;
import androidx.annotation.FloatRange;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.vector.style.QrVectorShapeModifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/vector/style/RoundCornersVectorShape;", "Lcom/github/alexzhirkevich/customqrgenerator/vector/style/QrVectorShapeModifier;", "cornerRadius", "", "withNeighbors", "", "(FZ)V", "getCornerRadius", "()F", "getWithNeighbors", "()Z", "createPath", "Landroid/graphics/Path;", "size", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "custom_qr_generator_release"})
public final class RoundCornersVectorShape
implements QrVectorShapeModifier {
    private final float cornerRadius;
    private final boolean withNeighbors;

    public RoundCornersVectorShape(@FloatRange(from=0.0, to=0.5) float cornerRadius, boolean withNeighbors) {
        this.cornerRadius = cornerRadius;
        this.withNeighbors = withNeighbors;
    }

    public final float getCornerRadius() {
        return this.cornerRadius;
    }

    public final boolean getWithNeighbors() {
        return this.withNeighbors;
    }

    @Override
    @NotNull
    public Path createPath(float size, @NotNull Neighbors neighbors) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
        Path $this$createPath_u24lambda_u2d0 = path = new Path();
        boolean bl = false;
        float corner = RangesKt.coerceIn((float)this.cornerRadius, (float)0.0f, (float)0.5f) * size;
        if (this.withNeighbors) {
            float[] fArray = new float[]{!neighbors.getTop() && !neighbors.getLeft() ? corner : 0.0f, !neighbors.getTop() && !neighbors.getLeft() ? corner : 0.0f, !neighbors.getTop() && !neighbors.getRight() ? corner : 0.0f, !neighbors.getTop() && !neighbors.getRight() ? corner : 0.0f, !neighbors.getBottom() && !neighbors.getRight() ? corner : 0.0f, !neighbors.getBottom() && !neighbors.getRight() ? corner : 0.0f, !neighbors.getBottom() && !neighbors.getLeft() ? corner : 0.0f, !neighbors.getBottom() && !neighbors.getLeft() ? corner : 0.0f};
            $this$createPath_u24lambda_u2d0.addRoundRect(new RectF(0.0f, 0.0f, size, size), fArray, Path.Direction.CW);
        } else {
            $this$createPath_u24lambda_u2d0.addRoundRect(new RectF(0.0f, 0.0f, size, size), corner, corner, Path.Direction.CW);
        }
        return path;
    }
}

