/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.style;

import androidx.annotation.FloatRange;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0002\u000b\fJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0003H&\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrShape;", "", "apply", "Lcom/google/zxing/qrcode/encoder/ByteMatrix;", "byteMatrix", "pixelInShape", "", "i", "", "j", "modifiedByteMatrix", "Circle", "Default", "custom_qr_generator_release"})
public interface QrShape {
    @NotNull
    public ByteMatrix apply(@NotNull ByteMatrix var1);

    public boolean pixelInShape(int var1, int var2, @NotNull ByteMatrix var3);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016\u00a8\u0006\f"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrShape$Default;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrShape;", "()V", "apply", "Lcom/google/zxing/qrcode/encoder/ByteMatrix;", "byteMatrix", "pixelInShape", "", "i", "", "j", "modifiedByteMatrix", "custom_qr_generator_release"})
    public static final class Default
    implements QrShape {
        @NotNull
        public static final Default INSTANCE = new Default();

        private Default() {
        }

        @Override
        @NotNull
        public ByteMatrix apply(@NotNull ByteMatrix byteMatrix) {
            Intrinsics.checkNotNullParameter((Object)byteMatrix, (String)"byteMatrix");
            return byteMatrix;
        }

        @Override
        public boolean pixelInShape(int i, int j, @NotNull ByteMatrix modifiedByteMatrix) {
            Intrinsics.checkNotNullParameter((Object)modifiedByteMatrix, (String)"modifiedByteMatrix");
            return true;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\nH\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrShape$Circle;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrShape;", "padding", "", "random", "Lkotlin/random/Random;", "(FLkotlin/random/Random;)V", "getPadding", "()F", "apply", "Lcom/google/zxing/qrcode/encoder/ByteMatrix;", "byteMatrix", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "pixelInShape", "i", "j", "modifiedByteMatrix", "toString", "", "custom_qr_generator_release"})
    public static final class Circle
    implements QrShape {
        private final float padding;
        @NotNull
        private final Random random;

        public Circle(@FloatRange(from=1.0, to=2.0) float padding, @NotNull Random random) {
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            this.padding = padding;
            this.random = random;
        }

        public /* synthetic */ Circle(float f, Random random, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                f = 1.1f;
            }
            if ((n & 2) != 0) {
                random = (Random)Random.Default;
            }
            this(f, random);
        }

        public final float getPadding() {
            return this.padding;
        }

        @Override
        public boolean pixelInShape(int i, int j, @NotNull ByteMatrix modifiedByteMatrix) {
            Intrinsics.checkNotNullParameter((Object)modifiedByteMatrix, (String)"modifiedByteMatrix");
            ByteMatrix $this$pixelInShape_u24lambda_u2d0 = modifiedByteMatrix;
            boolean bl = false;
            float center = (float)$this$pixelInShape_u24lambda_u2d0.getWidth() / 2.0f;
            return (float)Math.sqrt((center - (float)i) * (center - (float)i) + (center - (float)j) * (center - (float)j)) <= center;
        }

        @Override
        @NotNull
        public ByteMatrix apply(@NotNull ByteMatrix byteMatrix) {
            int i;
            Intrinsics.checkNotNullParameter((Object)byteMatrix, (String)"byteMatrix");
            ByteMatrix $this$apply_u24lambda_u2d1 = byteMatrix;
            boolean bl = false;
            if ($this$apply_u24lambda_u2d1.getWidth() != $this$apply_u24lambda_u2d1.getHeight()) {
                throw new IllegalStateException("Non-square ByteMatrix can not be extended to round");
            }
            float padding = RangesKt.coerceIn((float)this.padding, (float)1.0f, (float)2.0f);
            int added = MathKt.roundToInt((double)(((double)((float)$this$apply_u24lambda_u2d1.getWidth() * padding) * Math.sqrt(2.0) - (double)$this$apply_u24lambda_u2d1.getWidth()) / (double)2));
            int newSize = $this$apply_u24lambda_u2d1.getWidth() + 2 * added;
            ByteMatrix newMatrix = new ByteMatrix(newSize, newSize);
            float center = (float)newSize / 2.0f;
            for (i = 0; i < newSize; ++i) {
                for (int j = 0; j < newSize; ++j) {
                    if (!this.random.nextBoolean() || i > added - 1 && j > added - 1 && i < added + $this$apply_u24lambda_u2d1.getWidth() && j < added + $this$apply_u24lambda_u2d1.getWidth() || !((float)Math.sqrt((center - (float)i) * (center - (float)i) + (center - (float)j) * (center - (float)j)) <= center)) continue;
                    newMatrix.set(i, j, 1);
                }
            }
            int n = $this$apply_u24lambda_u2d1.getWidth();
            for (i = 0; i < n; ++i) {
                int n2 = $this$apply_u24lambda_u2d1.getHeight();
                for (int j = 0; j < n2; ++j) {
                    newMatrix.set(added + i, added + j, $this$apply_u24lambda_u2d1.get(i, j));
                }
            }
            return newMatrix;
        }

        public final float component1() {
            return this.padding;
        }

        private final Random component2() {
            return this.random;
        }

        @NotNull
        public final Circle copy(@FloatRange(from=1.0, to=2.0) float padding, @NotNull Random random) {
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            return new Circle(padding, random);
        }

        public static /* synthetic */ Circle copy$default(Circle circle, float f, Random random, int n, Object object) {
            if ((n & 1) != 0) {
                f = circle.padding;
            }
            if ((n & 2) != 0) {
                random = circle.random;
            }
            return circle.copy(f, random);
        }

        @NotNull
        public String toString() {
            return "Circle(padding=" + this.padding + ", random=" + this.random + ')';
        }

        public int hashCode() {
            int result = Float.hashCode(this.padding);
            result = result * 31 + this.random.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Circle)) {
                return false;
            }
            Circle circle = (Circle)other;
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.padding), (Object)Float.valueOf(circle.padding))) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.random, (Object)circle.random);
        }

        public Circle() {
            this(0.0f, null, 3, null);
        }
    }
}

